/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.console.command;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;
import jeus.management.j2ee.servlet.WebEngineMoMBean;
import jeus.servlet.deployment.descriptor.ConnectionDescriptor;
import jeus.servlet.deployment.descriptor.ContextDescriptor;
import jeus.servlet.deployment.descriptor.ContextGroupDescriptor;
import jeus.servlet.deployment.descriptor.ResponseHeaderDescriptor;
import jeus.servlet.deployment.descriptor.SessionDescriptor;
import jeus.servlet.deployment.descriptor.VirtualHostDescriptor;
import jeus.servlet.deployment.descriptor.WebContainerDescriptor;
import jeus.util.IllegalJeusSystemNameException;
import jeus.util.console.Argument;
import jeus.util.console.ArgumentedOption;
import jeus.util.console.JeusImproperCommanderException;
import jeus.util.console.Option;
import jeus.util.console.command.JeusMBeanCommand;
import jeus.util.console.group.ServletEngineGroup;
import jeus.xml.binding.jeusDD.AccessLogType;
import jeus.xml.binding.jeusDD.LoggingType;
import jeus.xml.binding.jeusDD.SessionConfigType;
import jeus.xml.binding.jeusDD.UserLogType;

public class WCConfigInfoCommand
extends JeusMBeanCommand {
    private ArgumentedOption conOption = new ArgumentedOption("con", "container_name", "container where servlet engine is located", "use container.name property or apply to all containers");
    private ArgumentedOption contextGroup = new ArgumentedOption("cg", "context-group", "print the context group configuration");
    private ArgumentedOption virtualHost = new ArgumentedOption("vh", "virtual-host", "print the virtual host configuration");
    private ArgumentedOption context = new ArgumentedOption("c", "context", "print the context configuration");
    private ArgumentedOption listenerId = new ArgumentedOption("cn", "listener-id", "print Connection & Thread Pool configuration");
    private Option log = new Option("log", "print the loggin configuration");
    private Option sessionCluster = new Option("sc", "print the session clustering config");
    private Option responseHeader = new Option("rh", "print the response header config");

    public WCConfigInfoCommand() {
        super("cfg", "report configuration information");
        this.registerArgument((Argument)this.conOption);
        this.registerArgument((Argument)this.contextGroup);
        this.registerArgument((Argument)this.virtualHost);
        this.registerArgument((Argument)this.context);
        this.registerArgument((Argument)this.listenerId);
        this.registerArgument((Argument)this.log);
        this.registerArgument((Argument)this.sessionCluster);
        this.registerArgument((Argument)this.responseHeader);
    }

    public void run(PrintStream out) throws Exception {
        Object webEngineMbeans = null;
        if (this.conOption.isSet()) {
            this.printWebEngineConfig(this.conOption.getValue(), out);
        } else {
            Set<String> containerNames = ServletEngineGroup.getCachedWebEngineMoMBeanMap().keySet();
            for (String containerName : containerNames) {
                this.printWebEngineConfig(containerName, out);
            }
        }
    }

    private void printWebEngineConfig(String containerName, PrintStream out) throws Exception, IllegalJeusSystemNameException {
        if (containerName == null) {
            throw new JeusImproperCommanderException("please set container name by using -con option or setProperty command");
        }
        WebEngineMoMBean mbean = this.getWebEngine(containerName);
        if (mbean == null) {
            throw new JeusImproperCommanderException("there is no engine with such name : " + containerName);
        }
        boolean isAllConfig = !this.contextGroup.isSet() && !this.virtualHost.isSet() && !this.context.isSet() && !this.listenerId.isSet() && !this.log.isSet() && !this.sessionCluster.isSet() && !this.responseHeader.isSet();
        String ctxGroup = this.contextGroup.getValue();
        String vhostName = this.virtualHost.getValue();
        String ctx = this.context.getValue();
        String conn = this.listenerId.getValue();
        String log = this.log.getValue();
        PrintWriter output = new PrintWriter(out, true);
        output.println("\n# # # # Container [ " + containerName + " ] information # # # # # #");
        WebContainerDescriptor webContainerDesc = mbean.getConfigInfo();
        webContainerDesc.printDescriptor(output);
        Enumeration<Object> ctxGroupDescs = null;
        if (ctxGroup != null && !ctxGroup.equals("")) {
            Vector<ContextGroupDescriptor> tmpVec = new Vector<ContextGroupDescriptor>();
            ContextGroupDescriptor desc = webContainerDesc.getContextGroupDescriptor(ctxGroup);
            if (desc != null) {
                tmpVec.addElement(desc);
            }
            ctxGroupDescs = tmpVec.elements();
        } else {
            Hashtable descs = webContainerDesc.getContextGroupDescriptor();
            ctxGroupDescs = descs.elements();
        }
        while (ctxGroupDescs.hasMoreElements()) {
            ResponseHeaderDescriptor rhDesc;
            SessionConfigType sessDescType;
            Enumeration descs;
            VirtualHostDescriptor vhDesc;
            ContextGroupDescriptor ctxGrpDesc = (ContextGroupDescriptor)ctxGroupDescs.nextElement();
            if (isAllConfig || this.contextGroup.isSet()) {
                ctxGrpDesc.printDescriptor(output);
            }
            if (vhostName != null && !vhostName.equals("")) {
                vhDesc = ctxGrpDesc.getVirtualHostDescriptor(vhostName);
                if (vhDesc != null) {
                    vhDesc.printDescriptor(output);
                }
            } else if (isAllConfig || this.contextGroup.isSet() || this.virtualHost.isSet()) {
                ctxGrpDesc.getDefaultVirtualHostDescriptor().printDescriptor(output);
                Enumeration vhDescs = ctxGrpDesc.getVirtualHostDescriptors().elements();
                while (vhDescs.hasMoreElements()) {
                    VirtualHostDescriptor vhDesc2 = (VirtualHostDescriptor)vhDescs.nextElement();
                    vhDesc2.printDescriptor(output);
                }
            }
            if (ctx != null && !ctx.equals("")) {
                ContextDescriptor ctxDesc = ctxGrpDesc.getContextDescriptorByName(ctx);
                if (ctxDesc != null) {
                    ctxDesc.printDescriptor(output);
                }
            } else if (isAllConfig || this.contextGroup.isSet() || this.context.isSet()) {
                vhDesc = ctxGrpDesc.getDefaultVirtualHostDescriptor();
                descs = vhDesc.getContextDescriptors().elements();
                while (descs.hasMoreElements()) {
                    ContextDescriptor ctxDesc = (ContextDescriptor)descs.nextElement();
                    ctxDesc.printDescriptor(output);
                }
                Enumeration vhDescs = ctxGrpDesc.getVirtualHostDescriptors().elements();
                while (vhDescs.hasMoreElements()) {
                    vhDesc = (VirtualHostDescriptor)vhDescs.nextElement();
                    descs = vhDesc.getContextDescriptors().elements();
                    while (descs.hasMoreElements()) {
                        ContextDescriptor ctxDesc = (ContextDescriptor)descs.nextElement();
                        ctxDesc.printDescriptor(output);
                    }
                }
            }
            if (conn != null && !conn.equals("")) {
                ConnectionDescriptor connDesc = ctxGrpDesc.getConnectionDescriptor(conn);
                if (connDesc != null) {
                    connDesc.printDescriptor(output);
                }
            } else if (isAllConfig || this.contextGroup.isSet() || this.listenerId.isSet()) {
                Hashtable connDescs = ctxGrpDesc.getConnectionDescriptor();
                descs = connDescs.elements();
                while (descs.hasMoreElements()) {
                    ConnectionDescriptor connDesc = (ConnectionDescriptor)descs.nextElement();
                    connDesc.printDescriptor(output);
                }
            }
            if (isAllConfig || ctxGroup != null || log != null) {
                out.println("<<<<< Logger Configuration Information >>>>>");
                LoggingType logType = ctxGrpDesc.getLogging();
                if (logType != null) {
                    AccessLogType accessLogType;
                    UserLogType userLogType = logType.getUserLog();
                    if (userLogType != null) {
                        out.println("[User Logger]");
                        out.println(" + level : " + userLogType.getLevel());
                        out.println(" + use parent hadlers" + userLogType.isUseParentHandlers());
                        out.println(" + filter class : " + userLogType.getFilterClass());
                    }
                    if ((accessLogType = logType.getAccessLog()) != null) {
                        out.println("[Access Logger]");
                        out.println(" + enable : " + accessLogType.isEnable());
                        out.println(" + enable-analysis" + accessLogType.isEnableAnalysis());
                        out.println(" + level : " + accessLogType.getLevel());
                        out.println(" + use parent hadlers" + accessLogType.isUseParentHandlers());
                        out.println(" + filter class : " + accessLogType.getFilterClass());
                        out.println(" + format : " + accessLogType.getFormat());
                    }
                }
            }
            if ((isAllConfig || this.sessionCluster.isSet()) && (sessDescType = ctxGrpDesc.getSessionDescType()) != null) {
                output.println(SessionDescriptor.getSessionDescriptorTypeInformation(sessDescType));
            }
            if (!isAllConfig && !this.contextGroup.isSet() && !this.responseHeader.isSet() || (rhDesc = ctxGrpDesc.getResponseHeaderDescriptor()) == null) continue;
            rhDesc.printDescriptor(output);
        }
        output.println("# # # # The end of information page # # # # # # # #\n");
    }
}

