/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.console.command;

import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import javax.management.ObjectName;
import jeus.management.JMXUtility;
import jeus.management.j2ee.WebModuleMBean;
import jeus.management.j2ee.servlet.ContextGroupMoMBean;
import jeus.management.j2ee.servlet.WebEngineMoMBean;
import jeus.util.JeusRuntimeException;
import jeus.util.console.Argument;
import jeus.util.console.ArgumentedOption;
import jeus.util.console.JeusImproperCommanderException;
import jeus.util.console.OptionalArgument;
import jeus.util.console.command.JeusMBeanCommand;
import jeus.util.console.group.ServletEngineGroup;
import jeus.util.message.JeusMessage_JMX;

public class WCSuspendCommand
extends JeusMBeanCommand {
    private ArgumentedOption conOption = new ArgumentedOption("con", "container_name", "container where servlet engine is located", "use container.name property or apply to all containers");
    private Argument contextGroup = new Argument("ContextGroup", "context group name");
    private OptionalArgument context = new OptionalArgument("Context", "context name");
    private OptionalArgument servlet = new OptionalArgument("Servlet", "servlet name");

    public WCSuspendCommand() {
        super("websuspend", "temporarily suspending");
        this.servlet.setPreArg((Argument)this.context);
        this.context.setPreArg(this.contextGroup);
        this.registerArgument((Argument)this.conOption);
        this.registerArgument(this.contextGroup);
        this.registerArgument((Argument)this.context);
        this.registerArgument((Argument)this.servlet);
    }

    public void run(PrintStream out) throws Exception {
        HashMap<Object, Object> webEngineMbeanMap = new HashMap();
        if (this.conOption.isSet()) {
            WebEngineMoMBean webEngine = null;
            String containerName = null;
            try {
                containerName = this.conOption.getValue();
                webEngine = this.getWebEngine(containerName);
            }
            catch (Exception e) {
                out.println("[" + containerName + "] container is downed or not created.");
                out.println("");
                return;
            }
            webEngineMbeanMap.put(containerName, webEngine);
        } else {
            webEngineMbeanMap = ServletEngineGroup.getCachedWebEngineMoMBeanMap();
        }
        if (webEngineMbeanMap == null || webEngineMbeanMap.size() == 0) {
            throw new JeusImproperCommanderException("There is no running container.");
        }
        String ctxgrpName = null;
        String ctxName = null;
        String servletName = null;
        if (this.contextGroup.isSet()) {
            ctxgrpName = this.contextGroup.getValue();
        }
        if (this.context.isSet()) {
            ctxName = this.context.getValue();
        }
        if (this.servlet.isSet()) {
            servletName = this.servlet.getValue();
        }
        WebEngineMoMBean webMBean = null;
        String containerName = null;
        for (Map.Entry<Object, Object> conNamdAndwebMBean : webEngineMbeanMap.entrySet()) {
            ObjectName[] ctxs;
            block21: {
                ObjectName[] ctxgroups;
                block20: {
                    webMBean = (WebEngineMoMBean)conNamdAndwebMBean.getValue();
                    containerName = (String)conNamdAndwebMBean.getKey();
                    ctxgroups = null;
                    try {
                        ctxgroups = JMXUtility.queryMBean(this.utility, containerName, "JeusService", "ContextGroup", ctxgrpName, null, null);
                    }
                    catch (JeusRuntimeException e) {
                        if (e.getMessageNumber() != JeusMessage_JMX.JMX_59) break block20;
                        out.println("Not acceptable input * = : \" \"<white space>\" ? , ");
                        out.println("");
                        return;
                    }
                }
                out.println("");
                out.println("< ContainerName : " + containerName + " >");
                if (ctxgroups == null || ctxgroups.length == 0) {
                    out.println("ContextGroup not found : " + ctxgrpName);
                    continue;
                }
                if (this.contextGroup.isSet() && !this.context.isSet() && !this.servlet.isSet()) {
                    if (!webMBean.suspendContextGroup(ctxgrpName)) {
                        out.println("suspend command failed : ContextGroup = " + ctxgrpName);
                        continue;
                    }
                    out.println("suspend successful");
                    continue;
                }
                if (this.contextGroup.isSet() && this.context.isSet() && !this.servlet.isSet()) {
                    ContextGroupMoMBean mbean = JMXUtility.getProxy(this.utility, ctxgroups[0], ContextGroupMoMBean.class, false);
                    if (!mbean.suspendContext(ctxName)) {
                        out.println("suspend command failed : ContextGroup = " + ctxgrpName + ", Context = " + ctxName);
                        continue;
                    }
                    out.println("suspend successful");
                    continue;
                }
                if (!this.contextGroup.isSet() || !this.context.isSet() || !this.servlet.isSet()) continue;
                ctxs = null;
                try {
                    ctxs = JMXUtility.queryMBean(this.utility, containerName, "WebModule", null, ctxName, null, null);
                }
                catch (JeusRuntimeException e) {
                    if (e.getMessageNumber() != JeusMessage_JMX.JMX_59) break block21;
                    out.println("Not acceptable input * = : \" \"<white space>\" ? , ");
                    out.println("");
                    return;
                }
            }
            if (ctxs == null || ctxs.length == 0) {
                out.println("Context not found : " + ctxName);
                continue;
            }
            WebModuleMBean mbean = JMXUtility.getProxy(this.utility, ctxs[0], WebModuleMBean.class, false);
            if (!mbean.suspendServlet(servletName)) {
                out.println("suspend command failed : ContextGroup = " + ctxgrpName + ", Context = " + ctxName + ", Servlet = " + servletName);
                continue;
            }
            out.println("suspend successful");
        }
    }
}

