/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.file;

import java.io.File;
import jeus.util.file.FileUtils;

public class FileSource {
    private File fileSource = null;
    private boolean isDir = false;

    public FileSource(File f) {
        if (f == null) {
            throw new IllegalArgumentException("null File argument.");
        }
        if (!f.exists()) {
            throw new IllegalArgumentException("File doesn't exist: " + FileUtils.safeGetCanonicalPath((File)f));
        }
        this.isDir = f.isDirectory();
        this.fileSource = f;
    }

    public boolean exists() {
        return this.fileSource != null && this.fileSource.exists();
    }

    public File getSource() {
        return this.fileSource;
    }

    public File getFile() {
        return this.fileSource;
    }

    public boolean isArchive() {
        return !this.isDir;
    }

    public boolean isDirectory() {
        return this.isDir;
    }

    public boolean isDir() {
        return this.isDirectory();
    }

    public String toString() {
        if (this.fileSource == null) {
            return "null FileSource";
        }
        return FileUtils.safeGetCanonicalPath((File)this.fileSource);
    }
}

