/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.logging;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.LogRecord;
import jeus.servlet.engine.HttpServletRequestImpl;
import jeus.servlet.engine.HttpServletResponseImpl;
import jeus.util.SimpleLogDateFormat;
import jeus.util.StringUtil;
import jeus.util.logging.JeusAccessRecord;
import jeus.util.logging.JeusFormatter;
import jeus.util.logging.UserAccessFormatter;

public class AccessFormatter
extends JeusFormatter {
    public static final String FORMAT_PROPERTY = "web.accesslog.format";
    protected SimpleLogDateFormat dateFormat = null;
    protected SimpleDateFormat dateFormat2 = null;
    protected static final String DEFAULT_FORMAT = "[%{yyyy.MM.dd HH:mm:ss}t] %a \"%m %U%q\" %s %D";
    protected static String lineSeparator = StringUtil.lineSeparator;
    protected static String FORMATTER_ID_PREFIX = "JEUS_ACCESS_FORMATTER";
    protected static final String DEFAULT_TIME_FORMAT = "yyyy.MM.dd HH:mm:ss";
    protected String dateFormatString = "yyyy.MM.dd HH:mm:ss";
    protected String FORMATTER_ID;
    private Map propertyMap;
    protected boolean enableLogAnalysis = false;

    public boolean isEnableLogAnalysis() {
        return this.enableLogAnalysis;
    }

    public void setEnableLogAnalysis(boolean enableLogAnalysis) {
        this.enableLogAnalysis = enableLogAnalysis;
    }

    public AccessFormatter() {
    }

    public static AccessFormatter getAccessFormatter(String format) {
        if (format == null || format.equals("")) {
            AccessFormatter formatter = new AccessFormatter(new SimpleLogDateFormat(DEFAULT_TIME_FORMAT));
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(FORMAT_PROPERTY, DEFAULT_FORMAT);
            formatter.setProperty(map);
            return formatter;
        }
        UserAccessFormatter formatter = new UserAccessFormatter(format);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(FORMAT_PROPERTY, format);
        formatter.setProperty(map);
        return formatter;
    }

    protected AccessFormatter(SimpleLogDateFormat df) {
        this.dateFormat = df;
        this.dateFormatString = DEFAULT_TIME_FORMAT;
    }

    public synchronized String format(LogRecord r) {
        if (!(r instanceof JeusAccessRecord)) {
            return "Not JeusAccessRecord for AccessFormatter : " + r.getMessage();
        }
        JeusAccessRecord record = (JeusAccessRecord)((Object)r);
        String formattedMessage = record.getFormattedMessage(this.FORMATTER_ID);
        if (formattedMessage != null) {
            return formattedMessage;
        }
        Date dat = new Date();
        dat.setTime(record.getMillis());
        StringBuffer text = new StringBuffer();
        text.append('[');
        text.append(this.dateFormat.format(dat));
        text.append(']');
        HttpServletRequestImpl request = record.getRequest();
        HttpServletResponseImpl response = record.getResponse();
        text.append(' ').append(request.getRemoteAddr()).append(" \"").append(request.getMethod()).append(' ').append(request.getRequestURI()).append("\" ").append(response.getStatus()).append(' ').append(record.getProcessingTime()).append("ms");
        text.append(lineSeparator);
        formattedMessage = text.toString();
        record.setFormattedMessage(this.FORMATTER_ID, formattedMessage);
        return formattedMessage;
    }

    public void setProperty(Map propertyMap) {
        this.propertyMap = propertyMap;
        this.FORMATTER_ID = FORMATTER_ID_PREFIX;
    }

    public Map getProperty() {
        return this.propertyMap;
    }

    public Map getLogRecord(String message) throws ParseException {
        return Collections.EMPTY_MAP;
    }
}

