/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.logging;

import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import jeus.servlet.engine.HttpServletRequestImpl;
import jeus.servlet.engine.HttpServletResponseImpl;
import jeus.util.logging.JeusAccessRecord;
import jeus.util.logging.JeusLevel;
import jeus.util.logging.JeusLogger;

public class AccessLogger
extends JeusLogger {
    public static final String ACCESS_LOGGER_NAME = "jeus.webaccess";

    protected AccessLogger(String name) {
        super(name);
    }

    public void log(HttpServletRequestImpl request, HttpServletResponseImpl response, long processing) {
        JeusAccessRecord record = new JeusAccessRecord(request, response, processing);
        this.log((LogRecord)((Object)record));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Logger getLogger(String name) {
        Class<Logger> clazz = Logger.class;
        synchronized (Logger.class) {
            JeusLogger logger = (JeusLogger)loggerMap.get(name);
            if (logger != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return logger;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return AccessLogger.initializeLogger(name, AccessLogger.newInstance(name));
        }
    }

    public static Logger initializeLogger(String name, JeusLogger logger) {
        int ix2;
        if (name.startsWith("jeus.servlet")) {
            logger.printEnvRoot = true;
        }
        String predefinedLevelString = null;
        int ix = 1;
        while ((ix2 = name.indexOf(".", ix)) >= 0) {
            String pname = name.substring(0, ix2);
            String loggerLevel = AccessLogger.getLogLevel((String)pname);
            if (loggerLevel != null) {
                predefinedLevelString = loggerLevel;
                AccessLogger.getLogger(pname);
            }
            ix = ix2 + 1;
        }
        String loggerLevel = AccessLogger.getLogLevel((String)name);
        if (loggerLevel != null) {
            predefinedLevelString = loggerLevel;
        }
        LogManager.getLogManager().addLogger((Logger)logger);
        loggerMap.put(name, logger);
        if (predefinedLevelString != null) {
            Level predefinedLevel = JeusLevel.parse((String)predefinedLevelString);
            logger.setPredefinedLevel(predefinedLevel);
            AccessLogger.setAllHandlerLevel((Level)predefinedLevel, (Logger)Logger.getLogger(""));
        } else {
            AccessLogger.setLevelWithParentLogger((Logger)logger);
        }
        AccessLogger.addHandler((String)name, (JeusLogger)logger);
        return logger;
    }

    protected static JeusLogger newInstance(String name) {
        if (name.startsWith(ACCESS_LOGGER_NAME)) {
            return new AccessLogger(name);
        }
        return new JeusLogger(name);
    }
}

