/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.logging;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import jeus.servlet.engine.HttpServletRequestImpl;
import jeus.servlet.engine.HttpServletResponseImpl;
import jeus.util.logging.JeusLogRecord;

public class JeusAccessRecord
extends JeusLogRecord {
    private long processingTime = -1L;
    private long sessionSyncTime;
    private HttpServletRequestImpl request;
    private HttpServletResponseImpl response;
    private String localIP = null;
    private String remoteIP = null;
    private int contentLength = -1;
    private String remoteHostname = null;
    private String protocol = null;
    private String method = null;
    private int serverPort = -1;
    private String status = null;
    private String queryString = null;
    private String requestURL = null;
    private String sessionId = null;
    private String remoteUser = null;
    private String serverName = null;
    private HashMap sessionAttributes = new HashMap();
    private HashMap requestAttributes = new HashMap();
    private HashMap cookieValues = new HashMap();
    private HashMap headerValues = new HashMap();
    private String dateFormat = null;
    private String formattedMessage;
    public static final String[] parameters = new String[]{"remoteIP", "localIP", "contentLength", "protocol", "method", "serverPort", "queryString", "status", "sessionId", "millis", "remoteUser", "requestURL", "serverName", "processingTime", "headerValues", "cookieValues", "requestAttributes", "sessionAttributes"};

    public JeusAccessRecord(Level level, String msg) {
        super(level, msg);
    }

    public JeusAccessRecord(Level level, String message, String loggerName, Date d, String localIP, String remoteIP, int contentLength, String remoteHostname, String protocol, String method, int serverPort, String status, long processing, String queryString, String requestURL, String sessionId, String remoteUser, String serverName, HashMap sessionAttributes, HashMap requestAttributes, HashMap cookieValues, HashMap headerValues, String dateFormat) {
        super(level, message);
        this.setLoggerName(loggerName);
        if (d != null) {
            this.setMillis(d.getTime());
        }
        this.localIP = localIP;
        this.remoteIP = remoteIP;
        this.contentLength = contentLength;
        this.remoteHostname = remoteHostname;
        this.queryString = queryString;
        this.requestURL = requestURL;
        this.sessionId = sessionId;
        this.remoteUser = remoteUser;
        this.serverName = serverName;
        this.sessionAttributes = sessionAttributes;
        this.requestAttributes = requestAttributes;
        this.cookieValues = cookieValues;
        this.headerValues = headerValues;
        this.protocol = protocol;
        this.method = method;
        this.serverPort = serverPort;
        this.status = status;
        this.processingTime = processing;
        this.dateFormat = dateFormat;
    }

    public JeusAccessRecord(HttpServletRequestImpl request, HttpServletResponseImpl response, long processing, long sessionSyncTime) {
        this(request, response, processing);
        this.sessionSyncTime = sessionSyncTime;
    }

    public JeusAccessRecord(HttpServletRequestImpl request, HttpServletResponseImpl response, long processing) {
        super(Level.INFO, "");
        this.request = request;
        this.response = response;
        this.processingTime = processing;
    }

    public Map getLogInfo() {
        Map map = super.getLogInfo();
        map.put("remoteIP", this.getRemoteIP());
        map.put("localIP", this.getLocalIP());
        map.put("contentLength", new Integer(this.getContentLength()));
        map.put("protocol", this.getProtocol());
        map.put("method", this.getMethod());
        map.put("serverPort", new Integer(this.getServerPort()));
        map.put("queryString", this.getQueryString());
        map.put("status", this.getStatus());
        map.put("sessionId", this.getSessionId());
        map.put("remoteUser", this.getRemoteUser());
        map.put("requestURL", this.getRequestURL());
        map.put("serverName", this.getServerName());
        map.put("processingTime", new Long(this.getProcessingTime()));
        map.put("headerValues", this.getHeaderValues());
        map.put("cookieValues", this.getCookieValues());
        map.put("requestAttributes", this.getRequestAttributes());
        map.put("sessionAttributes", this.getSessionAttributes());
        map.put("dateFormat", this.dateFormat);
        return map;
    }

    public String getSourceModuleName() {
        return null;
    }

    public String getLocalizedString() {
        return this.getMessage();
    }

    public int getMessageNumber() {
        return -1;
    }

    public String getJvmId() {
        return null;
    }

    public long getProcessingTime() {
        return this.processingTime;
    }

    public long getSessionSyncTime() {
        return this.sessionSyncTime;
    }

    public HttpServletRequestImpl getRequest() {
        return this.request;
    }

    public HttpServletResponseImpl getResponse() {
        return this.response;
    }

    public String getFormattedMessage(String formatter_id) {
        return this.formattedMessage;
    }

    public void setFormattedMessage(String formatter_id, String formattedMessage) {
        this.formattedMessage = formattedMessage;
    }

    public String getLocalIP() {
        return this.localIP;
    }

    public String getMethod() {
        return this.method;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public String getRemoteHostname() {
        return this.remoteHostname;
    }

    public String getRemoteIP() {
        return this.remoteIP;
    }

    public String getRemoteUser() {
        return this.remoteUser;
    }

    public HashMap getRequestAttributes() {
        return this.requestAttributes;
    }

    public String getRequestURL() {
        return this.requestURL;
    }

    public String getServerName() {
        return this.serverName;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public HashMap getSessionAttributes() {
        return this.sessionAttributes;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String getStatus() {
        return this.status;
    }

    public int getContentLength() {
        return this.contentLength;
    }

    public HashMap getCookieValues() {
        return this.cookieValues;
    }

    public HashMap getHeaderValues() {
        return this.headerValues;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }
}

