/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.objio;

import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.NotActiveException;
import java.io.NotSerializableException;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamConstants;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UTFDataFormatException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Map;
import jeus.util.SecondChanceCacheMap;
import jeus.util.objio.Bits;
import jeus.util.objio.ObjectInOutConstants;
import jeus.util.objio.ObjectStreamClass;
import jeus.util.objio.ObjectStreamField;
import sun.misc.SoftCache;

public class ObjectOutputStream
extends java.io.ObjectOutputStream
implements ObjectOutput,
ObjectStreamConstants {
    private static final SoftCache subclassAudits = new SoftCache(5);
    private Map descriptorCache = null;
    private int maxClassDescCount = ObjectInOutConstants.defaultMaxClassCacheSize;
    private BlockDataOutputStream bout;
    private SimpleHandleTable handles;
    private ReplaceTable subs;
    private SimpleHandleTable constantHandles;
    private int protocol = 2;
    private int depth;
    private byte[] primVals;
    private boolean enableReplace;
    private Object curObj;
    private ObjectStreamClass curDesc;
    private PutFieldImpl curPut;
    private boolean isReset = false;
    private boolean isResetAllCalled = false;
    private boolean isResetObjectDataCalled = false;

    private static native void getFieldValues(Object var0, int var1, long[] var2, char[] var3, byte[] var4, int var5, long[] var6, Object[] var7);

    public ObjectOutputStream(OutputStream out) throws IOException {
        this(out, true);
    }

    public ObjectOutputStream(OutputStream out, boolean headerWrite) throws IOException {
        this.verifySubclass();
        this.bout = new BlockDataOutputStream(out, this);
        this.handles = new SimpleHandleTable(10, 3.0f);
        this.constantHandles = new SimpleHandleTable(10, 3.0f);
        this.subs = new ReplaceTable(10, 3.0f);
        if (ObjectInOutConstants.CLASS_CACHE) {
            this.descriptorCache = new SecondChanceCacheMap(this.maxClassDescCount);
        }
        if (headerWrite) {
            this.writeStreamHeader();
        }
        this.bout.setBlockDataModeJeus(true);
    }

    public final void useProtocolVersion(int version) throws IOException {
        if (this.handles.size() != 0) {
            throw new IllegalStateException("stream non-empty");
        }
        switch (version) {
            case 1: 
            case 2: {
                this.protocol = version;
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown version: " + version);
            }
        }
    }

    protected final void writeObjectOverride(Object obj) throws IOException {
        try {
            this.writeObject0(obj, false);
        }
        catch (IOException ex) {
            if (this.depth == 0) {
                this.writeFatalException(ex);
            }
            throw ex;
        }
    }

    public final void writeUnshared(Object obj) throws IOException {
        try {
            this.writeObject0(obj, true);
        }
        catch (IOException ex) {
            if (this.depth == 0) {
                this.writeFatalException(ex);
            }
            throw ex;
        }
    }

    public final void defaultWriteObject() throws IOException {
        if (this.curObj == null || this.curDesc == null) {
            throw new NotActiveException("not in call to writeObject");
        }
        this.defaultWriteFields(this.curObj, this.curDesc);
    }

    public final ObjectOutputStream.PutField putFields() throws IOException {
        if (this.curPut == null) {
            if (this.curObj == null || this.curDesc == null) {
                throw new NotActiveException("not in call to writeObject");
            }
            this.curPut = new PutFieldImpl(this.curDesc);
        }
        return this.curPut;
    }

    public final void writeFields() throws IOException {
        if (this.curPut == null) {
            throw new NotActiveException("no current PutField object");
        }
        this.curPut.writeFields();
    }

    public final void reset() throws IOException {
        if (this.depth != 0) {
            throw new IOException("stream active");
        }
        this.clear();
        this.isReset = true;
        this.isResetAllCalled = true;
    }

    public final void resetObjectData() throws IOException {
        if (this.depth != 0) {
            throw new IOException("stream active");
        }
        this.clearObjectData();
        this.isReset = true;
        this.isResetObjectDataCalled = true;
    }

    protected void annotateClass(Class cl) throws IOException {
    }

    protected void annotateProxyClass(Class cl) throws IOException {
    }

    protected Object replaceObject(Object obj) throws IOException {
        return obj;
    }

    protected boolean enableReplaceObject(boolean enable) throws SecurityException {
        SecurityManager sm;
        if (enable == this.enableReplace) {
            return enable;
        }
        if (enable && (sm = System.getSecurityManager()) != null) {
            sm.checkPermission(SUBSTITUTION_PERMISSION);
        }
        this.enableReplace = enable;
        return !this.enableReplace;
    }

    protected void writeStreamHeader() throws IOException {
        this.bout.writeShort(-24094);
        this.bout.writeShort(1020);
    }

    public final void write(int val) throws IOException {
        this.bout.write(val);
    }

    public final void write(byte[] buf) throws IOException {
        this.bout.write(buf, 0, buf.length, false);
    }

    public final void write(byte[] buf, int off, int len) throws IOException {
        if (buf == null) {
            throw new NullPointerException();
        }
        int endoff = off + len;
        if (off < 0 || len < 0 || endoff > buf.length || endoff < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.bout.write(buf, off, len, false);
    }

    public final void writeDirect(byte[] buf) throws IOException {
        this.bout.writeDirect(buf, 0, buf.length, false);
    }

    public final void writeDirect(byte[] buf, int off, int len) throws IOException {
        if (buf == null) {
            throw new NullPointerException();
        }
        int endoff = off + len;
        if (off < 0 || len < 0 || endoff > buf.length || endoff < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.bout.writeDirect(buf, off, len, false);
    }

    public final void flush() throws IOException {
        this.bout.flush();
    }

    protected final void drain() throws IOException {
        this.bout.drain();
    }

    public final void close() throws IOException {
        this.flush();
        this.clear();
        this.bout.close();
    }

    public final void writeBoolean(boolean val) throws IOException {
        this.bout.writeBoolean(val);
    }

    public final void writeByte(int val) throws IOException {
        this.bout.writeByte(val);
    }

    public final void writeShort(int val) throws IOException {
        this.bout.writeShort(val);
    }

    public final void writeChar(int val) throws IOException {
        this.bout.writeChar(val);
    }

    public final void writeInt(int val) throws IOException {
        this.bout.writeInt(val);
    }

    public final void writeLong(long val) throws IOException {
        this.bout.writeLong(val);
    }

    public final void writeFloat(float val) throws IOException {
        this.bout.writeFloat(val);
    }

    public final void writeDouble(double val) throws IOException {
        this.bout.writeDouble(val);
    }

    public final void writeBytes(String str) throws IOException {
        this.bout.writeBytes(str);
    }

    public final void writeChars(String str) throws IOException {
        this.bout.writeChars(str);
    }

    public final void writeUTF(String str) throws IOException {
        this.bout.writeUTF(str);
    }

    final int getProtocolVersion() {
        return this.protocol;
    }

    final void writeTypeString(String str) throws IOException {
        if (str == null) {
            this.writeNull();
        } else {
            int handle = this.handles.lookup(str);
            if (handle != -1) {
                this.writeHandle(handle);
            } else {
                this.writeString(str, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifySubclass() {
        Class<?> cl = this.getClass();
        SoftCache softCache = subclassAudits;
        synchronized (softCache) {
            Boolean result = (Boolean)subclassAudits.get(cl);
            if (result == null) {
                result = new Boolean(ObjectOutputStream.auditSubclass(cl));
                subclassAudits.put(cl, (Object)result);
            }
            if (result.booleanValue()) {
                return;
            }
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(SUBCLASS_IMPLEMENTATION_PERMISSION);
        }
    }

    private static boolean auditSubclass(final Class subcl) {
        Boolean result = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                for (Class cl = subcl; cl != ObjectOutputStream.class; cl = cl.getSuperclass()) {
                    try {
                        cl.getDeclaredMethod("writeUnshared", Object.class);
                        return Boolean.FALSE;
                    }
                    catch (NoSuchMethodException ex) {
                        try {
                            cl.getDeclaredMethod("putFields", new Class[0]);
                            return Boolean.FALSE;
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            continue;
                        }
                    }
                }
                return Boolean.TRUE;
            }
        });
        return result;
    }

    private void clear() {
        this.clearObjectData();
        this.constantHandles.clear();
    }

    private void clearObjectData() {
        if (ObjectInOutConstants.CLASS_CACHE) {
            this.descriptorCache.clear();
        }
        this.subs.clear();
        this.handles.clear();
    }

    public final void replace(OutputStream newOutputStream) {
        this.bout.replace(newOutputStream);
    }

    public final void resetForFirst() throws IOException {
        this.resetForFirst(true);
    }

    public final void resetForFirst(boolean writingHeader) throws IOException {
        this.isResetObjectDataCalled = false;
        this.isResetAllCalled = false;
        this.isReset = false;
        this.handles.clear();
        this.constantHandles.clear();
        this.subs.clear();
        if (writingHeader) {
            this.bout.setBlockDataModeJeus(false);
            this.writeStreamHeader();
            this.bout.setBlockDataModeJeus(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject0(Object obj, boolean unshared) throws IOException {
        block38: {
            if (this.depth == 0) {
                this.bout.drain();
            }
            ++this.depth;
            if (this.isReset) {
                this.sendReset();
            }
            try {
                Class<?> repCl;
                int h;
                boolean isExternalizable = obj instanceof Externalizable;
                if (isExternalizable) {
                    this.writeExternalizableObject((Externalizable)obj, unshared);
                    return;
                }
                boolean isClass = obj instanceof Class;
                if (isClass) {
                    this.writeClass((Class)obj, unshared);
                    return;
                }
                boolean isObjectStreamClass = obj instanceof ObjectStreamClass;
                if (isObjectStreamClass) {
                    this.writeClassDesc((ObjectStreamClass)obj, unshared);
                    return;
                }
                if (obj == null || (obj = this.subs.lookup(obj)) == null) {
                    this.writeNull();
                    return;
                }
                if (!unshared && (h = this.handles.lookup(obj)) != -1) {
                    this.writeHandle(h);
                    return;
                }
                Object orig = obj;
                Class<?> cl = obj.getClass();
                ObjectStreamClass desc = null;
                boolean isString = obj instanceof String;
                if (isString) {
                    this.writeString((String)obj, unshared);
                    return;
                }
                while ((desc = ObjectStreamClass.getClassDescriptor(cl, this.descriptorCache)).hasWriteReplaceMethod() && (obj = desc.invokeWriteReplace(obj)) != null && (repCl = obj.getClass()) != cl) {
                    cl = repCl;
                }
                if (this.enableReplace) {
                    Object rep = this.replaceObject(obj);
                    if (rep != obj && rep != null) {
                        cl = rep.getClass();
                        isString = rep instanceof String;
                        if (!isString) {
                            desc = ObjectStreamClass.getClassDescriptor(cl, this.descriptorCache);
                        }
                    }
                    obj = rep;
                }
                if (obj != orig) {
                    this.subs.assign(orig, obj);
                    if (obj == null) {
                        this.writeNull();
                        return;
                    }
                    if (!unshared && (h = this.handles.lookup(obj)) != -1) {
                        this.writeHandle(h);
                        return;
                    }
                    if (obj instanceof Externalizable) {
                        this.writeExternalizableObject((Externalizable)obj, unshared);
                        return;
                    }
                    if (obj instanceof Class) {
                        this.writeClass((Class)obj, unshared);
                        return;
                    }
                    if (obj instanceof ObjectStreamClass) {
                        this.writeClassDesc((ObjectStreamClass)obj, unshared);
                        return;
                    }
                    if (isString) {
                        this.writeString((String)obj, unshared);
                        return;
                    }
                }
                if (cl.isArray()) {
                    this.writeArray(obj, desc, unshared);
                    break block38;
                }
                if (obj instanceof Serializable) {
                    this.writeOrdinaryObject(obj, desc, unshared);
                    break block38;
                }
                if (ObjectInOutConstants.AllowNonserial) {
                    this.writeOrdinaryObject(obj, desc, unshared);
                    break block38;
                }
                throw new NotSerializableException(cl.getName());
            }
            finally {
                --this.depth;
                if (this.depth == 0) {
                    this.bout.drainEndheader();
                }
            }
        }
    }

    private void sendReset() throws IOException {
        if (this.isResetAllCalled) {
            this.bout.setBlockDataModeJeus(false);
            this.bout.writeByte(121);
            this.bout.setBlockDataModeJeus(true);
            this.isResetAllCalled = false;
        }
        if (this.isResetObjectDataCalled) {
            this.bout.setBlockDataModeJeus(false);
            this.bout.writeByte(64);
            this.bout.setBlockDataModeJeus(true);
            this.isResetObjectDataCalled = false;
        }
        this.isReset = false;
    }

    private void writeNull() throws IOException {
        this.bout.writeByte(112);
    }

    private void writeHandle(int handle) throws IOException {
        this.bout.writeByte(113);
        this.bout.writeInt(0x7E0000 + handle);
    }

    private void writeConstantHandle(int handle) throws IOException {
        this.bout.writeByte(63);
        this.bout.writeInt(0x7E0000 + handle);
    }

    private void writeClass(Class cl, boolean unshared) throws IOException {
        this.bout.writeByte(118);
        ObjectStreamClass desc = null;
        desc = ObjectStreamClass.getClassDescriptor(cl, this.descriptorCache);
        this.writeClassDesc(desc, false);
        this.constantHandles.assign(unshared ? null : cl);
    }

    private void writeClassDesc(ObjectStreamClass desc, boolean unshared) throws IOException {
        int handle;
        if (desc == null) {
            this.writeNull();
        } else if (!unshared && (handle = this.constantHandles.lookup(desc)) != -1) {
            this.writeConstantHandle(handle);
        } else if (desc.isProxy()) {
            this.writeProxyDesc2(desc, unshared);
        } else {
            this.writeNonProxyDesc2(desc, unshared);
        }
    }

    private void writeProxyDesc2(ObjectStreamClass desc, boolean unshared) throws IOException {
        this.bout.writeByte(125);
        this.constantHandles.assign(unshared ? null : desc);
        Class cl = desc.forClass();
        Class<?>[] ifaces = cl.getInterfaces();
        this.bout.writeInt(ifaces.length);
        for (int i = 0; i < ifaces.length; ++i) {
            this.bout.writeUTF(ifaces[i].getName());
        }
        this.annotateProxyClass(cl);
        this.writeClassDesc(desc.getSuperDesc(), false);
    }

    private void writeNonProxyDesc2(ObjectStreamClass desc, boolean unshared) throws IOException {
        this.bout.writeByte(114);
        this.constantHandles.assign(unshared ? null : desc);
        desc.writeNonProxy(this);
        Class cl = desc.forClass();
        this.annotateClass(cl);
        if (ObjectInOutConstants.IGNORE_SUPERCLASS_DESC_FOR_WELLKNOWN && desc.isWellKnownPackage) {
            this.writeNull();
        } else {
            this.writeClassDesc(desc.getSuperDesc(), false);
        }
    }

    private void writeString(String str, boolean unshared) throws IOException {
        this.handles.assign(unshared ? null : str);
        long utflen = this.bout.getUTFLength(str);
        if (utflen <= 65535L) {
            if (utflen == (long)str.length()) {
                this.bout.writeByte(53);
                this.bout.writeSimpleString(str, utflen);
            } else {
                this.bout.writeByte(116);
                this.bout.writeUTF(str, utflen);
            }
        } else if (utflen == (long)str.length()) {
            this.bout.writeByte(54);
            this.bout.writeLong(utflen);
            this.writeBytes(str);
        } else {
            this.bout.writeByte(124);
            this.bout.writeLongUTF(str, utflen);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writeArray(Object array, ObjectStreamClass desc, boolean unshared) throws IOException {
        this.handles.assign(unshared ? null : array);
        Class<?> ccl = desc.forClass().getComponentType();
        if (ccl.isPrimitive()) {
            if (ccl == Integer.TYPE) {
                this.bout.writeByte(55);
                int[] ia = (int[])array;
                this.bout.writeInt(ia.length);
                this.bout.writeInts(ia, 0, ia.length);
                return;
            } else if (ccl == Byte.TYPE) {
                this.bout.writeByte(56);
                byte[] ba = (byte[])array;
                this.bout.writeInt(ba.length);
                this.bout.write(ba, 0, ba.length, true);
                return;
            } else if (ccl == Long.TYPE) {
                this.bout.writeByte(57);
                long[] ja = (long[])array;
                this.bout.writeInt(ja.length);
                this.bout.writeLongs(ja, 0, ja.length);
                return;
            } else if (ccl == Float.TYPE) {
                this.bout.writeByte(58);
                float[] fa = (float[])array;
                this.bout.writeInt(fa.length);
                this.bout.writeFloats(fa, 0, fa.length);
                return;
            } else if (ccl == Double.TYPE) {
                this.bout.writeByte(59);
                double[] da = (double[])array;
                this.bout.writeInt(da.length);
                this.bout.writeDoubles(da, 0, da.length);
                return;
            } else if (ccl == Short.TYPE) {
                this.bout.writeByte(60);
                short[] sa = (short[])array;
                this.bout.writeInt(sa.length);
                this.bout.writeShorts(sa, 0, sa.length);
                return;
            } else if (ccl == Character.TYPE) {
                this.bout.writeByte(61);
                char[] ca = (char[])array;
                this.bout.writeInt(ca.length);
                this.bout.writeChars(ca, 0, ca.length);
                return;
            } else {
                if (ccl != Boolean.TYPE) throw new InternalError();
                this.bout.writeByte(62);
                boolean[] za = (boolean[])array;
                this.bout.writeInt(za.length);
                this.bout.writeBooleans(za, 0, za.length);
            }
            return;
        } else {
            this.bout.writeByte(117);
            this.writeClassDesc(desc, false);
            Object[] objs = (Object[])array;
            int len = objs.length;
            this.bout.writeInt(len);
            for (int i = 0; i < len; ++i) {
                this.writeObject0(objs[i], false);
            }
        }
    }

    private void writeOrdinaryObject(Object obj, ObjectStreamClass desc, boolean unshared) throws IOException {
        desc.checkSerialize();
        this.bout.writeByte(115);
        this.writeClassDesc(desc, false);
        this.handles.assign(unshared ? null : obj);
        ObjectStreamClass.ClassDataSlot[] slots = null;
        if (ObjectInOutConstants.AllowNonserial && !desc.isSerializable()) {
            if (desc.isShouldNotBeSerializable) {
                return;
            }
            slots = desc.getClassDataLayoutNonSerial();
        } else {
            slots = desc.getClassDataLayout();
        }
        for (int i = 0; i < slots.length; ++i) {
            ObjectStreamClass slotDesc = slots[i].desc;
            if (slotDesc.hasWriteObjectMethod()) {
                Object oldObj = this.curObj;
                ObjectStreamClass oldDesc = this.curDesc;
                PutFieldImpl oldPut = this.curPut;
                this.curObj = obj;
                this.curDesc = slotDesc;
                this.curPut = null;
                slotDesc.invokeWriteObject(obj, this);
                this.curObj = oldObj;
                this.curDesc = oldDesc;
                this.curPut = oldPut;
                continue;
            }
            this.defaultWriteFields(obj, slotDesc);
        }
    }

    private void writeExternalizableObject(Externalizable obj, boolean unshared) throws IOException {
        int h;
        if (!unshared && (h = this.handles.lookup(obj)) != -1) {
            this.writeHandle(h);
            return;
        }
        ObjectStreamClass desc = null;
        Class<?> cl = obj.getClass();
        desc = ObjectStreamClass.getClassDescriptor(cl, this.descriptorCache);
        this.bout.writeByte(115);
        this.writeClassDesc(desc, false);
        this.handles.assign(unshared ? null : obj);
        Object oldObj = this.curObj;
        ObjectStreamClass oldDesc = this.curDesc;
        PutFieldImpl oldPut = this.curPut;
        this.curObj = obj;
        this.curDesc = null;
        this.curPut = null;
        obj.writeExternal(this);
        this.curObj = oldObj;
        this.curDesc = oldDesc;
        this.curPut = oldPut;
    }

    private void defaultWriteFields(Object obj, ObjectStreamClass desc) throws IOException {
        if (ObjectInOutConstants.AllowNonserial && !desc.isSerializable() && desc.isShouldNotBeSerializable) {
            return;
        }
        desc.checkDefaultSerialize();
        int primDataSize = desc.getPrimDataSize();
        if (this.primVals == null || this.primVals.length < primDataSize) {
            this.primVals = new byte[primDataSize];
        }
        ObjectStreamField[] fields = desc.getFields(false);
        Object[] objVals = new Object[desc.getNumObjFields()];
        int numPrimFields = fields.length - objVals.length;
        if (ObjectStreamClass.UseReflect) {
            if (desc.objFieldIDs != null && desc.objFieldIDs.length > 0) {
                if (desc.primDataSize > 0) {
                    ObjectStreamClass.getPrimitiveValues(obj, fields, this.primVals);
                    ObjectStreamClass.getObjectValues(obj, fields, objVals);
                } else {
                    ObjectStreamClass.getObjectValues(obj, fields, objVals);
                }
            } else if (desc.primDataSize > 0) {
                ObjectStreamClass.getPrimitiveValues(obj, fields, this.primVals);
            }
        } else if (desc.objFieldIDs != null && desc.objFieldIDs.length > 0) {
            if (desc.primDataSize > 0) {
                ObjectOutputStream.getFieldValues(obj, desc.primDataSize, desc.primFieldIDs, desc.primFieldTypecodes, this.primVals, desc.objFieldIDs.length, desc.objFieldIDs, objVals);
            } else {
                ObjectOutputStream.getFieldValues(obj, -1, null, null, null, desc.objFieldIDs.length, desc.objFieldIDs, objVals);
            }
        } else if (desc.primDataSize > 0) {
            ObjectOutputStream.getFieldValues(obj, desc.primDataSize, desc.primFieldIDs, desc.primFieldTypecodes, this.primVals, -1, null, null);
        }
        if (primDataSize > 0) {
            this.bout.write(this.primVals, 0, primDataSize, false);
        }
        for (int i = 0; i < objVals.length; ++i) {
            this.writeObject0(objVals[i], fields[numPrimFields + i].isUnshared());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFatalException(IOException ex) throws IOException {
        this.clear();
        this.bout.writeByte(123);
        this.writeObject0(ex, false);
        this.clear();
    }

    private static native void floatsToBytes(float[] var0, int var1, byte[] var2, int var3, int var4);

    private static native void doublesToBytes(double[] var0, int var1, byte[] var2, int var3, int var4);

    static {
        try {
            System.loadLibrary("JeusObjIO");
        }
        catch (Throwable th) {
            ObjectStreamClass.UseReflect = true;
        }
    }

    private static class ReplaceTable {
        private final SimpleHandleTable htab;
        private Object[] reps;

        ReplaceTable(int initialCapacity, float loadFactor) {
            this.htab = new SimpleHandleTable(initialCapacity, loadFactor);
            this.reps = new Object[initialCapacity];
        }

        void assign(Object obj, Object rep) {
            int index = this.htab.assign(obj);
            while (index >= this.reps.length) {
                this.grow();
            }
            this.reps[index] = rep;
        }

        Object lookup(Object obj) {
            int index = this.htab.lookup(obj);
            return index >= 0 ? this.reps[index] : obj;
        }

        void clear() {
            Arrays.fill(this.reps, 0, this.htab.size(), null);
            this.htab.clear();
        }

        int size() {
            return this.htab.size();
        }

        private void grow() {
            Object[] newReps = new Object[(this.reps.length << 1) + 1];
            System.arraycopy(this.reps, 0, newReps, 0, this.reps.length);
            this.reps = newReps;
        }
    }

    private static class SimpleHandleTable {
        private int size;
        private int threshold;
        private final float loadFactor;
        private int[] spine;
        private int[] next;
        private Object[] objs;

        SimpleHandleTable(int initialCapacity, float loadFactor) {
            this.loadFactor = loadFactor;
            this.spine = new int[initialCapacity];
            this.next = new int[initialCapacity];
            this.objs = new Object[initialCapacity];
            this.threshold = (int)((float)initialCapacity * loadFactor);
            this.clear();
        }

        final int assign(Object obj) {
            if (this.size >= this.next.length) {
                this.growEntries();
            }
            if (this.size >= this.threshold) {
                this.growSpine();
            }
            this.insert(obj, this.size);
            return this.size++;
        }

        final int lookup(Object obj) {
            if (this.size == 0) {
                return -1;
            }
            int index = this.hash(obj) % this.spine.length;
            int i = this.spine[index];
            while (i >= 0) {
                if (this.objs[i] == obj) {
                    return i;
                }
                i = this.next[i];
            }
            return -1;
        }

        final void clear() {
            Arrays.fill(this.spine, -1);
            Arrays.fill(this.objs, 0, this.size, null);
            this.size = 0;
        }

        final int size() {
            return this.size;
        }

        private void insert(Object obj, int handle) {
            int index = this.hash(obj) % this.spine.length;
            this.objs[handle] = obj;
            this.next[handle] = this.spine[index];
            this.spine[index] = handle;
        }

        private void growSpine() {
            this.spine = new int[(this.spine.length << 1) + 1];
            this.threshold = (int)((float)this.spine.length * this.loadFactor);
            Arrays.fill(this.spine, -1);
            for (int i = 0; i < this.size; ++i) {
                this.insert(this.objs[i], i);
            }
        }

        private void growEntries() {
            int newLength = (this.next.length << 1) + 1;
            int[] newNext = new int[newLength];
            System.arraycopy(this.next, 0, newNext, 0, this.size);
            this.next = newNext;
            Object[] newObjs = new Object[newLength];
            System.arraycopy(this.objs, 0, newObjs, 0, this.size);
            this.objs = newObjs;
        }

        private int hash(Object obj) {
            return System.identityHashCode(obj) & Integer.MAX_VALUE;
        }
    }

    private static class BlockDataOutputStream
    extends OutputStream
    implements DataOutput {
        private static final int MAX_BLOCK_SIZE = ObjectInOutConstants.MAX_BLOCK_SIZE;
        private static final int MAX_HEADER_SIZE = 5;
        private static final int CHAR_BUF_SIZE = ObjectInOutConstants.CHAR_BUF_SIZE;
        private final byte[] buf = new byte[MAX_BLOCK_SIZE];
        private final byte[] hbuf = new byte[5];
        private final char[] cbuf = new char[CHAR_BUF_SIZE];
        private boolean blkmode = false;
        private int pos = 0;
        private OutputStream out;
        private final DataOutputStream dout;
        private ObjectOutputStream joos;

        BlockDataOutputStream(OutputStream out, ObjectOutputStream _joos) {
            this.out = out;
            this.joos = _joos;
            this.dout = new DataOutputStream(this);
        }

        final boolean setBlockDataModeJeus(boolean mode) throws IOException {
            if (this.blkmode == mode) {
                return this.blkmode;
            }
            this.drain();
            this.blkmode = mode;
            return !this.blkmode;
        }

        final void replace(OutputStream newOS) {
            this.out = newOS;
        }

        final boolean getBlockDataMode() {
            return this.blkmode;
        }

        public final void write(int b) throws IOException {
            if (this.pos >= MAX_BLOCK_SIZE) {
                this.drain();
            }
            this.buf[this.pos++] = (byte)b;
        }

        public final void write(byte[] b) throws IOException {
            this.write(b, 0, b.length, false);
        }

        public final void write(byte[] b, int off, int len) throws IOException {
            this.write(b, off, len, false);
        }

        public final void flush() throws IOException {
            this.drain();
            this.out.flush();
        }

        public final void close() throws IOException {
            this.flush();
            this.out.close();
        }

        final void writeDirect(byte[] b, int off, int len, boolean copy) throws IOException {
            this.drain();
            this.out.write(b, off, len);
        }

        final void write(byte[] b, int off, int len, boolean copy) throws IOException {
            if (!copy && !this.blkmode) {
                this.drain();
                this.out.write(b, off, len);
                return;
            }
            while (len > 0) {
                if (this.pos >= MAX_BLOCK_SIZE) {
                    this.drain();
                }
                if (len >= MAX_BLOCK_SIZE && !copy && this.pos == 0) {
                    this.writeBlockHeader(MAX_BLOCK_SIZE);
                    this.out.write(b, off, MAX_BLOCK_SIZE);
                    off += MAX_BLOCK_SIZE;
                    len -= MAX_BLOCK_SIZE;
                    continue;
                }
                int wlen = Math.min(len, MAX_BLOCK_SIZE - this.pos);
                System.arraycopy(b, off, this.buf, this.pos, wlen);
                this.pos += wlen;
                off += wlen;
                len -= wlen;
            }
        }

        final void drain() throws IOException {
            if (this.pos == 0) {
                return;
            }
            if (this.blkmode) {
                this.writeBlockHeader(this.pos);
            }
            this.out.write(this.buf, 0, this.pos);
            this.pos = 0;
        }

        final void drainEndheader() throws IOException {
            if (this.pos == 0) {
                return;
            }
            if (this.blkmode) {
                this.writeEndBlockHeader(this.pos);
            }
            this.out.write(this.buf, 0, this.pos);
            this.pos = 0;
        }

        private void writeBlockHeader(int len) throws IOException {
            if (this.joos.depth != 0) {
                if (len <= 255) {
                    this.hbuf[0] = 49;
                    this.hbuf[1] = (byte)len;
                    this.out.write(this.hbuf, 0, 2);
                } else {
                    this.hbuf[0] = 51;
                    Bits.putInt(this.hbuf, 1, len);
                    this.out.write(this.hbuf, 0, 5);
                }
            } else if (len <= 255) {
                this.hbuf[0] = 119;
                this.hbuf[1] = (byte)len;
                this.out.write(this.hbuf, 0, 2);
            } else {
                this.hbuf[0] = 122;
                Bits.putInt(this.hbuf, 1, len);
                this.out.write(this.hbuf, 0, 5);
            }
        }

        private void writeEndBlockHeader(int len) throws IOException {
            if (this.joos.depth == 0) {
                if (len <= 255) {
                    this.hbuf[0] = 50;
                    this.hbuf[1] = (byte)len;
                    this.out.write(this.hbuf, 0, 2);
                } else {
                    this.hbuf[0] = 52;
                    Bits.putInt(this.hbuf, 1, len);
                    this.out.write(this.hbuf, 0, 5);
                }
            }
        }

        public final void writeBoolean(boolean v) throws IOException {
            if (this.pos >= MAX_BLOCK_SIZE) {
                this.drain();
            }
            Bits.putBoolean(this.buf, this.pos++, v);
        }

        public final void writeByte(int v) throws IOException {
            if (this.pos >= MAX_BLOCK_SIZE) {
                this.drain();
            }
            this.buf[this.pos++] = (byte)v;
        }

        public final void writeChar(int v) throws IOException {
            if (this.pos + 2 > MAX_BLOCK_SIZE) {
                this.drain();
            }
            Bits.putChar(this.buf, this.pos, (char)v);
            this.pos += 2;
        }

        public final void writeShort(int v) throws IOException {
            if (this.pos + 2 > MAX_BLOCK_SIZE) {
                this.drain();
            }
            Bits.putShort(this.buf, this.pos, (short)v);
            this.pos += 2;
        }

        public final void writeInt(int v) throws IOException {
            if (this.pos + 4 > MAX_BLOCK_SIZE) {
                this.drain();
            }
            Bits.putInt(this.buf, this.pos, v);
            this.pos += 4;
        }

        public final void writeFloat(float v) throws IOException {
            if (this.pos + 4 > MAX_BLOCK_SIZE) {
                this.drain();
            }
            Bits.putFloat(this.buf, this.pos, v);
            this.pos += 4;
        }

        public final void writeLong(long v) throws IOException {
            if (this.pos + 8 > MAX_BLOCK_SIZE) {
                this.drain();
            }
            Bits.putLong(this.buf, this.pos, v);
            this.pos += 8;
        }

        public final void writeDouble(double v) throws IOException {
            if (this.pos + 8 > MAX_BLOCK_SIZE) {
                this.drain();
            }
            Bits.putDouble(this.buf, this.pos, v);
            this.pos += 8;
        }

        public void writeBytes(String s) throws IOException {
            int n;
            int endoff = s.length();
            int cpos = 0;
            int csize = 0;
            for (int off = 0; off < endoff; off += n) {
                if (cpos >= csize) {
                    cpos = 0;
                    csize = Math.min(endoff - off, CHAR_BUF_SIZE);
                    s.getChars(off, off + csize, this.cbuf, 0);
                }
                if (this.pos >= MAX_BLOCK_SIZE) {
                    this.drain();
                }
                n = Math.min(csize - cpos, MAX_BLOCK_SIZE - this.pos);
                int stop = this.pos + n;
                while (this.pos < stop) {
                    this.buf[this.pos++] = (byte)this.cbuf[cpos++];
                }
            }
        }

        public final void writeChars(String s) throws IOException {
            int csize;
            int endoff = s.length();
            for (int off = 0; off < endoff; off += csize) {
                csize = Math.min(endoff - off, CHAR_BUF_SIZE);
                s.getChars(off, off + csize, this.cbuf, 0);
                if (this.pos + csize > MAX_BLOCK_SIZE) {
                    this.drain();
                }
                for (int k = 0; k < csize; ++k) {
                    Bits.putChar(this.buf, this.pos, this.cbuf[k]);
                    this.pos += 2;
                }
            }
        }

        public final void writeUTF(String s) throws IOException {
            this.writeUTF(s, this.getUTFLength(s));
        }

        final void writeBooleans(boolean[] v, int off, int len) throws IOException {
            int endoff = off + len;
            while (off < endoff) {
                if (this.pos >= MAX_BLOCK_SIZE) {
                    this.drain();
                }
                int stop = Math.min(endoff, off + (MAX_BLOCK_SIZE - this.pos));
                while (off < stop) {
                    Bits.putBoolean(this.buf, this.pos++, v[off++]);
                }
            }
        }

        final void writeChars(char[] v, int off, int len) throws IOException {
            int limit = MAX_BLOCK_SIZE - 2;
            int endoff = off + len;
            while (off < endoff) {
                if (this.pos <= limit) {
                    int avail = MAX_BLOCK_SIZE - this.pos >> 1;
                    int stop = Math.min(endoff, off + avail);
                    while (off < stop) {
                        Bits.putChar(this.buf, this.pos, v[off++]);
                        this.pos += 2;
                    }
                    continue;
                }
                this.dout.writeChar(v[off++]);
            }
        }

        final void writeShorts(short[] v, int off, int len) throws IOException {
            int limit = MAX_BLOCK_SIZE - 2;
            int endoff = off + len;
            while (off < endoff) {
                if (this.pos <= limit) {
                    int avail = MAX_BLOCK_SIZE - this.pos >> 1;
                    int stop = Math.min(endoff, off + avail);
                    while (off < stop) {
                        Bits.putShort(this.buf, this.pos, v[off++]);
                        this.pos += 2;
                    }
                    continue;
                }
                this.dout.writeShort(v[off++]);
            }
        }

        final void writeInts(int[] v, int off, int len) throws IOException {
            int limit = MAX_BLOCK_SIZE - 4;
            int endoff = off + len;
            while (off < endoff) {
                if (this.pos <= limit) {
                    int avail = MAX_BLOCK_SIZE - this.pos >> 2;
                    int stop = Math.min(endoff, off + avail);
                    while (off < stop) {
                        Bits.putInt(this.buf, this.pos, v[off++]);
                        this.pos += 4;
                    }
                    continue;
                }
                this.dout.writeInt(v[off++]);
            }
        }

        final void writeFloats(float[] v, int off, int len) throws IOException {
            int limit = MAX_BLOCK_SIZE - 4;
            int endoff = off + len;
            while (off < endoff) {
                if (this.pos <= limit) {
                    int avail = MAX_BLOCK_SIZE - this.pos >> 2;
                    int chunklen = Math.min(endoff - off, avail);
                    if (ObjectStreamClass.UseReflect) {
                        for (int i = 0; i < chunklen; ++i) {
                            Bits.putFloat(this.buf, this.pos + i << 2, v[off + i]);
                        }
                    } else {
                        ObjectOutputStream.floatsToBytes(v, off, this.buf, this.pos, chunklen);
                    }
                    off += chunklen;
                    this.pos += chunklen << 2;
                    continue;
                }
                this.dout.writeFloat(v[off++]);
            }
        }

        final void writeLongs(long[] v, int off, int len) throws IOException {
            int limit = MAX_BLOCK_SIZE - 8;
            int endoff = off + len;
            while (off < endoff) {
                if (this.pos <= limit) {
                    int avail = MAX_BLOCK_SIZE - this.pos >> 3;
                    int stop = Math.min(endoff, off + avail);
                    while (off < stop) {
                        Bits.putLong(this.buf, this.pos, v[off++]);
                        this.pos += 8;
                    }
                    continue;
                }
                this.dout.writeLong(v[off++]);
            }
        }

        final void writeDoubles(double[] v, int off, int len) throws IOException {
            int limit = MAX_BLOCK_SIZE - 8;
            int endoff = off + len;
            while (off < endoff) {
                if (this.pos <= limit) {
                    int avail = MAX_BLOCK_SIZE - this.pos >> 3;
                    int chunklen = Math.min(endoff - off, avail);
                    if (ObjectStreamClass.UseReflect) {
                        for (int i = 0; i < chunklen; ++i) {
                            Bits.putDouble(this.buf, this.pos + i << 2, v[off + i]);
                        }
                    } else {
                        ObjectOutputStream.doublesToBytes(v, off, this.buf, this.pos, chunklen);
                    }
                    off += chunklen;
                    this.pos += chunklen << 3;
                    continue;
                }
                this.dout.writeDouble(v[off++]);
            }
        }

        final long getUTFLength(String s) {
            int csize;
            int len = s.length();
            long utflen = 0L;
            for (int off = 0; off < len; off += csize) {
                csize = Math.min(len - off, CHAR_BUF_SIZE);
                s.getChars(off, off + csize, this.cbuf, 0);
                for (int cpos = 0; cpos < csize; ++cpos) {
                    char c = this.cbuf[cpos];
                    if (c >= '\u0001' && c <= '\u007f') {
                        ++utflen;
                        continue;
                    }
                    if (c > '\u07ff') {
                        utflen += 3L;
                        continue;
                    }
                    utflen += 2L;
                }
            }
            return utflen;
        }

        final void writeUTF(String s, long utflen) throws IOException {
            if (utflen > 65535L) {
                throw new UTFDataFormatException();
            }
            this.writeShort((int)utflen);
            if (utflen == (long)s.length()) {
                if (utflen > (long)CHAR_BUF_SIZE) {
                    this.writeBytes(s);
                } else {
                    if ((long)this.pos + utflen > (long)MAX_BLOCK_SIZE) {
                        this.drain();
                    }
                    int i = 0;
                    while ((long)i < utflen) {
                        this.buf[this.pos++] = (byte)this.cbuf[i];
                        ++i;
                    }
                }
            } else {
                this.writeUTFBody(s);
            }
        }

        final void writeSimpleString(String s, long utflen) throws IOException {
            if (utflen > 65535L) {
                throw new UTFDataFormatException();
            }
            this.writeShort((int)utflen);
            if (utflen > (long)CHAR_BUF_SIZE) {
                this.writeBytes(s);
            } else {
                if ((long)this.pos + utflen > (long)MAX_BLOCK_SIZE) {
                    this.drain();
                }
                int i = 0;
                while ((long)i < utflen) {
                    this.buf[this.pos++] = (byte)this.cbuf[i];
                    ++i;
                }
            }
        }

        final void writeLongUTF(String s) throws IOException {
            this.writeLongUTF(s, this.getUTFLength(s));
        }

        final void writeLongUTF(String s, long utflen) throws IOException {
            this.writeLong(utflen);
            if (utflen == (long)s.length()) {
                this.writeBytes(s);
            } else {
                this.writeUTFBody(s);
            }
        }

        private void writeUTFBody(String s) throws IOException {
            int csize;
            int limit = MAX_BLOCK_SIZE - 3;
            int len = s.length();
            for (int off = 0; off < len; off += csize) {
                csize = Math.min(len - off, CHAR_BUF_SIZE);
                s.getChars(off, off + csize, this.cbuf, 0);
                for (int cpos = 0; cpos < csize; ++cpos) {
                    char c = this.cbuf[cpos];
                    if (this.pos <= limit) {
                        if (c <= '\u007f' && c != '\u0000') {
                            this.buf[this.pos++] = (byte)c;
                            continue;
                        }
                        if (c > '\u07ff') {
                            this.buf[this.pos + 2] = (byte)(0x80 | c >> 0 & 0x3F);
                            this.buf[this.pos + 1] = (byte)(0x80 | c >> 6 & 0x3F);
                            this.buf[this.pos + 0] = (byte)(0xE0 | c >> 12 & 0xF);
                            this.pos += 3;
                            continue;
                        }
                        this.buf[this.pos + 1] = (byte)(0x80 | c >> 0 & 0x3F);
                        this.buf[this.pos + 0] = (byte)(0xC0 | c >> 6 & 0x1F);
                        this.pos += 2;
                        continue;
                    }
                    if (c <= '\u007f' && c != '\u0000') {
                        this.write(c);
                        continue;
                    }
                    if (c > '\u07ff') {
                        this.write(0xE0 | c >> 12 & 0xF);
                        this.write(0x80 | c >> 6 & 0x3F);
                        this.write(0x80 | c >> 0 & 0x3F);
                        continue;
                    }
                    this.write(0xC0 | c >> 6 & 0x1F);
                    this.write(0x80 | c >> 0 & 0x3F);
                }
            }
        }
    }

    private class PutFieldImpl
    extends ObjectOutputStream.PutField {
        private final ObjectStreamClass desc;
        private final byte[] primVals;
        private final Object[] objVals;

        PutFieldImpl(ObjectStreamClass desc) {
            this.desc = desc;
            this.primVals = new byte[desc.getPrimDataSize()];
            this.objVals = new Object[desc.getNumObjFields()];
        }

        public void put(String name, boolean val) {
            Bits.putBoolean(this.primVals, this.getFieldOffset(name, Boolean.TYPE), val);
        }

        public void put(String name, byte val) {
            this.primVals[this.getFieldOffset((String)name, Byte.TYPE)] = val;
        }

        public void put(String name, char val) {
            Bits.putChar(this.primVals, this.getFieldOffset(name, Character.TYPE), val);
        }

        public void put(String name, short val) {
            Bits.putShort(this.primVals, this.getFieldOffset(name, Short.TYPE), val);
        }

        public void put(String name, int val) {
            Bits.putInt(this.primVals, this.getFieldOffset(name, Integer.TYPE), val);
        }

        public void put(String name, float val) {
            Bits.putFloat(this.primVals, this.getFieldOffset(name, Float.TYPE), val);
        }

        public void put(String name, long val) {
            Bits.putLong(this.primVals, this.getFieldOffset(name, Long.TYPE), val);
        }

        public void put(String name, double val) {
            Bits.putDouble(this.primVals, this.getFieldOffset(name, Double.TYPE), val);
        }

        public void put(String name, Object val) {
            this.objVals[this.getFieldOffset((String)name, Object.class)] = val;
        }

        public void write(ObjectOutput out) throws IOException {
            out.write(this.primVals, 0, this.primVals.length);
            ObjectStreamField[] fields = this.desc.getFields(false);
            int numPrimFields = fields.length - this.objVals.length;
            for (int i = 0; i < this.objVals.length; ++i) {
                if (fields[numPrimFields + i].isUnshared()) {
                    throw new IOException("cannot write unshared object");
                }
                out.writeObject(this.objVals[i]);
            }
        }

        void writeFields() throws IOException {
            ObjectOutputStream.this.bout.write(this.primVals, 0, this.primVals.length, false);
            ObjectStreamField[] fields = this.desc.getFields(false);
            int numPrimFields = fields.length - this.objVals.length;
            for (int i = 0; i < this.objVals.length; ++i) {
                ObjectOutputStream.this.writeObject0(this.objVals[i], fields[numPrimFields + i].isUnshared());
            }
        }

        private int getFieldOffset(String name, Class type) {
            ObjectStreamField field = this.desc.getField(name, type);
            if (field == null) {
                throw new IllegalArgumentException("no such field");
            }
            return field.getOffset();
        }
    }
}

