/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.reflect.runtime;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import jeus.util.reflect.AnnotationInfo;
import jeus.util.reflect.TypeInfo;
import jeus.util.reflect.util.AnnotationUtils;

public abstract class BasicInfoSupport {
    protected AnnotatedElement element;

    AnnotationInfo[] getAnnotationInfosFrom(Annotation[] anns) {
        if (anns == null) {
            return null;
        }
        AnnotationInfo[] annInfos = new AnnotationInfo[anns.length];
        for (int i = 0; i < anns.length; ++i) {
            annInfos[i] = AnnotationUtils.getAnnotationInfo(anns[i]);
        }
        return annInfos;
    }

    public boolean isAnnotationPresent(TypeInfo annotationType) {
        try {
            return this.element.isAnnotationPresent(annotationType.getClassObject());
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    public AnnotationInfo getAnnotation(TypeInfo annotationType) {
        try {
            Object ann = this.element.getAnnotation(annotationType.getClassObject());
            return AnnotationUtils.getAnnotationInfo(ann);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public AnnotationInfo[] getAnnotations() {
        Annotation[] anns = this.element.getAnnotations();
        return this.getAnnotationInfosFrom(anns);
    }

    public AnnotationInfo[] getDeclaredAnnotations() {
        Annotation[] anns = this.element.getDeclaredAnnotations();
        return this.getAnnotationInfosFrom(anns);
    }
}

