/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.sysmon;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import jeus.util.sysmon.CPUMonitor;
import jeus.util.sysmon.CPUStat;
import jeus.util.sysmon.CPUStats;

public class LinuxCPUMonitor
extends CPUMonitor {
    static final File statFile = new File("/proc/stat");
    static final int CPU_USER = 0;
    static final int CPU_SYS = 2;
    static final int CPU_IDLE = 3;
    static final int CPU_WAIT = 5;

    LinuxCPUMonitor() {
    }

    protected CPUStats getCurrentCPUStats() {
        CPUStat[] stats = new CPUStat[numProcessors];
        CPUStat totalStat = null;
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new FileReader(statFile));
            int cpuIndex = 0;
            while ((line = reader.readLine()) != null) {
                if (!line.startsWith("cpu")) {
                    break;
                }
                StringTokenizer tokens = new StringTokenizer(line, " \t", false);
                ArrayList<String> list = new ArrayList<String>(8);
                while (tokens.hasMoreTokens()) {
                    list.add(tokens.nextToken());
                }
                assert (list.size() >= 7);
                String cpuId = (String)list.get(0);
                long user = Long.parseLong((String)list.get(1));
                long system = Long.parseLong((String)list.get(3));
                long wait = Long.parseLong((String)list.get(6));
                long idle = Long.parseLong((String)list.get(4));
                CPUStat stat = new CPUStat(cpuId, user, system, wait, idle);
                if (cpuId.equals("cpu")) {
                    totalStat = stat;
                    continue;
                }
                int index = cpuIndex++;
                stats[index] = stat;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Could not read file /proc/stat", e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return new CPUStats(totalStat, stats);
    }

    protected void doStart() {
    }

    protected void doStop() {
    }
}

