/*
 * Decompiled with CFR 0.152.
 */
package jeus.webserver;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Hashtable;
import java.util.StringTokenizer;
import jeus.webserver.RemoteWebServerProxyImpl;
import jeus.webserver.Shmc;

public class RemoteShmc
extends Shmc {
    Socket socket;
    InputStream in;
    OutputStream out;
    boolean info_existed = false;
    boolean[] svrinfo_existed;
    Hashtable info = new Hashtable();
    Hashtable[] svr_info;

    public RemoteShmc(Socket soc) {
        this.socket = soc;
        try {
            this.in = this.socket.getInputStream();
            this.out = this.socket.getOutputStream();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public int register() {
        String statusPacket = "935/SHMREG";
        int recvLen = 4 + "SUCCESS".length();
        byte[] recvBuf = new byte[recvLen];
        try {
            this.out.write(statusPacket.getBytes());
            this.out.flush();
            this.in.read(recvBuf);
            RemoteWebServerProxyImpl.checkMagic(recvBuf);
        }
        catch (IOException ex) {
            // empty catch block
        }
        String status = new String(recvBuf);
        if (status.endsWith("FAILURE")) {
            return -1;
        }
        return 1;
    }

    public int exit() {
        String statusPacket = "935/SHMEXT";
        int recvLen = 4 + "SUCCESS".length();
        byte[] recvBuf = new byte[recvLen];
        try {
            this.out.write(statusPacket.getBytes());
            this.out.flush();
            this.in.read(recvBuf);
            RemoteWebServerProxyImpl.checkMagic(recvBuf);
        }
        catch (IOException ex) {
            // empty catch block
        }
        String status = new String(recvBuf);
        if (status.endsWith("FAILURE")) {
            return -1;
        }
        return 1;
    }

    private void getNodeInfo() {
        String statusPacket = "935/NDINFO";
        byte[] recvBuf = new byte[125];
        boolean success = true;
        try {
            this.out.write(statusPacket.getBytes());
            this.out.flush();
            this.in.read(recvBuf);
            RemoteWebServerProxyImpl.checkMagic(recvBuf);
        }
        catch (IOException ex) {
            // empty catch block
        }
        String resp = new String(recvBuf);
        resp = resp.substring(statusPacket.length() + 6);
        StringTokenizer tokenizer = new StringTokenizer(resp.trim(), "/");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            int idx = token.indexOf(58);
            String id = token.substring(0, idx + 1);
            String value = token.substring(idx + 1);
            if (id.equals("NN:")) {
                this.info.put("NN:", value);
                continue;
            }
            if (id.equals("NP:")) {
                this.info.put("NP:", value);
                continue;
            }
            if (id.equals("PT:")) {
                this.info.put("PT:", value);
                continue;
            }
            if (id.equals("JP:")) {
                this.info.put("JP:", value);
                continue;
            }
            if (id.equals("SF:")) {
                this.info.put("SF:", value);
                continue;
            }
            if (id.equals("SC:")) {
                this.info.put("SC:", value);
                int svr_num = Integer.parseInt(value);
                this.svrinfo_existed = new boolean[svr_num];
                this.svr_info = new Hashtable[svr_num];
                for (int i = 0; i < svr_num; ++i) {
                    this.svrinfo_existed[i] = false;
                    this.svr_info[i] = new Hashtable();
                }
                continue;
            }
            if (id.equals("HC:")) {
                this.info.put("HC:", value);
                continue;
            }
            success = false;
            break;
        }
        this.info_existed = success;
    }

    private void getServerInfo(int svr_num) {
        int count = 0;
        String svrnum_str = String.valueOf(svr_num);
        StringBuffer packetBuf = new StringBuffer("935/");
        packetBuf.append("SVINFO");
        packetBuf.append(RemoteWebServerProxyImpl.getLenField(svrnum_str.length()));
        packetBuf.append(svrnum_str);
        String statusPacket = packetBuf.toString();
        byte[] recvBuf = new byte[125];
        boolean success = true;
        try {
            this.out.write(statusPacket.getBytes());
            this.out.flush();
            this.in.read(recvBuf);
            RemoteWebServerProxyImpl.checkMagic(recvBuf);
        }
        catch (IOException ex) {
            // empty catch block
        }
        String resp = new String(recvBuf);
        resp = resp.substring(16);
        StringTokenizer tokenizer = new StringTokenizer(resp.trim(), "/");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (count == 0) {
                if (svr_num == Integer.parseInt(token)) {
                    ++count;
                    continue;
                }
                success = false;
                break;
            }
            int idx = token.indexOf(58);
            String id = token.substring(0, idx + 1);
            String value = token.substring(idx + 1);
            if (id.equals("SV:")) {
                this.svr_info[svr_num].put("SV:", value);
                continue;
            }
            if (id.equals("SI:")) {
                this.svr_info[svr_num].put("SI:", value);
                continue;
            }
            if (id.equals("EI:")) {
                this.svr_info[svr_num].put("EI:", value);
                continue;
            }
            if (id.equals("MX:")) {
                this.svr_info[svr_num].put("MX:", value);
                continue;
            }
            if (id.equals("MN:")) {
                this.svr_info[svr_num].put("MN:", value);
                continue;
            }
            success = false;
            break;
        }
        this.svrinfo_existed[svr_num] = success;
    }

    public String getNodeName() {
        if (!this.info_existed) {
            this.getNodeInfo();
        }
        String nodename = (String)this.info.get("NN:");
        return nodename;
    }

    public int getNodePort() {
        String port;
        if (!this.info_existed) {
            this.getNodeInfo();
        }
        if ((port = (String)this.info.get("NP:")) == null) {
            return -1;
        }
        return Integer.parseInt(port);
    }

    public int getPort() {
        String port;
        if (!this.info_existed) {
            this.getNodeInfo();
        }
        if ((port = (String)this.info.get("PT:")) == null) {
            return -1;
        }
        return Integer.parseInt(port);
    }

    public int getJsvPort() {
        String port;
        if (!this.info_existed) {
            this.getNodeInfo();
        }
        if ((port = (String)this.info.get("JP:")) == null) {
            return -1;
        }
        return Integer.parseInt(port);
    }

    private int getSSL() {
        String val;
        if (!this.info_existed) {
            this.getNodeInfo();
        }
        if ((val = (String)this.info.get("SF:")) == null) {
            return -1;
        }
        int ret = Integer.parseInt(val);
        return ret > 0 ? 1 : -1;
    }

    public String getSSLFlag() {
        if (this.getSSL() == -1) {
            return "NOTUSED";
        }
        return "USED";
    }

    public int getNodeCount() {
        String cnt;
        if (!this.info_existed) {
            this.getNodeInfo();
        }
        if ((cnt = (String)this.info.get("SC:")) == null) {
            return -1;
        }
        return Integer.parseInt(cnt);
    }

    public int getNodeHTH() {
        String cnt;
        if (!this.info_existed) {
            this.getNodeInfo();
        }
        if ((cnt = (String)this.info.get("HC:")) == null) {
            return -1;
        }
        return Integer.parseInt(cnt);
    }

    private int getHTHStatus(int i) {
        int count = 0;
        int status = 0;
        String svrnum_str = String.valueOf(i);
        StringBuffer packetBuf = new StringBuffer("935/");
        packetBuf.append("HTHSTA");
        packetBuf.append(RemoteWebServerProxyImpl.getLenField(svrnum_str.length()));
        packetBuf.append(svrnum_str);
        String statusPacket = packetBuf.toString();
        byte[] recvBuf = new byte[125];
        try {
            this.out.write(statusPacket.getBytes());
            this.out.flush();
            this.in.read(recvBuf);
            RemoteWebServerProxyImpl.checkMagic(recvBuf);
        }
        catch (IOException ex) {
            // empty catch block
        }
        String resp = new String(recvBuf);
        resp = resp.substring(16);
        StringTokenizer tokenizer = new StringTokenizer(resp.trim(), "/");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (count == 0) {
                if (i == Integer.parseInt(token)) {
                    ++count;
                    continue;
                }
                status = -2;
                break;
            }
            status = Integer.parseInt(token.trim());
            break;
        }
        return status;
    }

    public String getHTH(int i) {
        int result = this.getHTHStatus(i);
        if (result == 0) {
            return "READY";
        }
        if (result == -1) {
            return "NOTREADY";
        }
        return "FAIL";
    }

    private String getSvrName(int i) {
        if (!this.svrinfo_existed[i]) {
            this.getServerInfo(i);
        }
        String svrname = (String)this.svr_info[i].get("SV:");
        return svrname;
    }

    public String getSvr(int i) {
        return this.getSvrName(i).trim();
    }

    public int getStartspri(int i) {
        int count = 0;
        int status = 0;
        String svrnum_str = String.valueOf(i);
        StringBuffer packetBuf = new StringBuffer("935/");
        packetBuf.append("SVSPRI");
        packetBuf.append(RemoteWebServerProxyImpl.getLenField(svrnum_str.length()));
        packetBuf.append(svrnum_str);
        String statusPacket = packetBuf.toString();
        byte[] recvBuf = new byte[125];
        try {
            this.out.write(statusPacket.getBytes());
            this.out.flush();
            this.in.read(recvBuf);
            RemoteWebServerProxyImpl.checkMagic(recvBuf);
        }
        catch (IOException ex) {
            // empty catch block
        }
        String resp = new String(recvBuf);
        resp = resp.substring(16);
        StringTokenizer tokenizer = new StringTokenizer(resp.trim(), "/");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (count == 0) {
                if (i == Integer.parseInt(token)) {
                    ++count;
                    continue;
                }
                status = -2;
                break;
            }
            status = Integer.parseInt(token.trim());
            break;
        }
        return status;
    }

    public int getStarti(int i) {
        String start;
        if (!this.svrinfo_existed[i]) {
            this.getServerInfo(i);
        }
        if ((start = (String)this.svr_info[i].get("SI:")) == null) {
            return -1;
        }
        return Integer.parseInt(start);
    }

    public int getEndi(int i) {
        String end;
        if (!this.svrinfo_existed[i]) {
            this.getServerInfo(i);
        }
        if ((end = (String)this.svr_info[i].get("EI:")) == null) {
            return -1;
        }
        return Integer.parseInt(end);
    }

    private int getStatus(int i) {
        int count = 0;
        int status = 0;
        String svrnum_str = String.valueOf(i);
        StringBuffer packetBuf = new StringBuffer("935/");
        packetBuf.append("SVSTAT");
        packetBuf.append(RemoteWebServerProxyImpl.getLenField(svrnum_str.length()));
        packetBuf.append(svrnum_str);
        String statusPacket = packetBuf.toString();
        byte[] recvBuf = new byte[125];
        try {
            this.out.write(statusPacket.getBytes());
            this.out.flush();
            this.in.read(recvBuf);
            RemoteWebServerProxyImpl.checkMagic(recvBuf);
        }
        catch (IOException ex) {
            // empty catch block
        }
        String resp = new String(recvBuf);
        resp = resp.substring(16);
        StringTokenizer tokenizer = new StringTokenizer(resp.trim(), "/");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (count == 0) {
                if (i == Integer.parseInt(token)) {
                    ++count;
                    continue;
                }
                status = -2;
                break;
            }
            status = Integer.parseInt(token.trim());
            break;
        }
        return status;
    }

    public String getSvrStatus(int i) {
        int result = this.getStatus(i);
        if (result == 0) {
            return "READY";
        }
        if (result == -1) {
            return "NOTREADY";
        }
        return "FAIL";
    }

    public int getCount(int i) {
        int count = 0;
        int status = 0;
        String svrnum_str = String.valueOf(i);
        StringBuffer packetBuf = new StringBuffer("935/");
        packetBuf.append("SVCNTN");
        packetBuf.append(RemoteWebServerProxyImpl.getLenField(svrnum_str.length()));
        packetBuf.append(svrnum_str);
        String statusPacket = packetBuf.toString();
        byte[] recvBuf = new byte[125];
        try {
            this.out.write(statusPacket.getBytes());
            this.out.flush();
            this.in.read(recvBuf);
            RemoteWebServerProxyImpl.checkMagic(recvBuf);
        }
        catch (IOException ex) {
            // empty catch block
        }
        String resp = new String(recvBuf);
        resp = resp.substring(16);
        StringTokenizer tokenizer = new StringTokenizer(resp.trim(), "/");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (count == 0) {
                if (i == Integer.parseInt(token)) {
                    ++count;
                    continue;
                }
                status = -1;
                break;
            }
            status = Integer.parseInt(token.trim());
            break;
        }
        return status;
    }

    public float getAvg(int i) {
        int count = 0;
        float status = 0.0f;
        String svrnum_str = String.valueOf(i);
        StringBuffer packetBuf = new StringBuffer("935/");
        packetBuf.append("SVAVRG");
        packetBuf.append(RemoteWebServerProxyImpl.getLenField(svrnum_str.length()));
        packetBuf.append(svrnum_str);
        String statusPacket = packetBuf.toString();
        byte[] recvBuf = new byte[125];
        try {
            this.out.write(statusPacket.getBytes());
            this.out.flush();
            this.in.read(recvBuf);
            RemoteWebServerProxyImpl.checkMagic(recvBuf);
        }
        catch (IOException ex) {
            // empty catch block
        }
        String resp = new String(recvBuf);
        resp = resp.substring(16);
        if (resp.endsWith("FAILURE")) {
            return -1.0f;
        }
        StringTokenizer tokenizer = new StringTokenizer(resp.trim(), "/");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (count == 0) {
                if (i == Integer.parseInt(token)) {
                    ++count;
                    continue;
                }
                status = 0.0f;
                break;
            }
            try {
                status = Float.parseFloat(token.trim());
                break;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return -1.0f;
            }
        }
        return status;
    }

    public int getMaxPro(int i) {
        String end;
        if (!this.svrinfo_existed[i]) {
            this.getServerInfo(i);
        }
        if ((end = (String)this.svr_info[i].get("MX:")) == null) {
            return -1;
        }
        return Integer.parseInt(end);
    }

    public int getMinPro(int i) {
        String end;
        if (!this.svrinfo_existed[i]) {
            this.getServerInfo(i);
        }
        if ((end = (String)this.svr_info[i].get("MN:")) == null) {
            return -1;
        }
        return Integer.parseInt(end);
    }
}

