/*
 * Decompiled with CFR 0.152.
 */
package jeus.webserver;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.rmi.RemoteException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import jeus.management.j2ee.statistics.CountStatisticImpl;
import jeus.management.j2ee.statistics.StatisticImpl;
import jeus.management.j2ee.statistics.TimeStatisticImpl;
import jeus.management.j2ee.webserver.RemoteWebServerInfo;
import jeus.util.VirtualDNS;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_WebtoBLight;
import jeus.webserver.NodeDescriptor;
import jeus.webserver.RemoteShmc;
import jeus.webserver.SvrDescriptor;
import jeus.webserver.SvrDescriptors;
import jeus.webserver.WTBMessage;
import jeus.webserver.WebServerProxy;

public class RemoteWebServerProxyImpl
implements WebServerProxy {
    private RemoteWebServerInfo wsengine;
    private String wsname;
    private String remoteAddr;
    private int remotePort;
    private String remoteCfgName;
    private RemoteShmc shmc;
    private NodeDescriptor nodedesc;
    private SvrDescriptors svrdescs;
    boolean flag = false;
    boolean isRunning = false;
    public TimeStatisticImpl avgTime;
    public CountStatisticImpl svrCount;
    public CountStatisticImpl execCount;
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger((String)"jeus.webserver");
    Socket socket;
    InputStream in;
    OutputStream out;

    public boolean initialize() {
        try {
            this.avgTime = new TimeStatisticImpl("AvgTime", "millisecond", "the time spent waiting for a connection to be available");
            this.svrCount = new CountStatisticImpl("SvrCount", "process", "the number of server process");
            this.execCount = new CountStatisticImpl("ExecCount", "process", "the number of server process");
            this.wsengine = (RemoteWebServerInfo)RemoteWebServerInfo.createMBean(this.wsname, RemoteWebServerProxyImpl.getJeusManagerObjectName(VirtualDNS.LOCAL_VIRTUALNAME), this);
            this.wsengine.setStatistic((StatisticImpl)this.avgTime);
            this.wsengine.setStatistic((StatisticImpl)this.svrCount);
            this.wsengine.setStatistic((StatisticImpl)this.execCount);
        }
        catch (InstanceAlreadyExistsException e) {
            if (logger.isLoggable(JeusMessage_WebtoBLight._1301_LEVEL)) {
                logger.log(JeusMessage_WebtoBLight._1301_LEVEL, JeusMessage_WebtoBLight._1301, (Throwable)e);
            }
            return false;
        }
        catch (Throwable t) {
            if (logger.isLoggable(JeusMessage_WebtoBLight._1302_LEVEL)) {
                logger.log(JeusMessage_WebtoBLight._1302_LEVEL, JeusMessage_WebtoBLight._1302, t);
            }
            return false;
        }
        return true;
    }

    public static ObjectName getJeusManagerObjectName(String nodeName) throws MalformedObjectNameException {
        String name = "JEUS:j2eeType=JeusService,jeusType=JeusManager,JMXManager=" + nodeName + "," + "name" + "=" + nodeName;
        return new ObjectName(name);
    }

    public void exit() {
        this.shmc.exit();
        this.flag = false;
    }

    public NodeDescriptor getNodeDescriptor() throws RemoteException {
        if (!this.flag) {
            this.initWebServerInfo();
        }
        return this.nodedesc;
    }

    public int getSvrCount() throws RemoteException {
        if (!this.flag) {
            this.initWebServerInfo();
        }
        return this.svrdescs.getSvrCount();
    }

    public SvrDescriptor getSvrInfo(int index) throws RemoteException {
        if (!this.flag) {
            this.initWebServerInfo();
        }
        return this.svrdescs.getSvrInfo(index);
    }

    public SvrDescriptor[] getAllSvr() throws RemoteException {
        if (!this.flag) {
            this.initWebServerInfo();
        }
        return this.svrdescs.getAllSvr();
    }

    public SvrDescriptor getSvrInfo(String svrname) throws RemoteException {
        if (!this.flag) {
            this.initWebServerInfo();
        }
        return this.svrdescs.getSvrInfo(svrname);
    }

    public boolean isRunning() throws RemoteException {
        return this.isRunning;
    }

    public static void checkMagic(byte[] recvBuf) throws IOException {
        String magic = new String(recvBuf);
        if (!magic.startsWith("935/")) {
            throw new IOException("Magic corrupted!");
        }
    }

    public static String getLenField(int value) {
        String lentmp = String.valueOf(value);
        int idx = 6 - lentmp.length() - 1;
        if (idx < 0) {
            return lentmp;
        }
        String zero_str = new String(WTBMessage.ZEROS[idx]);
        String len_str = zero_str + lentmp;
        return len_str;
    }

    public static int getDataLen(byte[] recvBuf) {
        int startidx = 10;
        String s = new String(recvBuf, startidx, 6);
        return Integer.parseInt(s);
    }

    public boolean wsRunning() throws RemoteException {
        String statusPacket = "935/SHMREG";
        int recvLen = 4 + "SUCCESS".length();
        byte[] recvBuf = new byte[recvLen];
        try {
            this.out.write(statusPacket.getBytes());
            this.out.flush();
            this.in.read(recvBuf);
            RemoteWebServerProxyImpl.checkMagic(recvBuf);
        }
        catch (IOException i) {
            throw new RemoteException(i.getMessage(), i);
        }
        String status = new String(recvBuf);
        boolean returnCode = !status.endsWith("FAILURE");
        if (returnCode) {
            statusPacket = "935/SHMEXT";
            try {
                this.out.write(statusPacket.getBytes());
                this.out.flush();
                this.in.read(recvBuf);
                RemoteWebServerProxyImpl.checkMagic(recvBuf);
            }
            catch (IOException i) {
                throw new RemoteException(i.getMessage(), i);
            }
        }
        return returnCode;
    }

    private int jniwsboot() {
        String packet = "935/WSBOOT";
        int recvLen = 4 + "SUCCESS".length();
        byte[] recvBuf = new byte[recvLen];
        try {
            if (!this.wsRunning()) {
                this.out.write(packet.getBytes());
                this.in.read(recvBuf);
                RemoteWebServerProxyImpl.checkMagic(recvBuf);
                String resp = new String(recvBuf);
                if (resp.endsWith("SUCCESS")) {
                    return 1;
                }
                return -1;
            }
            return 1;
        }
        catch (IOException ioe) {
            if (logger.isLoggable(JeusMessage_WebtoBLight._1306_LEVEL)) {
                logger.log(JeusMessage_WebtoBLight._1306_LEVEL, JeusMessage_WebtoBLight._1306, (Throwable)ioe);
            }
            return -1;
        }
    }

    private int jnidown() {
        String packet = "935/WSDOWN";
        int recvLen = 4 + "SUCCESS".length();
        byte[] recvBuf = new byte[recvLen];
        try {
            if (!this.wsRunning()) {
                return 1;
            }
            this.out.write(packet.getBytes());
            this.in.read(recvBuf);
            RemoteWebServerProxyImpl.checkMagic(recvBuf);
            String resp = new String(recvBuf);
            resp = resp.trim();
            if (resp.endsWith("SUCCESS")) {
                return 1;
            }
            return -1;
        }
        catch (IOException ioe) {
            if (logger.isLoggable(JeusMessage_WebtoBLight._1307_LEVEL)) {
                logger.log(JeusMessage_WebtoBLight._1307_LEVEL, JeusMessage_WebtoBLight._1307, (Throwable)ioe);
            }
            return -1;
        }
    }

    private int jnisvrboot(String svrname) {
        StringBuffer strBuffer = new StringBuffer("935/");
        strBuffer.append("SVBOOT");
        int recvLen = 4 + "SUCCESS".length();
        int nameLen = svrname.length();
        byte[] recvBuf = new byte[recvLen];
        try {
            if (this.wsRunning()) {
                strBuffer.append(RemoteWebServerProxyImpl.getLenField(nameLen));
                strBuffer.append(svrname);
                this.out.write(strBuffer.toString().getBytes());
                this.in.read(recvBuf);
                RemoteWebServerProxyImpl.checkMagic(recvBuf);
                String resp = new String(recvBuf);
                if (resp.endsWith("SUCCESS")) {
                    return 1;
                }
                return -1;
            }
            return -1;
        }
        catch (IOException ioe) {
            if (logger.isLoggable(JeusMessage_WebtoBLight._1308_LEVEL)) {
                logger.log(JeusMessage_WebtoBLight._1308_LEVEL, JeusMessage_WebtoBLight._1308, (Throwable)ioe);
            }
            return -1;
        }
    }

    private int jnisvrdown(String svrname) {
        StringBuffer strBuffer = new StringBuffer("935/");
        strBuffer.append("SVDOWN");
        int recvLen = 4 + "SUCCESS".length();
        int nameLen = svrname.length();
        byte[] recvBuf = new byte[recvLen];
        try {
            if (this.wsRunning()) {
                strBuffer.append(RemoteWebServerProxyImpl.getLenField(nameLen));
                strBuffer.append(svrname);
                this.out.write(strBuffer.toString().getBytes());
                this.in.read(recvBuf);
                RemoteWebServerProxyImpl.checkMagic(recvBuf);
                String resp = new String(recvBuf);
                resp = resp.trim();
                if (resp.endsWith("SUCCESS")) {
                    return 1;
                }
                return -1;
            }
            return -1;
        }
        catch (IOException ioe) {
            if (logger.isLoggable(JeusMessage_WebtoBLight._1308_LEVEL)) {
                logger.log(JeusMessage_WebtoBLight._1308_LEVEL, JeusMessage_WebtoBLight._1308, (Throwable)ioe);
            }
            return -1;
        }
    }

    public int wsboot() throws RemoteException {
        int result = this.jniwsboot();
        this.isRunning = result > 0;
        this.shmc = new RemoteShmc(this.socket);
        result = this.shmc.register();
        if (result >= 0) {
            this.nodedesc = new NodeDescriptor();
            this.nodedesc.setNodeName(this.shmc.getNodeName());
            this.nodedesc.setNodePort(this.shmc.getNodePort());
            this.nodedesc.setPort(this.shmc.getPort());
            this.nodedesc.setJsvPort(this.shmc.getJsvPort());
            this.nodedesc.setSslFlag(this.shmc.getSSLFlag());
            this.nodedesc.setSvrCount(this.shmc.getNodeCount());
            this.nodedesc.setHthCount(this.shmc.getNodeHTH());
            this.svrdescs = new SvrDescriptors(this.shmc);
            this.svrdescs.initialize();
            this.flag = true;
            this.shmc.exit();
        }
        return result > 0 ? 1 : -1;
    }

    private void initWebServerInfo() {
        this.shmc = new RemoteShmc(this.socket);
        int result = this.shmc.register();
        if (result >= 0) {
            this.nodedesc = new NodeDescriptor();
            this.nodedesc.setNodeName(this.shmc.getNodeName());
            this.nodedesc.setNodePort(this.shmc.getNodePort());
            this.nodedesc.setPort(this.shmc.getPort());
            this.nodedesc.setJsvPort(this.shmc.getJsvPort());
            this.nodedesc.setSslFlag(this.shmc.getSSLFlag());
            this.nodedesc.setSvrCount(this.shmc.getNodeCount());
            this.nodedesc.setHthCount(this.shmc.getNodeHTH());
            this.svrdescs = new SvrDescriptors(this.shmc);
            this.svrdescs.initialize();
            this.flag = true;
            this.shmc.exit();
        }
    }

    public int wsdown() throws RemoteException {
        int result = this.jnidown();
        this.isRunning = result <= 0;
        int MaxIter = 2;
        int time = 0;
        while (++time < MaxIter && this.isRunning) {
            result = this.jnidown();
            if (result > 0) {
                this.isRunning = false;
                break;
            }
            this.isRunning = true;
        }
        return result < 0 ? -1 : 0;
    }

    public int svrboot(String svrname) throws RemoteException {
        return this.jnisvrboot(svrname);
    }

    public int svrdown(String svrname) throws RemoteException {
        return this.jnisvrdown(svrname);
    }

    public byte[] readConfig() {
        StringBuffer packet = new StringBuffer("935/");
        int datalen = this.remoteCfgName.length();
        byte[] recvBuf = new byte[16];
        byte[] read_buf = new byte[255];
        int total_count = 0;
        int count = 0;
        packet.append("GETCFG");
        packet.append(RemoteWebServerProxyImpl.getLenField(datalen));
        packet.append(this.remoteCfgName);
        try {
            this.out.write(packet.toString().getBytes());
            count = this.in.read(recvBuf);
            String resp = new String(recvBuf);
            resp = resp.trim();
            if (count <= 0) {
                throw new IOException("Cannot read response");
            }
            RemoteWebServerProxyImpl.checkMagic(recvBuf);
            if (resp.endsWith("FAILURE")) {
                return null;
            }
            total_count = RemoteWebServerProxyImpl.getDataLen(recvBuf);
            byte[] real_buf = new byte[total_count];
            int read_count = 0;
            for (count = 0; count < total_count; count += read_count) {
                read_count = this.in.read(read_buf);
                System.arraycopy(read_buf, 0, real_buf, count, read_count);
            }
            if (count == total_count) {
                return real_buf;
            }
            throw new IOException("Cannot read data");
        }
        catch (IOException ioe) {
            if (logger.isLoggable(JeusMessage_WebtoBLight._1309_LEVEL)) {
                logger.log(JeusMessage_WebtoBLight._1309_LEVEL, JeusMessage_WebtoBLight._1309, (Object)this.remoteCfgName, (Throwable)ioe);
            }
            return null;
        }
    }

    public void save_config(byte[] configStream) {
        block6: {
            StringBuffer packet = new StringBuffer("935/");
            StringBuffer next_packet = new StringBuffer("935/");
            int datalen = this.remoteCfgName.length();
            int recvLen = 4 + "SUCCESS".length();
            byte[] recvBuf = new byte[recvLen];
            packet.append("SAVCFG");
            packet.append(RemoteWebServerProxyImpl.getLenField(datalen));
            packet.append(this.remoteCfgName);
            try {
                this.out.write(packet.toString().getBytes());
                this.in.read(recvBuf);
                RemoteWebServerProxyImpl.checkMagic(recvBuf);
                String resp = new String(recvBuf);
                resp = resp.trim();
                if (resp.endsWith("SUCCESS")) {
                    next_packet.append("CFGDAT");
                    next_packet.append(RemoteWebServerProxyImpl.getLenField(configStream.length));
                    this.out.write(next_packet.toString().getBytes());
                    this.out.write(configStream);
                    this.in.read(recvBuf);
                    RemoteWebServerProxyImpl.checkMagic(recvBuf);
                    resp = new String(recvBuf);
                    if (resp.endsWith("SUCCESS")) {
                        logger.log(JeusMessage_WebtoBLight._1312_LEVEL, JeusMessage_WebtoBLight._1312, (Object)this.remoteCfgName);
                    } else {
                        logger.log(JeusMessage_WebtoBLight._1313_LEVEL, JeusMessage_WebtoBLight._1313, (Object)this.remoteCfgName);
                    }
                } else {
                    logger.log(JeusMessage_WebtoBLight._1313_LEVEL, JeusMessage_WebtoBLight._1313, (Object)this.remoteCfgName);
                }
            }
            catch (IOException ioe) {
                if (!logger.isLoggable(JeusMessage_WebtoBLight._1310_LEVEL)) break block6;
                logger.log(JeusMessage_WebtoBLight._1310_LEVEL, JeusMessage_WebtoBLight._1310, (Object)this.remoteCfgName, (Throwable)ioe);
            }
        }
    }

    public int compile_config() {
        int status;
        block4: {
            StringBuffer packet = new StringBuffer("935/");
            int datalen = this.remoteCfgName.length();
            int recvLen = 4 + "SUCCESS".length();
            byte[] recvBuf = new byte[recvLen];
            status = -1;
            packet.append("CFCOMP");
            packet.append(RemoteWebServerProxyImpl.getLenField(datalen));
            packet.append(this.remoteCfgName);
            try {
                this.out.write(packet.toString().getBytes());
                this.in.read(recvBuf);
                RemoteWebServerProxyImpl.checkMagic(recvBuf);
                String resp = new String(recvBuf);
                resp = resp.trim();
                if (resp.endsWith("SUCCESS")) {
                    logger.log(JeusMessage_WebtoBLight._1314_LEVEL, JeusMessage_WebtoBLight._1314, (Object)this.remoteCfgName);
                    status = 1;
                } else {
                    logger.log(JeusMessage_WebtoBLight._1315_LEVEL, JeusMessage_WebtoBLight._1315, (Object)this.remoteCfgName);
                    status = -1;
                }
            }
            catch (IOException ioe) {
                if (!logger.isLoggable(JeusMessage_WebtoBLight._1311_LEVEL)) break block4;
                logger.log(JeusMessage_WebtoBLight._1311_LEVEL, JeusMessage_WebtoBLight._1311, (Object)this.remoteCfgName, (Throwable)ioe);
            }
        }
        return status;
    }
}

