/*
 * Decompiled with CFR 0.152.
 */
package jeus.webserver;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import jeus.webserver.Shmc;
import jeus.webserver.SvrDescriptor;
import jeus.webserver.SvrNameNotFoundException;

public class SvrDescriptors
implements Serializable {
    private Vector container;
    private Shmc shmc;
    private int svrcount;

    public SvrDescriptors(Shmc shmc) {
        this.shmc = shmc;
    }

    public void initialize() {
        this.container = new Vector();
        this.svrcount = this.shmc.getNodeCount();
        int hth = this.shmc.getNodeHTH();
        for (int i = 0; i < hth; ++i) {
            if (this.shmc.getHTH(i).equals("NOTREADY")) continue;
            for (int j = 0; j < this.svrcount; ++j) {
                String sname = this.shmc.getSvr(j);
                int starti = this.shmc.getStarti(j);
                int endi = this.shmc.getEndi(j);
                int startspri = this.shmc.getStartspri(i);
                int l = startspri + starti;
                int count = this.shmc.getCount(l);
                float avg = count > 0 ? this.shmc.getAvg(l) : 0.0f;
                SvrDescriptor svrdesc = new SvrDescriptor();
                svrdesc.setSvrName(sname);
                svrdesc.setStatus(this.shmc.getSvrStatus(l));
                svrdesc.setMinProc(this.shmc.getMinPro(j));
                svrdesc.setMaxProc(this.shmc.getMaxPro(j));
                svrdesc.setCount(count);
                svrdesc.setAvg(avg);
                svrdesc.setPosition(l);
                this.container.add(svrdesc);
            }
        }
    }

    public int getSvrCount() {
        return this.svrcount;
    }

    public SvrDescriptor getSvrInfo(int index) {
        SvrDescriptor svr = (SvrDescriptor)this.container.get(index);
        return this.update(svr);
    }

    public SvrDescriptor[] getAllSvr() {
        SvrDescriptor[] svrdescp = new SvrDescriptor[this.svrcount];
        for (int i = 0; i < this.svrcount; ++i) {
            svrdescp[i] = this.getSvrInfo(i);
        }
        return svrdescp;
    }

    public SvrDescriptor getSvrInfo(String svrname) throws SvrNameNotFoundException {
        Enumeration e = this.container.elements();
        while (e.hasMoreElements()) {
            SvrDescriptor svr = (SvrDescriptor)e.nextElement();
            String name = svr.getSvrName();
            if (!name.equals(svrname)) continue;
            return this.update(svr);
        }
        throw new SvrNameNotFoundException(svrname);
    }

    private SvrDescriptor update(SvrDescriptor svr) {
        float avg;
        int count;
        int pos = svr.getPosition();
        int result = this.shmc.register();
        String status = result > 0 ? this.shmc.getSvrStatus(pos) : "NOTREADY";
        if (!status.equals("NOTREADY")) {
            count = this.shmc.getCount(pos);
            avg = count > 0 ? this.shmc.getAvg(pos) : 0.0f;
        } else {
            count = 0;
            avg = 0.0f;
        }
        if (result > 0) {
            this.shmc.exit();
        }
        svr.setStatus(status);
        svr.setCount(count);
        svr.setAvg(avg);
        return svr;
    }
}

