/*
 * Decompiled with CFR 0.152.
 */
package jeus.xml.binding.appclientHelper;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import jeus.webservices.api.EWSProvider;
import jeus.xml.binding.appclientHelper.EnvEntry;
import jeus.xml.binding.j2ee.ApplicationClientType;
import jeus.xml.binding.j2ee.EnvEntryType;
import jeus.xml.binding.jeusDD.ClientModuleInfoType;
import jeus.xml.binding.jeusDD.EnvType;
import jeus.xml.binding.jeusDD.JeusClientDdType;
import jeus.xml.binding.jeusDD.JeusWebservicesClientDdType;
import jeus.xml.binding.jeusDD.JndiRefType;
import jeus.xml.binding.jeusDD.SchedulerType;
import jeus.xml.binding.jeusDD.SecurityInfoType;
import jeus.xml.binding.jeusDD.SystemLoggingType;

public class AppClientPair {
    private ApplicationClientType stdDD;
    private JeusClientDdType extDD;
    private JeusWebservicesClientDdType extWebservicesClientDD;
    private List serviceRefPairs;

    public AppClientPair(ApplicationClientType std, JeusClientDdType ext) {
        this.stdDD = std;
        this.extDD = ext;
    }

    public SystemLoggingType getSystemLog() {
        return this.extDD.getSystemLogging();
    }

    public ClientModuleInfoType getModuleInfo() {
        return this.extDD.getModuleInfo();
    }

    public String getModuleInfoModuleName() {
        ClientModuleInfoType mi = this.getModuleInfo();
        if (mi == null) {
            return null;
        }
        return mi.getModuleName();
    }

    public String getModuleInfoAppMainClass() {
        ClientModuleInfoType mi = this.getModuleInfo();
        if (mi == null) {
            return null;
        }
        return mi.getAppMainClass();
    }

    public String[] getMoudleInfoAppArgument() {
        ClientModuleInfoType mi = this.getModuleInfo();
        if (mi == null) {
            return new String[0];
        }
        String argStr = this.extDD.getModuleInfo().getAppArgument();
        if (argStr == null) {
            return new String[0];
        }
        StringTokenizer tokens = new StringTokenizer(argStr, " ");
        ArrayList<String> argList = new ArrayList<String>();
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            argList.add(token);
        }
        String[] argArr = new String[argList.size()];
        argList.toArray(argArr);
        return argArr;
    }

    public SecurityInfoType getSecurityInfo() {
        return this.extDD.getSecurityInfo();
    }

    public String getSecurityInfoUser() {
        SecurityInfoType si = this.getSecurityInfo();
        if (si == null) {
            return null;
        }
        return si.getUser();
    }

    public String getSecurityInfoPasswd() {
        SecurityInfoType si = this.getSecurityInfo();
        if (si == null) {
            return null;
        }
        return si.getPasswd();
    }

    public boolean isScheduler() {
        return this.extDD.getScheduler() != null;
    }

    public List getEnv() {
        int i;
        ArrayList<EnvEntry> envList = new ArrayList<EnvEntry>();
        if (this.stdDD != null) {
            List stdEnvs = this.stdDD.getEnvEntry();
            for (i = 0; i < stdEnvs.size(); ++i) {
                EnvEntryType envEntryType = (EnvEntryType)stdEnvs.get(i);
                String entryName = envEntryType.getEnvEntryName().getValue();
                String entryType = envEntryType.getEnvEntryType().getValue();
                String entryValue = envEntryType.getEnvEntryValue().getValue().trim();
                envList.add(new EnvEntry(entryName, entryType, entryValue));
            }
        }
        List extEnvs = this.extDD.getEnv();
        for (i = 0; i < extEnvs.size(); ++i) {
            EnvType envType = (EnvType)extEnvs.get(i);
            envList.add(new EnvEntry(envType.getName(), envType.getType(), envType.getValue()));
        }
        return envList;
    }

    public JndiRefType getEjbRef() {
        return this.extDD.getEjbRef();
    }

    public JndiRefType getResRef() {
        return this.extDD.getResRef();
    }

    public JndiRefType getResEnvRef() {
        return this.extDD.getResEnvRef();
    }

    public void setJeusWebservicesClientDD(JeusWebservicesClientDdType wsClientDD) {
        this.extWebservicesClientDD = wsClientDD;
        EWSProvider provider = EWSProvider.getProvider();
        if (provider != null) {
            this.serviceRefPairs = provider.makePairList(this.stdDD, this.extWebservicesClientDD);
        }
    }

    public List getServiceRefPairs() {
        return this.serviceRefPairs;
    }

    public String getSecurityProviderNodeName() {
        return this.extDD.getSecurityInfo().getProviderNodeName();
    }

    public SchedulerType getSchedulerType() {
        return this.extDD.getScheduler();
    }

    public JeusWebservicesClientDdType getExtWebservicesClientDD() {
        return this.extWebservicesClientDD;
    }
}

