/*
 * Decompiled with CFR 0.152.
 */
package jeus.xml.binding.connectorHelper;

import java.util.HashMap;
import java.util.List;
import javax.xml.bind.JAXBException;
import jeus.xml.binding.ObjectFactoryHelper;
import jeus.xml.binding.j2ee.AuthenticationMechanismType;
import jeus.xml.binding.j2ee.ConnectionDefinitionType;
import jeus.xml.binding.jeusDD.ConnectionPoolType;
import jeus.xml.binding.jeusDD.DisposableConnectionType;
import jeus.xml.binding.jeusDD.LogFileType;
import jeus.xml.binding.jeusDD.ObjectFactory;
import jeus.xml.binding.jeusDD.PoolManagementType;
import jeus.xml.binding.jeusDD.TransactionSupportType;
import jeus.xml.binding.jeusDD.WaitConnectionType;

public class ConnectionDefinitionsDescriptor {
    private ConnectionDefinitionType connectionDefinition;
    private ConnectionPoolType outboundType;
    private PoolManagementType poolType;
    private String txSupport;
    private boolean reauthenticate;
    private List mechanisms;
    private DisposableConnectionType disposableType;
    private WaitConnectionType waitType;

    public ConnectionDefinitionsDescriptor(ConnectionDefinitionType connectionDefinition, ConnectionPoolType poolDesc, String txSupport, boolean reauthenticate, List mechanisms) throws JAXBException {
        ObjectFactory objectFactory;
        this.connectionDefinition = connectionDefinition;
        this.outboundType = poolDesc;
        this.txSupport = txSupport;
        this.reauthenticate = reauthenticate;
        this.mechanisms = mechanisms;
        TransactionSupportType transactionSupport = poolDesc.getTransactionSupport();
        if (transactionSupport != null) {
            this.txSupport = transactionSupport.value();
        }
        this.poolType = poolDesc.getPoolManagement();
        if (this.poolType == null) {
            objectFactory = ObjectFactoryHelper.getJeusDDObjectFactory();
            this.poolType = objectFactory.createPoolManagementType();
            this.poolType.fillDefault();
        }
        this.disposableType = this.poolType.getDisposableConnection();
        if (this.disposableType == null) {
            objectFactory = ObjectFactoryHelper.getJeusDDObjectFactory();
            this.disposableType = objectFactory.createDisposableConnectionType();
            this.disposableType.fillDefault();
        }
        this.waitType = this.poolType.getWaitConnection();
        if (this.waitType == null) {
            objectFactory = ObjectFactoryHelper.getJeusDDObjectFactory();
            this.waitType = objectFactory.createWaitConnectionType();
            this.waitType.fillDefault();
        }
        if (poolDesc.isSetTransactionSupport()) {
            this.txSupport = poolDesc.getTransactionSupport().value();
        }
    }

    public String getExportName() {
        return this.outboundType.getExportName();
    }

    public List getProperties() {
        return this.outboundType.getProperty();
    }

    public String getUserName() {
        return this.outboundType.getUser();
    }

    public String getPassword() {
        return this.outboundType.getPassword();
    }

    public String getConnectionIntClassName() {
        return this.connectionDefinition.getConnectionInterface().getValue();
    }

    public String getConnectionImpClassName() {
        return this.connectionDefinition.getConnectionImplClass().getValue();
    }

    public String getManagedconnectionfactoryClass() {
        return this.connectionDefinition.getManagedconnectionfactoryClass().getValue();
    }

    public int getMin() {
        return this.poolType.getMin();
    }

    public int getMax() {
        return this.poolType.getMax();
    }

    public long getResizingPeriod() {
        return this.poolType.getPooledTimeout();
    }

    public boolean getWaiting() {
        return this.waitType.isWaitConnection();
    }

    public long getWaitingTime() {
        return this.waitType.getWaitTimeout();
    }

    public int getWaitTrial() {
        return this.waitType.getMaxWaitTrial();
    }

    public int getMaxWaiterCount() {
        return this.waitType.getMaxWaiterCount();
    }

    public boolean isAllowDisposableConnection() {
        return this.disposableType.isAllowDisposableConnection();
    }

    public int getMaxDisposableCount() {
        return this.disposableType.getMaxDisposableCount();
    }

    public boolean getUseWrapper() {
        return this.outboundType.isUseWrapper();
    }

    public boolean getSkipMatching() {
        return this.outboundType.isSkipConnectionMatching();
    }

    public long getDissociationTimeout() {
        return this.outboundType.getDissociationTimeout();
    }

    public long getInvalidationTimeout() {
        return this.outboundType.getInvalidationTimeout();
    }

    public long getValidationTimeout() {
        return this.outboundType.getValidationTimeout();
    }

    public int getTransactionSupport() {
        if (this.txSupport.equals("NoTransaction")) {
            return 0;
        }
        if (this.txSupport.equals("LocalTransaction")) {
            return 1;
        }
        if (this.txSupport.equals("XATransaction")) {
            return 2;
        }
        return 3;
    }

    public boolean isReauthenticationSupport() {
        return this.reauthenticate;
    }

    public List getJarProperties() {
        return this.connectionDefinition.getConfigProperty();
    }

    public HashMap getAuthenticationInfo() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < this.mechanisms.size(); ++i) {
            AuthenticationMechanismType authenticationMechanismType = (AuthenticationMechanismType)this.mechanisms.get(i);
            map.put(authenticationMechanismType.getAuthenticationMechanismType().getValue(), authenticationMechanismType.getCredentialInterface().getValue());
        }
        return map;
    }

    public LogFileType getLogFile() {
        return this.outboundType.getLogFile();
    }

    public String getLoggerFileName() {
        if (this.outboundType.getLogFile() != null) {
            return this.outboundType.getLogFile().getFileName();
        }
        return null;
    }

    public int getLoggerFileValidDay() {
        return this.outboundType.getLogFile().getValidDay();
    }

    public int getBufferSize() {
        return this.outboundType.getLogFile().getBufferSize();
    }
}

