/*
 * Decompiled with CFR 0.152.
 */
package jeus.xml.binding.connectorHelper;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.JAXBException;
import jeus.deploy.archivist.AbstractArchive;
import jeus.deploy.archivist.FileArchive;
import jeus.deploy.io.ConnectorDeploymentDescriptorFile;
import jeus.deploy.io.runtime.ConnectorRuntimeDDFile;
import jeus.xml.binding.ObjectFactoryHelper;
import jeus.xml.binding.connectorHelper.ConnectionDefinitionsDescriptor;
import jeus.xml.binding.connectorHelper.WorkerPoolDescriptor;
import jeus.xml.binding.j2ee.ConnectionDefinitionType;
import jeus.xml.binding.j2ee.ConnectorType;
import jeus.xml.binding.j2ee.FullyQualifiedClassType;
import jeus.xml.binding.j2ee.OutboundResourceadapterType;
import jeus.xml.binding.j2ee.ResourceadapterType;
import jeus.xml.binding.jeusDD.ConnectionPoolType;
import jeus.xml.binding.jeusDD.JeusConnectorDdType;
import jeus.xml.binding.jeusDD.ObjectFactory;
import jeus.xml.binding.jeusDD.WorkerPoolType;

public class ConnectorPair {
    private String moduleName;
    private ResourceadapterType ra;
    private WorkerPoolDescriptor wmDesc;
    private Hashtable conDefs;

    public ConnectorPair(String moduleName, ConnectorType rarJar, JeusConnectorDdType rarDD, boolean generated) throws JAXBException {
        block6: {
            this.ra = rarJar.getResourceadapter();
            this.moduleName = moduleName;
            OutboundResourceadapterType outboundResourceAdapter = this.ra.getOutboundResourceadapter();
            if (rarDD.isUseWorkmanager().booleanValue()) {
                WorkerPoolType workerPool = rarDD.getWorkerPool();
                this.wmDesc = new WorkerPoolDescriptor(workerPool);
            }
            this.conDefs = new Hashtable();
            if (outboundResourceAdapter == null) break block6;
            String txSupport = outboundResourceAdapter.getTransactionSupport().getValue();
            boolean reauthenticate = outboundResourceAdapter.getReauthenticationSupport().isValue();
            List mechanisms = outboundResourceAdapter.getAuthenticationMechanism();
            List connectionDefinitions = outboundResourceAdapter.getConnectionDefinition();
            int len = connectionDefinitions.size();
            if (generated) {
                ObjectFactory objectFactory = ObjectFactoryHelper.getJeusDDObjectFactory();
                for (int i = 0; i < len; ++i) {
                    ConnectionPoolType out = objectFactory.createConnectionPoolType();
                    out.setExportName(moduleName + (i == 0 ? "" : String.valueOf(i)));
                    out.setDissociationTimeout(Long.valueOf(out.getDefaultDissociationTimeout()));
                    out.setInvalidationTimeout(Long.valueOf(out.getDefaultInvalidationTimeout()));
                    out.setSkipConnectionMatching(Boolean.valueOf(out.getDefaultSkipConnectionMatching()));
                    out.setUseWrapper(Boolean.valueOf(out.getDefaultUseWrapper()));
                    out.setValidationTimeout(Long.valueOf(out.getDefaultValidationTimeout()));
                    this.addConnectionDef((ConnectionDefinitionType)connectionDefinitions.get(i), out, txSupport, reauthenticate, mechanisms);
                }
            } else {
                List outBounds = rarDD.getConnectionPool();
                if (len != outBounds.size()) {
                    throw new JAXBException("Number of connection definitions[" + len + "] and number of connection pool definitions[" + outBounds.size() + "] do not match");
                }
                for (int i = 0; i < len; ++i) {
                    this.addConnectionDef((ConnectionDefinitionType)connectionDefinitions.get(i), (ConnectionPoolType)outBounds.get(i), txSupport, reauthenticate, mechanisms);
                }
            }
        }
    }

    public void addConnectionDef(ConnectionDefinitionType conDefType, ConnectionPoolType outboundType, String txSupport, boolean reauthenticate, List mechanisms) throws JAXBException {
        ConnectionDefinitionsDescriptor conDef = new ConnectionDefinitionsDescriptor(conDefType, outboundType, txSupport, reauthenticate, mechanisms);
        this.conDefs.put(conDef.getExportName(), conDef);
    }

    public Iterator getAllOutbounds() {
        return this.conDefs.values().iterator();
    }

    public WorkerPoolDescriptor getWorkManagerDesc() {
        return this.wmDesc;
    }

    public String getResourceAdapterClass() {
        FullyQualifiedClassType field = this.ra.getResourceadapterClass();
        if (field != null) {
            return field.getValue();
        }
        return null;
    }

    public List getResourceAdapterProperty() {
        return this.ra.getConfigProperty();
    }

    public List getMessageListenerDescriptor() {
        return this.ra.getInboundResourceadapter().getMessageadapter().getMessagelistener();
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public static ConnectorPair getDescriptor(FileArchive archive, String loaderModuleName) throws IOException, JAXBException {
        JeusConnectorDdType rarDD;
        ConnectorDeploymentDescriptorFile jcaFile = new ConnectorDeploymentDescriptorFile();
        ConnectorType rarJar = (ConnectorType)jcaFile.getDeploymentDescriptor((AbstractArchive)archive);
        boolean generated = false;
        ConnectorRuntimeDDFile jcaDDFile = new ConnectorRuntimeDDFile();
        try {
            rarDD = (JeusConnectorDdType)jcaDDFile.getDeploymentDescriptor((AbstractArchive)archive);
        }
        catch (IOException ioe) {
            ObjectFactory objectFactory = ObjectFactoryHelper.getJeusDDObjectFactory();
            rarDD = objectFactory.createJeusConnectorDdType();
            rarDD.setModuleName(loaderModuleName);
            rarDD.setUseWorkmanager(Boolean.valueOf(rarDD.getDefaultUseWorkmanager()));
            generated = true;
        }
        return new ConnectorPair(rarDD.getModuleName(), rarJar, rarDD, generated);
    }

    public List getJavaSecurityPermission() {
        return this.ra.getSecurityPermission();
    }
}

