/*
 * Decompiled with CFR 0.152.
 */
package jeus.xml.binding.ejbHelper;

import java.util.List;
import jeus.util.StringUtil;
import jeus.xml.binding.ejbHelper.BeanPair;
import jeus.xml.binding.ejbHelper.ModulePair;
import jeus.xml.binding.j2ee.EntityBeanType;
import jeus.xml.binding.j2ee.HomeType;
import jeus.xml.binding.j2ee.LocalHomeType;
import jeus.xml.binding.j2ee.LocalType;
import jeus.xml.binding.j2ee.RemoteType;
import jeus.xml.binding.jeusDD.JeusBeanType;
import jeus.xml.binding.jeusDD.PersistenceOptimizeType;

public abstract class EntityBeanPair
extends BeanPair {
    private PersistenceOptimizeType persistenceOptimizeType;

    public EntityBeanPair(String ejbName, EntityBeanType entityBean, JeusBeanType jeusBean, ModulePair modulePair) {
        super(modulePair, jeusBean);
        LocalType localType;
        RemoteType remoteType;
        LocalHomeType localHomeType;
        this.ejbName = ejbName;
        this.jarBean = entityBean;
        HomeType homeType = entityBean.getHome();
        if (homeType != null) {
            this.home = homeType.getValue();
        }
        if ((localHomeType = entityBean.getLocalHome()) != null) {
            this.localHome = localHomeType.getValue();
        }
        if ((remoteType = entityBean.getRemote()) != null) {
            this.remote = remoteType.getValue();
        }
        if ((localType = entityBean.getLocal()) != null) {
            this.local = localType.getValue();
        }
        this.ejbClassName = entityBean.getEjbClass().getValue();
        this.persistenceOptimizeType = jeusBean.getPersistenceOptimize();
    }

    public boolean isEntityBean() {
        return true;
    }

    public int getEngineType() {
        String engineType = this.persistenceOptimizeType.getEngineType().value();
        if (engineType.equals("EXCLUSIVE_ACCESS")) {
            return 1;
        }
        if (engineType.equals("SINGLE_OBJECT")) {
            return 2;
        }
        return 3;
    }

    public String getPkeyClassName() {
        return this.jarBean.getPrimKeyClass().getValue();
    }

    public List getNMMethods() {
        return this.persistenceOptimizeType.getNonModifyingMethod();
    }

    public List getRoleLinkList() {
        return this.jarBean.getSecurityRoleRef();
    }

    public List getEnvs() {
        return this.jarBean.getEnvEntry();
    }

    public List getEJBRefs() {
        return this.jarBean.getEjbRef();
    }

    public List getEJBLocalRefs() {
        return this.jarBean.getEjbLocalRef();
    }

    public List getResourceRefs() {
        return this.jarBean.getResourceRef();
    }

    public List getResourceEnvRefs() {
        return this.jarBean.getResourceEnvRef();
    }

    public boolean isReentrant() {
        return this.jarBean.getReentrant().isValue();
    }

    public boolean getDelayUpdateUntilTx() {
        return this.persistenceOptimizeType.isUpdateDelayTillTx();
    }

    public int getEntityCacheSize() {
        return this.persistenceOptimizeType.getEntityCacheSize();
    }

    public List getMessageDestinationRefs() {
        return this.jarBean.getMessageDestinationRef();
    }

    public List getServiceRefs() {
        return this.jarBean.getServiceRef();
    }

    public String toConfigString() {
        StringBuffer configStringBuffer = new StringBuffer(super.toConfigString());
        configStringBuffer.append("IsReentrant : ").append(this.isReentrant()).append(StringUtil.lineSeparator);
        configStringBuffer.append("EngineType : ").append(this.getEngineType()).append(StringUtil.lineSeparator);
        configStringBuffer.append("ContainerManagedTransaction : true").append(StringUtil.lineSeparator);
        configStringBuffer.append("CacheSize : ").append(this.getEntityCacheSize()).append(StringUtil.lineSeparator);
        return configStringBuffer.toString();
    }

    public boolean getDefaultIncludeUpdate() {
        return this.persistenceOptimizeType.isIncludeUpdate();
    }

    public Object getEjbJarType() {
        return this.jarBean;
    }
}

