/*
 * Decompiled with CFR 0.152.
 */
package jeus.xml.util;

import java.io.ObjectInputStream;
import java.net.URL;
import java.util.HashMap;
import jeus.xml.util.ElementOrderTable;
import jeus.xml.util.ILocation;
import org.w3c.dom.Document;

public class ElementOrderTableSource {
    private static final String DEFAULT_EXTENSION = ".xso";
    private ILocation baseLocation;
    private String extension = ".xso";
    private HashMap cache = new HashMap();

    public ElementOrderTableSource(ILocation baseLocation) {
        this.baseLocation = baseLocation;
    }

    public ElementOrderTableSource(ILocation baseLocation, String extension) {
        this.baseLocation = baseLocation;
        this.extension = extension;
    }

    public ElementOrderTable getElementOrderTable(Document doc) {
        return this.getElementOrderTable(doc.getDocumentElement().getLocalName(), doc.getDocumentElement().getNamespaceURI());
    }

    public ElementOrderTable getElementOrderTable(String rootname, String namespace) {
        if (namespace == null) {
            throw new RuntimeException("XML Document must have namespace for root element '" + rootname + "'.");
        }
        int hashcode = namespace.hashCode();
        String packageName = hashcode < 0 ? "N" + String.valueOf(hashcode).substring(1) : "P" + String.valueOf(hashcode);
        ILocation packageLocation = this.baseLocation.getRelativeLocation(packageName);
        ILocation resourceLocation = packageLocation.getRelativeLocation(rootname + this.extension);
        ElementOrderTable t = (ElementOrderTable)this.cache.get(packageName + "_" + rootname);
        if (t != null) {
            return t;
        }
        try {
            URL url = resourceLocation.getURL();
            ObjectInputStream input = new ObjectInputStream(url.openStream());
            t = (ElementOrderTable)input.readObject();
            input.close();
            this.cache.put(packageName + "_" + rootname, t);
            return t;
        }
        catch (Exception e) {
            URL packageURL = packageLocation.getURL();
            if (packageURL == null) {
                throw new RuntimeException("Unable to find '" + this.baseLocation.toString() + "/" + packageName + "' package for '" + namespace + "'. Check the namespace in xml document.");
            }
            URL resourceURL = resourceLocation.getURL();
            if (resourceURL == null) {
                throw new RuntimeException("Unable to find '" + packageLocation.toString() + "/" + rootname + this.extension + "' resource for root element '" + rootname + "' in '" + namespace + "' namespace. Check this namespace contains the '" + rootname + "' element or not.");
            }
            throw new RuntimeException(e);
        }
    }
}

