/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.attachment;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataSource;
import org.apache.cxf.attachment.DelegatingInputStream;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.io.CachedOutputStream;

public class AttachmentDataSource
implements DataSource {
    private final String ct;
    private CachedOutputStream cache;
    private InputStream ins;
    private DelegatingInputStream delegating;

    public AttachmentDataSource(String ctParam, InputStream inParam) throws IOException {
        this.ct = ctParam;
        this.ins = inParam;
        if (this.ins instanceof DelegatingInputStream) {
            this.delegating = (DelegatingInputStream)this.ins;
        }
    }

    public AttachmentDataSource(String ctParam, InputStream inParam, InputStream delegate) throws IOException {
        this.ct = ctParam;
        this.ins = inParam;
        if (delegate instanceof DelegatingInputStream) {
            this.delegating = (DelegatingInputStream)delegate;
        }
    }

    public boolean isCached() {
        return this.cache != null;
    }

    public void cache() throws IOException {
        if (this.cache == null) {
            this.cache = new CachedOutputStream();
            IOUtils.copy((InputStream)this.ins, (OutputStream)this.cache);
            this.cache.lockOutputStream();
            this.ins.close();
            this.ins = null;
            if (this.delegating != null) {
                this.delegating.setInputStream(this.cache.getInputStream());
            }
        }
    }

    public void hold() throws IOException {
        this.cache();
        this.cache.holdTempFile();
    }

    public void release() {
        this.cache.releaseTempFileHold();
    }

    public String getContentType() {
        return this.ct;
    }

    public DelegatingInputStream getDelegatingInputStream() {
        return this.delegating;
    }

    public InputStream getInputStream() {
        try {
            if (this.cache != null) {
                return this.cache.getInputStream();
            }
            return this.ins;
        }
        catch (IOException e) {
            return null;
        }
    }

    public String getName() {
        return null;
    }

    public OutputStream getOutputStream() throws IOException {
        throw new UnsupportedOperationException();
    }
}

