/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.joran;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.log4j.config.ConfiguratorBase;
import org.apache.log4j.joran.action.AppenderAction;
import org.apache.log4j.joran.action.AppenderRefAction;
import org.apache.log4j.joran.action.ConfigurationAction;
import org.apache.log4j.joran.action.ConversionRuleAction;
import org.apache.log4j.joran.action.JndiSubstitutionPropertyAction;
import org.apache.log4j.joran.action.LayoutAction;
import org.apache.log4j.joran.action.LevelAction;
import org.apache.log4j.joran.action.LoggerAction;
import org.apache.log4j.joran.action.NestComponentIA;
import org.apache.log4j.joran.action.NewRuleAction;
import org.apache.log4j.joran.action.ParamAction;
import org.apache.log4j.joran.action.PluginAction;
import org.apache.log4j.joran.action.PriorityAction;
import org.apache.log4j.joran.action.RepositoryPropertyAction;
import org.apache.log4j.joran.action.RootLoggerAction;
import org.apache.log4j.joran.action.SubstitutionPropertyAction;
import org.apache.log4j.joran.spi.ExecutionContext;
import org.apache.log4j.joran.spi.Interpreter;
import org.apache.log4j.joran.spi.JoranDocument;
import org.apache.log4j.joran.spi.Pattern;
import org.apache.log4j.joran.spi.SimpleRuleStore;
import org.apache.log4j.spi.ErrorItem;
import org.apache.log4j.spi.LoggerRepository;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class JoranConfigurator
extends ConfiguratorBase {
    Interpreter joranInterpreter;
    LoggerRepository repository;
    boolean listAppnderAttached = false;

    public final void doConfigure(final URL url, LoggerRepository repository) {
        ParseAction action = new ParseAction(){

            public void parse(SAXParser parser, DefaultHandler handler) throws SAXException, IOException {
                parser.parse(url.toString(), handler);
            }
        };
        this.doConfigure(action, repository);
    }

    public final void doConfigure(final String filename, LoggerRepository repository) {
        ParseAction action = new ParseAction(){

            public void parse(SAXParser parser, DefaultHandler handler) throws SAXException, IOException {
                parser.parse(new File(filename), handler);
            }
        };
        this.doConfigure(action, repository);
    }

    public final void doConfigure(final File file, LoggerRepository repository) {
        ParseAction action = new ParseAction(){

            public void parse(SAXParser parser, DefaultHandler handler) throws SAXException, IOException {
                parser.parse(file, handler);
            }
        };
        this.doConfigure(action, repository);
    }

    public final void doConfigure(final InputSource source, LoggerRepository repository) {
        ParseAction action = new ParseAction(){

            public void parse(SAXParser parser, DefaultHandler handler) throws SAXException, IOException {
                parser.parse(source, handler);
            }
        };
        this.doConfigure(action, repository);
    }

    public final void doConfigure(final InputStream stream, LoggerRepository repository) {
        ParseAction action = new ParseAction(){

            public void parse(SAXParser parser, DefaultHandler handler) throws SAXException, IOException {
                parser.parse(stream, handler);
            }
        };
        this.doConfigure(action, repository);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doConfigure(ParseAction action, LoggerRepository repository) {
        this.repository = repository;
        this.selfInitialize(this.repository);
        ExecutionContext ec = this.joranInterpreter.getExecutionContext();
        List errorList = ec.getErrorList();
        SAXParser saxParser = null;
        try {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            spf.setValidating(false);
            spf.setNamespaceAware(true);
            saxParser = spf.newSAXParser();
        }
        catch (Exception pce) {
            String errMsg = "Parser configuration error occured";
            this.getLogger(repository).error((Object)"Parser configuration error occured", pce);
            ec.addError(new ErrorItem("Parser configuration error occured", pce));
            return;
        }
        JoranDocument document = new JoranDocument(errorList, repository);
        try {
            action.parse(saxParser, document);
        }
        catch (IOException ie) {
            String errMsg = "I/O error occured while parsing xml file";
            this.getLogger(repository).error((Object)"I/O error occured while parsing xml file", ie);
            ec.addError(new ErrorItem("I/O error occured while parsing xml file", ie));
        }
        catch (Exception ex) {
            String errMsg = "Problem parsing XML document. See previously reported errors. Abandoning all further processing.";
            this.getLogger(repository).error((Object)"Problem parsing XML document. See previously reported errors. Abandoning all further processing.", ex);
            errorList.add(new ErrorItem("Problem parsing XML document. See previously reported errors. Abandoning all further processing."));
            return;
        }
        ec.pushObject(repository);
        try {
            try {
                this.attachListAppender(repository);
                document.replay(this.joranInterpreter);
                this.getLogger(repository).debug("Finished parsing.");
            }
            catch (SAXException e) {
                Object var11_15 = null;
                this.detachListAppender(repository);
                return;
            }
            Object var11_14 = null;
        }
        catch (Throwable throwable) {
            Object var11_16 = null;
            this.detachListAppender(repository);
            throw throwable;
        }
        this.detachListAppender(repository);
    }

    public List getErrorList() {
        return this.getExecutionContext().getErrorList();
    }

    protected void selfInitialize(LoggerRepository repository) {
        SimpleRuleStore rs = new SimpleRuleStore(repository);
        rs.addRule(new Pattern("configuration"), new ConfigurationAction());
        rs.addRule(new Pattern("configuration/substitutionProperty"), new SubstitutionPropertyAction());
        rs.addRule(new Pattern("configuration/repositoryProperty"), new RepositoryPropertyAction());
        rs.addRule(new Pattern("configuration/conversionRule"), new ConversionRuleAction());
        rs.addRule(new Pattern("configuration/plugin"), new PluginAction());
        rs.addRule(new Pattern("configuration/logger"), new LoggerAction());
        rs.addRule(new Pattern("configuration/logger/level"), new LevelAction());
        rs.addRule(new Pattern("configuration/logger/priority"), new PriorityAction());
        rs.addRule(new Pattern("configuration/root"), new RootLoggerAction());
        rs.addRule(new Pattern("configuration/root/level"), new LevelAction());
        rs.addRule(new Pattern("configuration/root/priority"), new PriorityAction());
        rs.addRule(new Pattern("configuration/logger/appender-ref"), new AppenderRefAction());
        rs.addRule(new Pattern("configuration/root/appender-ref"), new AppenderRefAction());
        rs.addRule(new Pattern("configuration/appender"), new AppenderAction());
        rs.addRule(new Pattern("configuration/appender/appender-ref"), new AppenderRefAction());
        rs.addRule(new Pattern("configuration/appender/layout"), new LayoutAction());
        rs.addRule(new Pattern("configuration/jndiSubstitutionProperty"), new JndiSubstitutionPropertyAction());
        rs.addRule(new Pattern("configuration/newRule"), new NewRuleAction());
        rs.addRule(new Pattern("*/param"), new ParamAction());
        this.joranInterpreter = new Interpreter(rs);
        this.joranInterpreter.setLoggerRepository(repository);
        this.joranInterpreter.addImplicitAction(new NestComponentIA());
        ExecutionContext ec = this.joranInterpreter.getExecutionContext();
        Map omap = ec.getObjectMap();
        omap.put("APPENDER_BAG", new HashMap());
        omap.put("FILTER_CHAIN_BAG", new HashMap());
    }

    public ExecutionContext getExecutionContext() {
        return this.joranInterpreter.getExecutionContext();
    }

    protected static interface ParseAction {
        public void parse(SAXParser var1, DefaultHandler var2) throws SAXException, IOException;
    }
}

