/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.helpers;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FileUtils {
    private static final int RETRY_SLEEP_MILLIS = 10;
    private static File defaultTempDir;

    private FileUtils() {
    }

    private static synchronized File getDefaultTempDir() {
        if (defaultTempDir != null && defaultTempDir.exists()) {
            return defaultTempDir;
        }
        String s = null;
        try {
            s = System.getProperty(FileUtils.class.getName() + ".TempDirectory");
        }
        catch (SecurityException e) {
            // empty catch block
        }
        if (s == null) {
            int x = (int)(Math.random() * 1000000.0);
            s = System.getProperty("java.io.tmpdir");
            File checkExists = new File(s);
            if (!checkExists.exists()) {
                throw new RuntimeException("The directory " + checkExists.getAbsolutePath() + " does not exist, please set java.io.tempdir" + " to an existing directory");
            }
            File f = new File(s, "cxf-tmp-" + x);
            while (!f.mkdir()) {
                x = (int)(Math.random() * 1000000.0);
                f = new File(s, "cxf-tmp-" + x);
            }
            defaultTempDir = f;
            Thread hook = new Thread(){

                public void run() {
                    FileUtils.removeDir(defaultTempDir);
                }
            };
            Runtime.getRuntime().addShutdownHook(hook);
        } else {
            File f = new File(s);
            f.mkdirs();
            defaultTempDir = f;
        }
        return defaultTempDir;
    }

    public static void mkDir(File dir) {
        boolean result;
        if (dir == null) {
            throw new RuntimeException("dir attribute is required");
        }
        if (dir.isFile()) {
            throw new RuntimeException("Unable to create directory as a file already exists with that name: " + dir.getAbsolutePath());
        }
        if (!dir.exists() && !(result = FileUtils.doMkDirs(dir))) {
            String msg = "Directory " + dir.getAbsolutePath() + " creation was not successful for an unknown reason";
            throw new RuntimeException(msg);
        }
    }

    private static boolean doMkDirs(File f) {
        if (!f.mkdirs()) {
            try {
                Thread.sleep(10L);
                return f.mkdirs();
            }
            catch (InterruptedException ex) {
                return f.mkdirs();
            }
        }
        return true;
    }

    public static void removeDir(File d) {
        String[] list = d.list();
        if (list == null) {
            list = new String[]{};
        }
        for (int i = 0; i < list.length; ++i) {
            String s = list[i];
            File f = new File(d, s);
            if (f.isDirectory()) {
                FileUtils.removeDir(f);
                continue;
            }
            FileUtils.delete(f);
        }
        FileUtils.delete(d);
    }

    public static void delete(File f) {
        if (!f.delete()) {
            if (FileUtils.isWindows()) {
                System.gc();
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!f.delete()) {
                f.deleteOnExit();
            }
        }
    }

    private static boolean isWindows() {
        String osName = System.getProperty("os.name").toLowerCase(Locale.US);
        return osName.indexOf("windows") > -1;
    }

    public static File createTempFile(String prefix, String suffix) throws IOException {
        return FileUtils.createTempFile(prefix, suffix, null, false);
    }

    public static File createTempFile(String prefix, String suffix, File parentDir, boolean deleteOnExit) throws IOException {
        File parent;
        File result = null;
        File file = parent = parentDir == null ? FileUtils.getDefaultTempDir() : parentDir;
        if (suffix == null) {
            suffix = ".tmp";
        }
        if (prefix == null) {
            prefix = "cxf";
        } else if (prefix.length() < 3) {
            prefix = prefix + "cxf";
        }
        result = File.createTempFile(prefix, suffix, parent);
        if (deleteOnExit && parentDir != null) {
            result.deleteOnExit();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getStringFromFile(File location) {
        FileInputStream is = null;
        String result = null;
        is = new FileInputStream(location);
        result = FileUtils.normalizeCRLF(is);
        Object var5_3 = null;
        if (is == null) return result;
        try {
            ((InputStream)is).close();
            return result;
        }
        catch (Exception e2) {}
        return result;
        {
            catch (Exception e) {
                e.printStackTrace();
                Object var5_4 = null;
                if (is == null) return result;
                try {
                    ((InputStream)is).close();
                    return result;
                }
                catch (Exception e2) {}
                return result;
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (is == null) throw throwable;
            try {
                ((InputStream)is).close();
                throw throwable;
            }
            catch (Exception e2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public static String normalizeCRLF(InputStream instream) {
        BufferedReader in = new BufferedReader(new InputStreamReader(instream));
        StringBuffer result = new StringBuffer();
        String line = null;
        try {
            line = in.readLine();
            while (line != null) {
                String[] tok = line.split("\\s");
                for (int x = 0; x < tok.length; ++x) {
                    String token = tok[x];
                    result.append("  " + token);
                }
                line = in.readLine();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        String rtn = result.toString();
        rtn = FileUtils.ignoreTokens(rtn, "<!--", "-->");
        rtn = FileUtils.ignoreTokens(rtn, "/*", "*/");
        return rtn;
    }

    private static String ignoreTokens(String contents, String startToken, String endToken) {
        String rtn = contents;
        int headerIndexStart = rtn.indexOf(startToken);
        int headerIndexEnd = rtn.indexOf(endToken);
        if (headerIndexStart != -1 && headerIndexEnd != -1 && headerIndexStart < headerIndexEnd) {
            rtn = rtn.substring(0, headerIndexStart - 1) + rtn.substring(headerIndexEnd + endToken.length() + 1);
        }
        return rtn;
    }

    public static List<File> getFiles(File dir, String pattern) {
        return FileUtils.getFiles(dir, pattern, null);
    }

    public static List<File> getFiles(File dir, final String pattern, File exclude) {
        File[] files = dir.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.matches(pattern);
            }
        });
        if (files == null) {
            return new ArrayList<File>();
        }
        ArrayList<File> fileList = new ArrayList<File>();
        for (File file : files) {
            if (file.equals(exclude)) continue;
            fileList.add(file);
        }
        return fileList;
    }

    public static List<String> readLines(File file) throws Exception {
        if (!file.exists()) {
            return new ArrayList<String>();
        }
        BufferedReader reader = new BufferedReader(new FileReader(file));
        ArrayList<String> results = new ArrayList<String>();
        String line = reader.readLine();
        while (line != null) {
            results.add(line);
            line = reader.readLine();
        }
        return results;
    }
}

