/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.war.packaging;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Iterator;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.war.packaging.WarPackagingContext;
import org.apache.maven.plugin.war.packaging.WarPackagingTask;
import org.apache.maven.plugin.war.util.MappingUtils;
import org.apache.maven.plugin.war.util.PathSet;
import org.apache.maven.plugin.war.util.WebappStructure;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.InterpolationFilterReader;

public abstract class AbstractWarPackagingTask
implements WarPackagingTask {
    public static final String[] DEFAULT_INCLUDES = new String[]{"**/**"};
    public static final String WEB_INF_PATH = "WEB-INF";
    public static final String META_INF_PATH = "META-INF";
    public static final String CLASSES_PATH = "WEB-INF/classes/";
    public static final String LIB_PATH = "WEB-INF/lib/";

    protected void copyFiles(String sourceId, WarPackagingContext context, File sourceBaseDir, PathSet sourceFilesSet, String targetPrefix) throws IOException {
        Iterator iter = sourceFilesSet.iterator();
        while (iter.hasNext()) {
            String fileToCopyName = (String)iter.next();
            File sourceFile = new File(sourceBaseDir, fileToCopyName);
            String destinationFileName = targetPrefix == null ? fileToCopyName : targetPrefix + fileToCopyName;
            this.copyFile(sourceId, context, sourceFile, destinationFileName);
        }
    }

    protected void copyFiles(String sourceId, WarPackagingContext context, File sourceBaseDir, PathSet sourceFilesSet) throws IOException {
        this.copyFiles(sourceId, context, sourceBaseDir, sourceFilesSet, null);
    }

    protected void copyFile(String sourceId, final WarPackagingContext context, final File file, String targetFilename) throws IOException {
        final File targetFile = new File(context.getWebappDirectory(), targetFilename);
        context.getWebappStructure().registerFile(sourceId, targetFilename, new WebappStructure.RegistrationCallback(){

            public void registered(String ownerId, String targetFilename) throws IOException {
                AbstractWarPackagingTask.this.copyFile(context, file, targetFile, targetFilename, false);
            }

            public void alreadyRegistered(String ownerId, String targetFilename) throws IOException {
                AbstractWarPackagingTask.this.copyFile(context, file, targetFile, targetFilename, true);
            }

            public void refused(String ownerId, String targetFilename, String actualOwnerId) throws IOException {
                context.getLog().debug((CharSequence)(" - " + targetFilename + " wasn't copied because it has " + "already been packaged for overlay[" + actualOwnerId + "]."));
            }

            public void superseded(String ownerId, String targetFilename, String deprecatedOwnerId) throws IOException {
                context.getLog().info((CharSequence)("File[" + targetFilename + "] belonged to overlay[" + deprecatedOwnerId + "] so it will be overwritten."));
                AbstractWarPackagingTask.this.copyFile(context, file, targetFile, targetFilename, false);
            }

            public void supersededUnknownOwner(String ownerId, String targetFilename, String unknownOwnerId) throws IOException {
                context.getLog().warn((CharSequence)("File[" + targetFilename + "] belonged to overlay[" + unknownOwnerId + "] which does not exist anymore in the current project. It is recommended to invoke " + "clean if the dependencies of the project changed."));
                AbstractWarPackagingTask.this.copyFile(context, file, targetFile, targetFilename, false);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean copyFilteredFile(String sourceId, WarPackagingContext context, File file, String targetFilename) throws IOException, MojoExecutionException {
        block3: {
            if (!context.getWebappStructure().registerFile(sourceId, targetFilename)) break block3;
            File targetFile = new File(context.getWebappDirectory(), targetFilename);
            BufferedReader fileReader = null;
            FileWriter fileWriter = null;
            try {
                targetFile.getParentFile().mkdirs();
                fileReader = new BufferedReader(new FileReader(file));
                fileWriter = new FileWriter(targetFile);
                Reader reader = fileReader;
                for (int i = 0; i < this.getFilterWrappers().length; ++i) {
                    FilterWrapper wrapper = this.getFilterWrappers()[i];
                    reader = wrapper.getReader(reader, context.getFilterProperties());
                }
                IOUtil.copy((Reader)reader, (Writer)fileWriter);
            }
            catch (Throwable throwable) {
                IOUtil.close(fileReader);
                IOUtil.close(fileWriter);
                throw throwable;
            }
            IOUtil.close((Reader)fileReader);
            IOUtil.close((Writer)fileWriter);
            context.getLog().debug((CharSequence)(" + " + targetFilename + " has been copied."));
            return true;
        }
        context.getLog().debug((CharSequence)(" - " + targetFilename + " wasn't copied because it has already been packaged."));
        return false;
    }

    protected void doUnpack(WarPackagingContext context, File file, File unpackDirectory) throws MojoExecutionException {
        String archiveExt = FileUtils.getExtension((String)file.getAbsolutePath()).toLowerCase();
        try {
            UnArchiver unArchiver = context.getArchiverManager().getUnArchiver(archiveExt);
            unArchiver.setSourceFile(file);
            unArchiver.setDestDirectory(unpackDirectory);
            unArchiver.setOverwrite(true);
            unArchiver.extract();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error unpacking file[" + file.getAbsolutePath() + "]" + "to[" + unpackDirectory.getAbsolutePath() + "]", (Exception)e);
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("Error unpacking file[" + file.getAbsolutePath() + "]" + "to[" + unpackDirectory.getAbsolutePath() + "]", (Exception)((Object)e));
        }
        catch (NoSuchArchiverException e) {
            context.getLog().warn((CharSequence)("Skip unpacking dependency file[" + file.getAbsolutePath() + " with unknown extension[" + archiveExt + "]"));
        }
    }

    protected boolean copyFile(WarPackagingContext context, File source, File destination, String targetFilename, boolean onlyIfModified) throws IOException {
        if (onlyIfModified && destination.lastModified() >= source.lastModified()) {
            context.getLog().debug((CharSequence)(" * " + targetFilename + " is up to date."));
            return false;
        }
        FileUtils.copyFile((File)source.getCanonicalFile(), (File)destination);
        destination.setLastModified(source.lastModified());
        context.getLog().debug((CharSequence)(" + " + targetFilename + " has been copied."));
        return true;
    }

    protected PathSet getFilesToIncludes(File baseDir, String[] includes, String[] excludes) {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(baseDir);
        if (excludes != null) {
            scanner.setExcludes(excludes);
        }
        scanner.addDefaultExcludes();
        if (includes != null && includes.length > 0) {
            scanner.setIncludes(includes);
        } else {
            scanner.setIncludes(DEFAULT_INCLUDES);
        }
        scanner.scan();
        return new PathSet(scanner.getIncludedFiles());
    }

    protected String getArtifactFinalName(WarPackagingContext context, Artifact artifact) {
        if (context.getOutputFileNameMapping() != null) {
            return MappingUtils.evaluateFileNameMapping(context.getOutputFileNameMapping(), artifact);
        }
        String classifier = artifact.getClassifier();
        if (classifier != null && !"".equals(classifier.trim())) {
            return MappingUtils.evaluateFileNameMapping("${artifactId}-${version}-${classifier}.${extension}", artifact);
        }
        return MappingUtils.evaluateFileNameMapping("${artifactId}-${version}.${extension}", artifact);
    }

    private FilterWrapper[] getFilterWrappers() {
        return new FilterWrapper[]{new FilterWrapper(){

            public Reader getReader(Reader fileReader, Map filterProperties) {
                return new InterpolationFilterReader(fileReader, filterProperties, "${", "}");
            }
        }, new FilterWrapper(){

            public Reader getReader(Reader fileReader, Map filterProperties) {
                return new InterpolationFilterReader(fileReader, filterProperties, "@", "@");
            }
        }};
    }

    public abstract /* synthetic */ void performPackaging(WarPackagingContext var1) throws MojoExecutionException, MojoFailureException;

    private static interface FilterWrapper {
        public Reader getReader(Reader var1, Map var2);
    }
}

