/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.war.packaging;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.war.Overlay;
import org.apache.maven.plugin.war.packaging.AbstractWarPackagingTask;
import org.apache.maven.plugin.war.packaging.WarPackagingContext;

public class ArtifactsPackagingTask
extends AbstractWarPackagingTask {
    public static final String TLD_PATH = "WEB-INF/tld/";
    public static final String SERVICES_PATH = "WEB-INF/services/";
    private final Set artifacts;
    private final String id;

    public ArtifactsPackagingTask(Set artifacts) {
        this.artifacts = artifacts;
        this.id = Overlay.currentProjectInstance().getId();
    }

    public void performPackaging(WarPackagingContext context) throws MojoExecutionException {
        ScopeArtifactFilter filter = new ScopeArtifactFilter("runtime");
        List duplicates = this.findDuplicates(context, this.artifacts);
        Iterator iter = this.artifacts.iterator();
        while (iter.hasNext()) {
            Artifact artifact = (Artifact)iter.next();
            String targetFileName = this.getArtifactFinalName(context, artifact);
            context.getLog().debug((CharSequence)("Processing: " + targetFileName));
            if (duplicates.contains(targetFileName)) {
                context.getLog().debug((CharSequence)("Duplicate found: " + targetFileName));
                targetFileName = artifact.getGroupId() + "-" + targetFileName;
                context.getLog().debug((CharSequence)("Renamed to: " + targetFileName));
            }
            if (artifact.isOptional() || !filter.include(artifact)) continue;
            try {
                String type = artifact.getType();
                if ("tld".equals(type)) {
                    this.copyFile(this.id, context, artifact.getFile(), TLD_PATH + targetFileName);
                    continue;
                }
                if ("aar".equals(type)) {
                    this.copyFile(this.id, context, artifact.getFile(), SERVICES_PATH + targetFileName);
                    continue;
                }
                if ("jar".equals(type) || "ejb".equals(type) || "ejb-client".equals(type) || "test-jar".equals(type)) {
                    this.copyFile(this.id, context, artifact.getFile(), "WEB-INF/lib/" + targetFileName);
                    continue;
                }
                if ("par".equals(type)) {
                    targetFileName = targetFileName.substring(0, targetFileName.lastIndexOf(46)) + ".jar";
                    this.copyFile(this.id, context, artifact.getFile(), "WEB-INF/lib/" + targetFileName);
                    continue;
                }
                if ("war".equals(type) || "zip".equals(type)) continue;
                context.getLog().debug((CharSequence)("Artifact of type[" + type + "] is not supported, ignoring[" + artifact + "]"));
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to copy file for artifact[" + artifact + "]", (Exception)e);
            }
        }
    }

    private List findDuplicates(WarPackagingContext context, Set artifacts) {
        ArrayList<String> duplicates = new ArrayList<String>();
        ArrayList<String> identifiers = new ArrayList<String>();
        Iterator iter = artifacts.iterator();
        while (iter.hasNext()) {
            Artifact artifact = (Artifact)iter.next();
            String candidate = this.getArtifactFinalName(context, artifact);
            if (identifiers.contains(candidate)) {
                duplicates.add(candidate);
                continue;
            }
            identifiers.add(candidate);
        }
        return duplicates;
    }
}

