/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.war.packaging;

import java.io.File;
import java.io.IOException;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.war.Overlay;
import org.apache.maven.plugin.war.packaging.AbstractWarPackagingTask;
import org.apache.maven.plugin.war.packaging.ArtifactsPackagingTask;
import org.apache.maven.plugin.war.packaging.ClassesPackagingTask;
import org.apache.maven.plugin.war.packaging.WarPackagingContext;
import org.apache.maven.plugin.war.util.PathSet;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.StringUtils;

public class WarProjectPackagingTask
extends AbstractWarPackagingTask {
    private final Resource[] webResources;
    private final File webXml;
    private final File containerConfigXML;
    private final String id;

    public WarProjectPackagingTask(Resource[] webResources, File webXml, File containerConfigXml) {
        this.webResources = webResources != null ? webResources : new Resource[0];
        this.webXml = webXml;
        this.containerConfigXML = containerConfigXml;
        this.id = Overlay.currentProjectInstance().getId();
    }

    public void performPackaging(WarPackagingContext context) throws MojoExecutionException, MojoFailureException {
        context.getLog().info((CharSequence)"Processing war project");
        File webinfDir = new File(context.getWebappDirectory(), "WEB-INF");
        webinfDir.mkdirs();
        File metainfDir = new File(context.getWebappDirectory(), "META-INF");
        metainfDir.mkdirs();
        this.handleWebResources(context);
        this.handeWebAppSourceDirectory(context);
        this.handleDeploymentDescriptors(context, webinfDir, metainfDir);
        this.handleClassesDirectory(context);
        this.handleArtifacts(context);
    }

    protected void handleWebResources(WarPackagingContext context) throws MojoExecutionException {
        for (int i = 0; i < this.webResources.length; ++i) {
            Resource resource = this.webResources[i];
            if (!new File(resource.getDirectory()).isAbsolute()) {
                resource.setDirectory(context.getProject().getBasedir() + File.separator + resource.getDirectory());
            }
            if (resource.getDirectory().equals(context.getWebappDirectory().getPath())) continue;
            try {
                this.copyResources(context, resource);
                continue;
            }
            catch (IOException e) {
                throw new MojoExecutionException("Could not copy resource[" + resource.getDirectory() + "]", (Exception)e);
            }
        }
    }

    protected void handeWebAppSourceDirectory(WarPackagingContext context) throws MojoExecutionException {
        if (!context.getWebappSourceDirectory().exists()) {
            context.getLog().debug((CharSequence)"webapp sources directory does not exist - skipping.");
        } else if (!context.getWebappSourceDirectory().getAbsolutePath().equals(context.getWebappDirectory().getPath())) {
            PathSet sources = this.getFilesToIncludes(context.getWebappSourceDirectory(), context.getWebappSourceIncludes(), context.getWebappSourceExcludes());
            try {
                this.copyFiles(this.id, context, context.getWebappSourceDirectory(), sources);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Could not copy webapp sources[" + context.getWebappDirectory().getAbsolutePath() + "]", (Exception)e);
            }
        }
    }

    protected void handleArtifacts(WarPackagingContext context) throws MojoExecutionException {
        ArtifactsPackagingTask task = new ArtifactsPackagingTask(context.getProject().getArtifacts());
        task.performPackaging(context);
    }

    protected void handleClassesDirectory(WarPackagingContext context) throws MojoExecutionException {
        ClassesPackagingTask task = new ClassesPackagingTask();
        task.performPackaging(context);
    }

    protected void handleDeploymentDescriptors(WarPackagingContext context, File webinfDir, File metainfDir) throws MojoFailureException, MojoExecutionException {
        try {
            if (this.webXml != null && StringUtils.isNotEmpty((String)this.webXml.getName())) {
                if (!this.webXml.exists()) {
                    throw new MojoFailureException("The specified web.xml file '" + this.webXml + "' does not exist");
                }
                this.copyFile(context, this.webXml, new File(webinfDir, "web.xml"), "WEB-INF/web.xml", true);
                context.getWebappStructure().getFullStructure().add("WEB-INF/web.xml");
            }
            if (this.containerConfigXML != null && StringUtils.isNotEmpty((String)this.containerConfigXML.getName())) {
                String xmlFileName = this.containerConfigXML.getName();
                this.copyFile(context, this.containerConfigXML, new File(metainfDir, xmlFileName), "META-INF/" + xmlFileName, true);
                context.getWebappStructure().getFullStructure().add("META-INF/" + xmlFileName);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to copy deployment descriptor", (Exception)e);
        }
    }

    public void copyResources(WarPackagingContext context, Resource resource) throws IOException, MojoExecutionException {
        if (!context.getWebappDirectory().exists()) {
            context.getLog().warn((CharSequence)("Not copying webapp webResources[" + resource.getDirectory() + "]: webapp directory[" + context.getWebappDirectory().getAbsolutePath() + "] does not exist!"));
        }
        context.getLog().info((CharSequence)("Copy webapp webResources[" + resource.getDirectory() + "] to[" + context.getWebappDirectory().getAbsolutePath() + "]"));
        String[] fileNames = this.getFilesToCopy(resource);
        for (int i = 0; i < fileNames.length; ++i) {
            String targetFileName = fileNames[i];
            if (resource.getTargetPath() != null) {
                targetFileName = resource.getTargetPath() + File.separator + targetFileName;
            }
            if (resource.isFiltering()) {
                this.copyFilteredFile(this.id, context, new File(resource.getDirectory(), fileNames[i]), targetFileName);
                continue;
            }
            this.copyFile(this.id, context, new File(resource.getDirectory(), fileNames[i]), targetFileName);
        }
    }

    private String[] getFilesToCopy(Resource resource) {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(resource.getDirectory());
        if (resource.getIncludes() != null && !resource.getIncludes().isEmpty()) {
            scanner.setIncludes(resource.getIncludes().toArray(new String[resource.getIncludes().size()]));
        } else {
            scanner.setIncludes(AbstractWarPackagingTask.DEFAULT_INCLUDES);
        }
        if (resource.getExcludes() != null && !resource.getExcludes().isEmpty()) {
            scanner.setExcludes(resource.getExcludes().toArray(new String[resource.getExcludes().size()]));
        }
        scanner.addDefaultExcludes();
        scanner.scan();
        return scanner.getIncludedFiles();
    }
}

