/*
 * Decompiled with CFR 0.152.
 */
package jeus.deploy.archivist;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import jeus.deploy.archivist.AbstractArchive;
import jeus.deploy.archivist.ArchiveHelper;
import jeus.deploy.archivist.FileArchive;
import jeus.util.file.FileUtils;

public class InputJarArchive
extends AbstractArchive {
    protected JarFile jarFile = null;
    protected JarInputStream jarIS = null;
    private String archiveUri;
    private InputJarArchive parentArchive = null;
    private URL jarFileUrl = null;

    public String getArchiveUri() {
        return this.archiveUri;
    }

    public OutputStream addEntry(String name) throws IOException {
        throw new UnsupportedOperationException("Cannot write to an JAR archive open for reading");
    }

    public void close() throws IOException {
        if (this.jarFile != null) {
            this.jarFile.close();
            this.jarFile = null;
            this.jarFileUrl = null;
        }
        if (this.jarIS != null) {
            this.jarIS.close();
            this.jarIS = null;
        }
    }

    public void closeEntry(OutputStream os) throws IOException {
        throw new UnsupportedOperationException("Cannot write to an JAR archive open for reading");
    }

    public void create(String path) throws IOException {
        throw new UnsupportedOperationException("Cannot write to an JAR archive open for reading");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration entries() {
        Vector<String> entries;
        block12: {
            entries = new Vector<String>();
            if (this.parentArchive != null) {
                try {
                    this.jarIS = new JarInputStream(this.parentArchive.jarFile.getInputStream(this.parentArchive.jarFile.getJarEntry(this.archiveUri)));
                    try {
                        JarEntry ze;
                        do {
                            if ((ze = this.jarIS.getNextJarEntry()) == null || FileUtils.isDirectory(ze)) continue;
                            entries.add(ze.getName());
                        } while (ze != null);
                        break block12;
                    }
                    finally {
                        this.jarIS.close();
                        this.jarIS = null;
                    }
                }
                catch (IOException ioe) {
                    return null;
                }
            }
            try {
                if (this.jarFile == null) {
                    this.getJarFile(this.archiveUri);
                }
            }
            catch (IOException ioe) {
                return entries.elements();
            }
            if (this.jarFile == null) {
                return entries.elements();
            }
            Enumeration<JarEntry> enum1 = this.jarFile.entries();
            while (enum1.hasMoreElements()) {
                ZipEntry ze = enum1.nextElement();
                if (FileUtils.isDirectory(ze) || ze.getName().equals("META-INF/MANIFEST.MF")) continue;
                entries.add(ze.getName());
            }
        }
        return entries.elements();
    }

    public Enumeration entries(Enumeration embeddedArchives) {
        return this.entries();
    }

    public InputStream getEntry(String entryName) throws IOException {
        String alternativeEntryName = entryName.replace('/', File.separatorChar);
        if (alternativeEntryName.equals(entryName)) {
            alternativeEntryName = entryName.replace(File.separatorChar, '/');
        }
        if (this.jarFile != null) {
            ZipEntry ze = this.jarFile.getEntry(entryName);
            if (ze != null) {
                return new BufferedInputStream(this.jarFile.getInputStream(ze));
            }
            ze = this.jarFile.getEntry(alternativeEntryName);
            if (ze != null) {
                return new BufferedInputStream(this.jarFile.getInputStream(ze));
            }
            return null;
        }
        if (this.parentArchive != null && this.parentArchive.jarFile != null) {
            JarEntry je;
            JarEntry archiveJarEntry;
            if (this.jarIS != null) {
                this.jarIS.close();
            }
            JarEntry jarEntry = archiveJarEntry = this.archiveUri == null ? null : this.parentArchive.jarFile.getJarEntry(this.archiveUri);
            if (archiveJarEntry == null) {
                return null;
            }
            this.jarIS = new JarInputStream(this.parentArchive.jarFile.getInputStream(archiveJarEntry));
            while ((je = this.jarIS.getNextJarEntry()) != null && !je.getName().equals(entryName) && !je.getName().equals(alternativeEntryName)) {
            }
            if (je != null) {
                return new BufferedInputStream(this.jarIS);
            }
            return null;
        }
        return null;
    }

    public void open(String path) throws IOException {
        this.archiveUri = path;
        this.jarFile = this.getJarFile(path);
    }

    public void open(File path) throws IOException {
        this.archiveUri = path.getAbsolutePath();
        if (path.exists()) {
            this.jarFile = new JarFile(path);
            this.jarFileUrl = new URL("jar:" + path.toURL() + "!/");
        } else {
            this.jarFile = null;
            this.jarFileUrl = null;
        }
    }

    public JarFile getJarFile() {
        return this.jarFile;
    }

    protected JarFile getJarFile(String path) throws IOException {
        this.jarFile = null;
        this.jarFileUrl = null;
        File file = new File(path);
        if (file.exists()) {
            this.jarFile = new JarFile(file);
            this.jarFileUrl = new URL("jar:" + file.toURL() + "!/");
        }
        return this.jarFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Manifest getManifest() throws IOException {
        if (this.jarFile != null) {
            JarEntry appclientxmlentry = this.jarFile.getJarEntry("META-INF/MANIFEST.MF");
            if (appclientxmlentry == null) {
                appclientxmlentry = this.jarFile.getJarEntry("META-INF" + File.separator + "MANIFEST.MF");
            }
            if (appclientxmlentry == null) {
                return null;
            }
            InputStream isAppclientXml = this.jarFile.getInputStream(appclientxmlentry);
            try {
                Manifest manifest = new Manifest(isAppclientXml);
                return manifest;
            }
            finally {
                isAppclientXml.close();
            }
        }
        if (this.parentArchive != null) {
            Manifest m;
            if (this.jarIS != null) {
                this.jarIS.close();
            }
            if (this.jarIS == null) {
                this.jarIS = new JarInputStream(this.parentArchive.jarFile.getInputStream(this.parentArchive.jarFile.getJarEntry(this.archiveUri)));
            }
            if ((m = this.jarIS.getManifest()) == null) {
                InputStream is = this.getEntry("META-INF/MANIFEST.MF");
                if (is == null) {
                    is = this.getEntry("META-INF" + File.separator + "MANIFEST.MF");
                }
                if (is != null) {
                    m = new Manifest();
                    m.read(is);
                    is.close();
                }
            }
            return m;
        }
        return null;
    }

    public boolean exists() {
        return this.jarFile != null;
    }

    public boolean delete() {
        if (this.jarFile == null) {
            return false;
        }
        try {
            this.jarFile.close();
            this.jarFile = null;
            this.jarFileUrl = null;
        }
        catch (IOException ioe) {
            return false;
        }
        return new File(this.archiveUri).delete();
    }

    public boolean renameTo(String name) {
        if (this.jarFile == null) {
            return false;
        }
        try {
            this.jarFile.close();
            this.jarFile = null;
            this.jarFileUrl = null;
        }
        catch (IOException ioe) {
            return false;
        }
        return new File(this.archiveUri).renameTo(new File(name));
    }

    public AbstractArchive getEmbeddedArchive(String name) throws IOException {
        if (this.jarFile != null) {
            InputJarArchive ija = new InputJarArchive();
            JarEntry je = this.jarFile.getJarEntry(name);
            if (je != null) {
                JarInputStream jis = new JarInputStream(new BufferedInputStream(this.jarFile.getInputStream(je)));
                ija.archiveUri = name;
                ija.jarIS = jis;
                ija.parentArchive = this;
                return ija;
            }
        }
        return null;
    }

    public void closeEntry(AbstractArchive os) throws IOException {
        throw new UnsupportedOperationException("Cannot write to an JAR archive open for reading");
    }

    public boolean supportsElementsOverwriting() {
        return false;
    }

    public boolean contains(String entryName) throws IOException {
        entryName = entryName.replace('\\', '/');
        if (this.jarFile != null) {
            ZipEntry ze = this.jarFile.getEntry(entryName);
            return ze != null;
        }
        if (this.parentArchive != null && this.parentArchive.jarFile != null) {
            JarEntry je;
            JarEntry archiveJarEntry;
            if (this.jarIS != null) {
                this.jarIS.close();
            }
            JarEntry jarEntry = archiveJarEntry = this.archiveUri == null ? null : this.parentArchive.jarFile.getJarEntry(this.archiveUri);
            if (archiveJarEntry == null) {
                return false;
            }
            this.jarIS = new JarInputStream(this.parentArchive.jarFile.getInputStream(archiveJarEntry));
            while ((je = this.jarIS.getNextJarEntry()) != null && !je.getName().equals(entryName)) {
            }
            if (je != null) {
                this.jarIS.closeEntry();
                return true;
            }
            return false;
        }
        return false;
    }

    public URL getArchiveUrl() {
        return this.jarFileUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void extractArchive(FileArchive earHomeArchive, String s) throws IOException {
        AbstractArchive targetArchive = earHomeArchive.getEmbeddedArchive(s);
        Enumeration<JarEntry> enum1 = this.jarFile.entries();
        while (enum1.hasMoreElements()) {
            ZipEntry entryName = enum1.nextElement();
            if (FileUtils.isDirectory(entryName)) continue;
            OutputStream os = null;
            InputStream is = null;
            try {
                os = targetArchive.addEntry(entryName.getName());
                is = this.jarFile.getInputStream(entryName);
                if (is == null) {
                    throw new UnsupportedOperationException("Cannot read " + entryName + " in " + this.jarFile.getName());
                }
                ArchiveHelper.copy(is, os);
            }
            finally {
                if (is != null) {
                    is.close();
                    is = null;
                }
                if (os == null) continue;
                os.close();
                os = null;
            }
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof InputJarArchive) {
            return this.archiveUri.equals(((InputJarArchive)obj).archiveUri);
        }
        return false;
    }

    public String getClassFtpUri(int count) {
        String extension = this.archiveUri.substring(this.archiveUri.lastIndexOf("."));
        return this.archiveUri.substring(0, this.archiveUri.lastIndexOf(".")) + "___" + count + extension;
    }
}

