/*
 * Decompiled with CFR 0.152.
 */
package jeus.deploy.archivist;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import jeus.deploy.archivist.AbstractArchive;
import jeus.deploy.archivist.ArchiveHelper;
import jeus.deploy.archivist.FileArchive;
import jeus.deploy.archivist.FileArchiveFactory;

public class MemoryMappedArchive
extends AbstractArchive {
    byte[] file;

    protected MemoryMappedArchive() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MemoryMappedArchive(InputStream is) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BufferedInputStream bis = null;
        FilterOutputStream bos = null;
        try {
            bis = new BufferedInputStream(is);
            bos = new BufferedOutputStream(baos);
            ArchiveHelper.copy((InputStream)bis, bos);
        }
        finally {
            if (bis != null) {
                bis.close();
                bis = null;
            }
            if (bos != null) {
                bos.close();
                bos = null;
            }
        }
        this.file = baos.toByteArray();
    }

    public MemoryMappedArchive(AbstractArchive source) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        JarOutputStream jos = new JarOutputStream(new BufferedOutputStream(baos));
        Enumeration elements = source.entries();
        while (elements.hasMoreElements()) {
            String elementName = (String)elements.nextElement();
            InputStream is = source.getEntry(elementName);
            jos.putNextEntry(new ZipEntry(elementName));
            ArchiveHelper.copyWithoutClose(is, jos);
            is.close();
            jos.flush();
            jos.closeEntry();
        }
        jos.close();
        this.file = baos.toByteArray();
    }

    public OutputStream addEntry(String name) throws IOException {
        return null;
    }

    public void close() throws IOException {
    }

    public void closeEntry(AbstractArchive os) throws IOException {
    }

    public void closeEntry(OutputStream os) throws IOException {
    }

    public boolean delete() {
        return false;
    }

    public Enumeration entries() {
        Vector<String> entries = new Vector<String>();
        try {
            ZipEntry ze;
            JarInputStream jis = new JarInputStream(new ByteArrayInputStream(this.file));
            while ((ze = jis.getNextEntry()) != null) {
                entries.add(ze.getName());
            }
            jis.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return entries.elements();
    }

    public Enumeration entries(Enumeration embeddedArchives) {
        return this.entries();
    }

    public boolean exists() {
        return false;
    }

    public String getArchiveUri() {
        return null;
    }

    public AbstractArchive getEmbeddedArchive(String name) throws IOException {
        InputStream is = this.getEntry(name);
        if (is != null) {
            MemoryMappedArchive archive = new MemoryMappedArchive(is);
            is.close();
            return archive;
        }
        return null;
    }

    public InputStream getEntry(String name) throws IOException {
        ZipEntry ze;
        JarInputStream jis = new JarInputStream(new ByteArrayInputStream(this.file));
        while ((ze = jis.getNextEntry()) != null) {
            if (!ze.getName().equals(name)) continue;
            return new BufferedInputStream(jis);
        }
        return null;
    }

    public Manifest getManifest() throws IOException {
        JarInputStream jis = new JarInputStream(new ByteArrayInputStream(this.file));
        Manifest m = jis.getManifest();
        jis.close();
        return m;
    }

    public boolean renameTo(String name) {
        return false;
    }

    public boolean supportsElementsOverwriting() {
        return false;
    }

    public boolean contains(String name) throws IOException {
        ZipEntry zipentry;
        JarInputStream jis = new JarInputStream(new ByteArrayInputStream(this.file));
        while ((zipentry = jis.getNextEntry()) != null) {
            if (!zipentry.getName().equals(name)) continue;
            jis.close();
            return true;
        }
        return false;
    }

    public URL getArchiveUrl() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileArchive toFileArchive(String directory) throws IOException {
        FileArchive fileArchive = (FileArchive)FileArchiveFactory.appendArchive(directory);
        Enumeration namesList = this.entries();
        while (namesList.hasMoreElements()) {
            String entryName = (String)namesList.nextElement();
            InputStream is = null;
            OutputStream os = null;
            try {
                is = this.getEntry(entryName);
                os = fileArchive.addEntry(entryName);
                ArchiveHelper.copy(is, os);
            }
            finally {
                if (is != null) {
                    is.close();
                    is = null;
                }
                if (os == null) continue;
                os.close();
                os = null;
            }
        }
        return fileArchive;
    }
}

