/*
 * Decompiled with CFR 0.152.
 */
package jeus.deploy.archivist;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import jeus.deploy.archivist.AbstractArchive;

public class OutputJarArchive
extends AbstractArchive {
    private String archiveUri;
    protected ZipOutputStream jos;
    private Manifest manifest;
    private URL archiveUrl;
    private Vector entries = new Vector();

    public String getArchiveUri() {
        return this.archiveUri;
    }

    public OutputStream addEntry(String name) throws IOException {
        if (this.jos != null) {
            ZipEntry ze = new ZipEntry(name);
            this.jos.putNextEntry(ze);
            this.entries.add(name);
        }
        return this.jos;
    }

    public void close() throws IOException {
        if (this.jos != null) {
            this.jos.flush();
            this.jos.finish();
            this.jos.close();
            this.jos = null;
        }
    }

    public void closeEntry(OutputStream os) throws IOException {
        if (os instanceof ZipOutputStream) {
            ((ZipOutputStream)os).flush();
        }
        ((ZipOutputStream)os).closeEntry();
    }

    public void create(String path) throws IOException {
        this.archiveUri = path;
        File file = new File(path);
        this.archiveUrl = new URL("jar:" + file.toURL() + "!/");
        if (file.exists()) {
            file.delete();
        }
        FileOutputStream fos = new FileOutputStream(file);
        BufferedOutputStream bos = new BufferedOutputStream(fos);
        this.jos = new ZipOutputStream(bos);
    }

    public Enumeration entries() {
        return this.entries.elements();
    }

    public Enumeration entries(Enumeration embeddedArchives) {
        return this.entries();
    }

    public InputStream getEntry(String name) throws IOException {
        throw new UnsupportedOperationException("Cannot read from a JAR archive open for writing");
    }

    public void open(String path) throws IOException {
        throw new UnsupportedOperationException("Cannot read jar files");
    }

    public Manifest getManifest() throws IOException {
        if (this.manifest != null) {
            this.manifest = new Manifest();
        }
        return this.manifest;
    }

    public boolean exists() {
        throw new UnsupportedOperationException("Cannot read from a JAR archive open for writing");
    }

    public boolean delete() {
        throw new UnsupportedOperationException("Cannot read from a JAR archive open for writing");
    }

    public boolean renameTo(String name) {
        throw new UnsupportedOperationException("Cannot read from a JAR archive open for writing");
    }

    public AbstractArchive getEmbeddedArchive(String name) throws IOException {
        OutputStream os = this.addEntry(name);
        ZipOutputStream jos = new ZipOutputStream(os);
        OutputJarArchive ja = new OutputJarArchive();
        ja.archiveUri = name;
        ja.archiveUrl = new URL("jar:" + this.archiveUrl + name + "!/");
        ja.jos = jos;
        return ja;
    }

    public void closeEntry(AbstractArchive os) throws IOException {
        if (os instanceof OutputJarArchive) {
            ((OutputJarArchive)os).jos.flush();
        }
        ((OutputJarArchive)os).jos.finish();
        this.jos.closeEntry();
    }

    public boolean supportsElementsOverwriting() {
        return false;
    }

    public boolean contains(String aClass) throws IOException {
        return this.entries.contains(aClass);
    }

    public URL getArchiveUrl() {
        return this.archiveUrl;
    }
}

