/*
 * Decompiled with CFR 0.152.
 */
package jeus.io.helper;

import java.io.IOException;
import jeus.io.Selector;
import jeus.io.handler.StreamHandler;
import jeus.io.impl.nio.NIOSelector;

public class DualSelectorWrapper
extends Selector {
    private Selector readSelector;
    private Selector writeSelector;
    private int readOp;
    private int writeOp;

    public DualSelectorWrapper(String selectorName) {
        this.readSelector = NIOSelector.open(selectorName + "ReaderSelector", true);
        this.readOp = this.readSelector.getReadOp();
        this.writeOp = this.readSelector.getWriteOp();
        this.readSelector.setEventFilter(this.readOp);
        this.readSelector.setIntercepterSelector(this);
        this.writeSelector = NIOSelector.open(selectorName + "WriterSelector", true);
        this.writeSelector.setEventFilter(this.writeOp);
        this.writeSelector.setIntercepterSelector(this);
    }

    public void addSelectItem(StreamHandler streamHandler) throws IOException {
        this.readSelector.addSelectItem(streamHandler);
        this.writeSelector.addSelectItem(streamHandler);
    }

    public void updateSelectItem(StreamHandler streamHandler) throws IOException {
        this.readSelector.updateSelectItem(streamHandler);
        this.writeSelector.updateSelectItem(streamHandler);
    }

    public void removeSelectItem(StreamHandler streamHandler) {
        this.readSelector.removeSelectItem(streamHandler);
        this.writeSelector.removeSelectItem(streamHandler);
    }

    public void destroySelector() {
        this.readSelector.destroySelector();
        this.writeSelector.destroySelector();
    }

    public int getReadOp() {
        return this.readOp;
    }

    public int getWriteOp() {
        return this.writeOp;
    }
}

