/*
 * Decompiled with CFR 0.152.
 */
package jeus.io.impl.blocking.protocol.message;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import jeus.io.impl.blocking.util.ByteArrayOutputStream;
import jeus.io.protocol.message.ContentWriter;
import jeus.util.ByteArray;
import jeus.util.ByteUtil;
import jeus.util.ObjectInputStreamWithLoader;

public class BlockingContentWriter
extends ContentWriter {
    private ClassLoader classloader;

    public BlockingContentWriter() {
    }

    public BlockingContentWriter(ClassLoader classloader) {
        this.classloader = classloader;
    }

    public Object[] getBufferToBeWrite(Object toBeWrite, byte[] header) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dis = new DataOutputStream(baos);
        if (header == null) {
            dis.write(OBJECT_MAGIC_BYTE);
            dis.writeInt(0);
        } else {
            dis.write(OBJECT_HEADER_MAGIC_BYTE);
            dis.writeInt(0);
            if (header.length == 0) {
                throw new RuntimeException();
            }
            dis.writeInt(header.length);
            dis.write(header);
        }
        ObjectOutputStream oos = this.makeOutputStream(baos);
        oos.writeObject(toBeWrite);
        oos.flush();
        byte[] contents = baos.toByteArray();
        ByteUtil.putInt(contents, 4, contents.length - 8);
        return new byte[][]{contents};
    }

    public ObjectOutputStream makeOutputStream(OutputStream bbis) throws IOException {
        return new ObjectOutputStream(bbis);
    }

    public ObjectInputStream makeInputStream(InputStream is) throws IOException {
        return new ObjectInputStreamWithLoader(is, this.classloader);
    }

    public Object[] getBufferToBeWrite(ByteBuffer byteBuffer, byte[] header) throws IOException {
        byteBuffer.flip();
        if (header == null) {
            byteBuffer.put(BYTE_MAGIC_BYTE);
            byteBuffer.putInt(byteBuffer.limit() - 8);
        } else {
            byteBuffer.put(BYTE_HEADER_MAGIC_BYTE);
            byteBuffer.putInt(byteBuffer.limit() - 8);
            if (header.length > 0) {
                byteBuffer.putInt(header.length);
                byteBuffer.put(header);
            }
        }
        byteBuffer.position(0);
        ByteArray content = new ByteArray(byteBuffer.array(), byteBuffer.arrayOffset(), byteBuffer.remaining());
        return new ByteArray[]{content};
    }

    public Object[] getBufferToBeWrite(byte[] bytes, int offset, int length, byte[] header) {
        if (offset != 0 || bytes.length != length) {
            byte[] temp = new byte[length];
            System.arraycopy(bytes, offset, temp, 0, length);
            bytes = temp;
        }
        if (header == null) {
            return new byte[][]{BYTE_MAGIC_BYTE, ByteUtil.convertToByte(length), bytes};
        }
        if (header.length == 0) {
            return new byte[][]{BYTE_HEADER_MAGIC_BYTE, ByteUtil.convertToByte(length), bytes};
        }
        return new byte[][]{BYTE_HEADER_MAGIC_BYTE, ByteUtil.convertToByte(length + header.length + 4), ByteUtil.convertToByte(header.length), header, bytes};
    }
}

