/*
 * Decompiled with CFR 0.152.
 */
package jeus.io.impl.nio;

import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Level;
import jeus.io.Selector;
import jeus.io.handler.BlockingStreamHandler;
import jeus.io.handler.StreamHandler;
import jeus.io.impl.nio.handler.NIOStreamHandlerImpl;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_Network;
import jeus.util.properties.JeusNetProperties;

public class NIOSelector
extends Selector
implements Runnable {
    private java.nio.channels.Selector selset;
    private volatile boolean destroyed;
    private final Map channelStreamHandlerMap = new HashMap();
    private Thread selectorThread;
    private ThreadGroup selectorThreadGroup;
    private static JeusLogger logger = (JeusLogger)JeusLogger.getLogger("jeus.io");

    public NIOSelector(String threadName, boolean isDaemon) {
        try {
            this.selset = java.nio.channels.Selector.open();
            this.runSelectorOnThread(isDaemon, threadName);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Selector open(String threadName, boolean isDaemon) {
        return new NIOSelector(threadName, isDaemon);
    }

    protected void runSelectorOnThread(boolean daemon, String threadName) {
        this.selectorThreadGroup = new ThreadGroup("SelectorThreadGroup");
        this.selectorThread = new Thread(this.selectorThreadGroup, this, threadName);
        this.selectorThread.setDaemon(daemon);
        this.selectorThread.setPriority(10);
        this.selectorThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSelectItem(StreamHandler attacher) throws IOException {
        if (attacher.isRegistered()) {
            return;
        }
        attacher.setSelector(this.interceptor);
        if (attacher instanceof BlockingStreamHandler) {
            ((BlockingStreamHandler)((Object)attacher)).runThread();
        } else {
            SocketChannel nioChannel = attacher.getSocket().getChannel();
            nioChannel.configureBlocking(false);
            Map map = this.channelStreamHandlerMap;
            synchronized (map) {
                attacher.setRegisterAction();
                this.channelStreamHandlerMap.put(nioChannel, attacher);
            }
            if (Thread.currentThread() != this.selectorThread) {
                this.selset.wakeup();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSelectItem(StreamHandler attacher) throws IOException {
        StreamHandler streamHandler = attacher;
        synchronized (streamHandler) {
            if (attacher.isCancelActionState()) {
                if (logger.isLoggable(JeusMessage_Network._1032_LEVEL)) {
                    logger.log(JeusMessage_Network._1032_LEVEL, JeusMessage_Network._1032);
                }
                return;
            }
            SocketChannel nioChannel = attacher.getSocket().getChannel();
            Map map = this.channelStreamHandlerMap;
            synchronized (map) {
                attacher.setUpdateAction();
                if (this.channelStreamHandlerMap.get(nioChannel) == null) {
                    this.channelStreamHandlerMap.put(nioChannel, attacher);
                    if (logger.isLoggable(JeusMessage_Network._212_LEVEL)) {
                        logger.log(JeusMessage_Network._212_LEVEL, JeusMessage_Network._212, (Object)this);
                    }
                }
            }
        }
        if (Thread.currentThread() != this.selectorThread) {
            this.selset.wakeup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSelectItem(StreamHandler attacher) {
        StreamHandler streamHandler = attacher;
        synchronized (streamHandler) {
            if (!attacher.isRegistered()) {
                return;
            }
            SocketChannel nioChannel = attacher.getSocket().getChannel();
            Map map = this.channelStreamHandlerMap;
            synchronized (map) {
                if (this.channelStreamHandlerMap.get(nioChannel) != null) {
                    if (attacher.isRegisterActionState()) {
                        this.channelStreamHandlerMap.remove(nioChannel);
                    }
                    if (attacher.isUpdateActionState()) {
                        attacher.setCancelAction();
                    }
                } else {
                    attacher.setCancelAction();
                    this.channelStreamHandlerMap.put(nioChannel, attacher);
                }
            }
        }
        if (Thread.currentThread() != this.selectorThread) {
            this.selset.wakeup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block24: {
            int failCount = 0;
            long wakeCount = 0L;
            while (!this.destroyed) {
                try {
                    Set<SelectionKey> selectedKeys;
                    List updatedAttachers;
                    int preSelectActionCount;
                    if ((long)failCount >= JeusNetProperties.SELECT_FAIL_LIMIT) {
                        this.replaceSelector();
                    }
                    Map map = this.channelStreamHandlerMap;
                    synchronized (map) {
                        preSelectActionCount = this.channelStreamHandlerMap.size();
                        updatedAttachers = this.preSelect();
                    }
                    if (updatedAttachers == null) break;
                    for (int i = 0; i < updatedAttachers.size(); ++i) {
                        NIOStreamHandlerImpl handler = (NIOStreamHandlerImpl)updatedAttachers.get(i);
                        this.runWaked(handler, handler.getInterestEvents());
                    }
                    try {
                        long startTime = System.currentTimeMillis();
                        int selected = this.selset.select(JeusNetProperties.SELECT_TIMEOUT);
                        long elapsedTime = System.currentTimeMillis() - startTime;
                        selectedKeys = this.selset.selectedKeys();
                        if (selected == 0 && selectedKeys.size() == 0 && elapsedTime < JeusNetProperties.SELECT_TIMEOUT - 10L) {
                            int actionCount;
                            Map map2 = this.channelStreamHandlerMap;
                            synchronized (map2) {
                                actionCount = this.channelStreamHandlerMap.size();
                            }
                            if (actionCount == 0 && preSelectActionCount == 0) {
                                if (++wakeCount == Long.MAX_VALUE) {
                                    wakeCount = JeusNetProperties.SELECT_WAKE_LIMIT;
                                }
                                if (wakeCount < JeusNetProperties.SELECT_WAKE_LIMIT) continue;
                                this.handleWakeLimit(wakeCount);
                                continue;
                            }
                            wakeCount = 0L;
                            continue;
                        }
                        wakeCount = 0L;
                    }
                    catch (IOException ioe) {
                        if (logger.isLoggable(JeusMessage_Network._215_LEVEL)) {
                            logger.log(JeusMessage_Network._215_LEVEL, JeusMessage_Network._215, this.selectorThread.getName(), (Throwable)ioe);
                        }
                        ++failCount;
                        continue;
                    }
                    catch (NullPointerException ioe) {
                        if (logger.isLoggable(JeusMessage_Network._208_LEVEL)) {
                            logger.log(JeusMessage_Network._208_LEVEL, JeusMessage_Network._208, this.selectorThread.getName(), (Throwable)ioe);
                        }
                        ++failCount;
                        continue;
                    }
                    catch (CancelledKeyException ex) {
                        if (logger.isLoggable(JeusMessage_Network._209_LEVEL)) {
                            logger.log(JeusMessage_Network._209_LEVEL, JeusMessage_Network._209, this.selectorThread.getName(), (Throwable)ex);
                        }
                        ++failCount;
                        continue;
                    }
                    failCount = 0;
                    if (this.destroyed) break;
                    this.wakedStreamHandler(selectedKeys);
                }
                catch (Throwable t) {
                    if (!logger.isLoggable(JeusMessage_Network._210_LEVEL)) continue;
                    logger.log(JeusMessage_Network._210_LEVEL, JeusMessage_Network._210, this.selectorThread.getName(), t);
                }
            }
            try {
                if (logger.isLoggable(JeusMessage_Network._214_LEVEL)) {
                    logger.log(JeusMessage_Network._214_LEVEL, JeusMessage_Network._214, (Object)this.selectorThread.getName());
                }
                this.selset.close();
            }
            catch (IOException e) {
                if (!logger.isLoggable(Level.FINEST)) break block24;
                logger.log(Level.FINEST, e.getMessage(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List preSelect() {
        ArrayList<NIOStreamHandlerImpl> list = new ArrayList<NIOStreamHandlerImpl>();
        if (this.channelStreamHandlerMap.size() > 0) {
            Set entrySet = this.channelStreamHandlerMap.entrySet();
            Iterator iterator = entrySet.iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                SelectableChannel nioChannel = (SelectableChannel)entry.getKey();
                NIOStreamHandlerImpl attacher = (NIOStreamHandlerImpl)entry.getValue();
                try {
                    SelectionKey key;
                    if (this.destroyed) {
                        if (logger.isLoggable(JeusMessage_Network._200_LEVEL)) {
                            logger.log(JeusMessage_Network._200_LEVEL, JeusMessage_Network._200, (Object)this);
                        }
                        List list2 = null;
                        return list2;
                    }
                    if (attacher.isRegisterActionState()) {
                        key = nioChannel.register(this.selset, (short)(attacher.getInterestEvents() & this.eventFilter), attacher);
                        attacher.setSelectItem(key);
                    }
                    if (attacher.isUpdateActionState()) {
                        key = attacher.getSelectItem();
                        if (key != null && key.isValid()) {
                            if (logger.isLoggable(JeusMessage_Network._201_LEVEL)) {
                                logger.log(JeusMessage_Network._201_LEVEL, JeusMessage_Network._201, new Object[]{attacher.isWritable(attacher.getInterestEvents() & this.eventFilter) ? "write" : "non write", attacher});
                            }
                            key.interestOps(attacher.getInterestEvents() & this.eventFilter);
                            list.add(attacher);
                        } else if (logger.isLoggable(JeusMessage_Network._202_LEVEL)) {
                            logger.log(JeusMessage_Network._202_LEVEL, JeusMessage_Network._202, new Object[]{attacher.isWritable(attacher.getInterestEvents() & this.eventFilter) ? "write" : "non write", attacher});
                        }
                    }
                    if (!attacher.isCancelActionState() || (key = attacher.getSelectItem()) == null) continue;
                    key.cancel();
                    attacher.keyCancelCalled();
                    attacher.setSelectItem(null);
                }
                catch (CancelledKeyException ex) {
                    if (!logger.isLoggable(JeusMessage_Network._203_LEVEL)) continue;
                    logger.log(JeusMessage_Network._203_LEVEL, JeusMessage_Network._203, this.selectorThread.getName(), (Throwable)ex);
                }
                catch (ClosedChannelException ex) {
                    if (logger.isLoggable(JeusMessage_Network._204_LEVEL)) {
                        logger.log(JeusMessage_Network._204_LEVEL, JeusMessage_Network._204, this.selectorThread.getName(), (Throwable)ex);
                    }
                    attacher.close(ex);
                }
                finally {
                    iterator.remove();
                }
            }
        } else if (logger.isLoggable(JeusMessage_Network._205_LEVEL)) {
            logger.log(JeusMessage_Network._205_LEVEL, JeusMessage_Network._205, (Object)this.selectorThread.getName());
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wakedStreamHandler(Set selectedKeys) {
        Iterator ret = selectedKeys.iterator();
        while (ret.hasNext()) {
            int readyOps;
            SelectionKey selectionKey = (SelectionKey)ret.next();
            NIOStreamHandlerImpl attacher = (NIOStreamHandlerImpl)selectionKey.attachment();
            try {
                readyOps = selectionKey.readyOps();
            }
            catch (CancelledKeyException ex) {
                if (logger.isLoggable(JeusMessage_Network._209_LEVEL)) {
                    logger.log(JeusMessage_Network._209_LEVEL, JeusMessage_Network._209, (Throwable)ex);
                }
                this.removeSelectItem(attacher);
                ret.remove();
                continue;
            }
            try {
                this.runWaked(attacher, readyOps);
            }
            finally {
                ret.remove();
            }
        }
    }

    private void handleWakeLimit(long wakeCount) throws IOException {
        if (wakeCount % JeusNetProperties.SELECT_WAKE_LIMIT == 0L && logger.isLoggable(JeusMessage_Network._213_LEVEL)) {
            logger.log(JeusMessage_Network._213_LEVEL, JeusMessage_Network._213);
        }
        try {
            Thread.sleep(JeusNetProperties.SELECT_WAKE_SLEEP);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void replaceSelector() throws IOException {
        if (logger.isLoggable(JeusMessage_Network._206_LEVEL)) {
            logger.log(JeusMessage_Network._206_LEVEL, JeusMessage_Network._206, new Object[]{Long.toString(JeusNetProperties.SELECT_FAIL_LIMIT), Thread.currentThread().getName()});
        }
        java.nio.channels.Selector newSelset = java.nio.channels.Selector.open();
        Set<SelectionKey> keys = this.selset.keys();
        SelectionKey[] selectionKeys = keys.toArray(new SelectionKey[0]);
        for (int i = 0; i < selectionKeys.length; ++i) {
            SelectionKey oldSelectionKey = selectionKeys[i];
            NIOStreamHandlerImpl attacher = (NIOStreamHandlerImpl)oldSelectionKey.attachment();
            SelectableChannel nioChannel = oldSelectionKey.channel();
            if (!oldSelectionKey.isValid()) continue;
            oldSelectionKey.cancel();
            SelectionKey newSelectionKey = nioChannel.register(newSelset, (short)(attacher.getInterestEvents() & this.eventFilter), attacher);
            attacher.setSelectItem(newSelectionKey);
        }
        java.nio.channels.Selector old = this.selset;
        this.selset = newSelset;
        try {
            old.close();
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (logger.isLoggable(JeusMessage_Network._207_LEVEL)) {
            logger.log(JeusMessage_Network._207_LEVEL, JeusMessage_Network._207, (Object)Thread.currentThread().getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runWaked(NIOStreamHandlerImpl attacher, int readyOps) {
        block11: {
            try {
                if (!attacher.isClosed()) {
                    if (!attacher.isCancelActionState()) {
                        attacher.waked(readyOps);
                    }
                    break block11;
                }
                try {
                    attacher.close(new IllegalStateException("Stream Handler selected from selector is already closed"));
                }
                finally {
                    this.removeSelectItem(attacher);
                }
            }
            catch (IOException ex) {
                if (logger.isLoggable(JeusMessage_Network._211_LEVEL)) {
                    logger.log(JeusMessage_Network._211_LEVEL, JeusMessage_Network._211, new Object[]{attacher, this.selectorThread.getName()});
                }
                try {
                    attacher.close(ex);
                }
                finally {
                    this.removeSelectItem(attacher);
                }
            }
        }
    }

    public void destroySelector() {
        SelectionKey[] selectionKeys;
        this.destroyed = true;
        while (true) {
            try {
                Set<SelectionKey> keys = this.selset.keys();
                selectionKeys = keys.toArray(new SelectionKey[0]);
            }
            catch (NoSuchElementException ex) {
                continue;
            }
            break;
        }
        StreamHandler[] attachers = new StreamHandler[selectionKeys.length];
        for (int i = 0; i < selectionKeys.length; ++i) {
            SelectionKey selectionKey = selectionKeys[i];
            attachers[i] = (StreamHandler)selectionKey.attachment();
            selectionKey.cancel();
        }
        this.selset.wakeup();
        super.destroySelector(attachers);
    }

    public int getReadOp() {
        return 1;
    }

    public int getWriteOp() {
        return 4;
    }

    public ThreadGroup getThreadGroup() {
        return this.selectorThreadGroup;
    }
}

