/*
 * Decompiled with CFR 0.152.
 */
package jeus.io.impl.nio.protocol.message;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import jeus.io.impl.StreamHandlerImpl;
import jeus.io.impl.nio.util.ChannelInputStreamBuffer;
import jeus.io.protocol.message.ContentBuffer;
import jeus.util.ObjectInputStreamWithLoader;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_Network;

public class NIOContentBuffer
extends ContentBuffer {
    private ClassLoader classloader;
    protected ChannelInputStreamBuffer inputStreamBuffer;
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger("jeus.io");

    public NIOContentBuffer(StreamHandlerImpl endpoint, ClassLoader loader) {
        this(loader, new ChannelInputStreamBuffer(endpoint));
    }

    protected NIOContentBuffer(ClassLoader loader, ChannelInputStreamBuffer buffer) {
        this.inputStreamBuffer = buffer;
        this.classloader = loader;
    }

    public byte[] readByteArrayFromBuffer(int length) {
        byte[] payload = new byte[length];
        return this.readByteArrayFromBuffer(payload, 0, length);
    }

    protected Object readObjectFromBuffer(int appLength) throws IOException, ClassNotFoundException {
        ObjectInputStream ois = this.makeObjectInputStream(this.inputStreamBuffer.getInputStream(appLength));
        return ois.readObject();
    }

    private ObjectInputStream makeObjectInputStream(InputStream is) throws IOException {
        return new ObjectInputStreamWithLoader(is, this.classloader);
    }

    public int readIntFromBuffer() {
        return this.inputStreamBuffer.readInt();
    }

    public void setReadBufferState() {
        this.inputStreamBuffer.setReadBufferState();
    }

    public int read() throws IOException {
        return this.inputStreamBuffer.read();
    }

    protected void prepareForData(int length) {
        this.inputStreamBuffer.ensureWhileReadingBuffer(length);
    }

    public int position() {
        return this.inputStreamBuffer.position();
    }

    public void close() {
        if (logger.isLoggable(JeusMessage_Network._200_LEVEL)) {
            logger.log(JeusMessage_Network._200_LEVEL, JeusMessage_Network._200, (Object)this);
        }
        this.inputStreamBuffer.close();
    }

    public byte[] readByteArrayFromBuffer(byte[] payload, int bufPosition, int appLength) {
        this.inputStreamBuffer.get(payload, bufPosition);
        return payload;
    }

    public void resetBufferInternal(int size) {
        this.inputStreamBuffer.ensureWhileReadingBuffer(size);
    }

    public void setInputStreamBuffer(ChannelInputStreamBuffer inputStreamBuffer) {
        this.inputStreamBuffer = inputStreamBuffer;
    }
}

