/*
 * Decompiled with CFR 0.152.
 */
package jeus.io.impl.nio.util;

import java.nio.ByteBuffer;
import jeus.io.impl.nio.util.ByteBufferCreator;
import jeus.io.impl.nio.util.aloc.BufferAllocationStrategy;
import jeus.io.impl.nio.util.aloc.FreeBufferAsapStrategy;
import jeus.io.impl.nio.util.aloc.MinimizeBufferCopyStrategy;
import jeus.util.properties.JeusNetProperties;

public class AdvancedByteBuffer {
    private ByteBuffer byteBuffer;
    private int origin;
    private BufferAllocationStrategy strategy;

    public AdvancedByteBuffer(int size, BufferAllocationStrategy strategy) {
        this.byteBuffer = ByteBufferCreator.allocateByteBuffer(true, size);
        this.byteBuffer.limit(this.byteBuffer.position());
        this.origin = this.byteBuffer.position();
        this.strategy = strategy;
    }

    public AdvancedByteBuffer(int size) {
        this.byteBuffer = ByteBufferCreator.allocateByteBuffer(true, size);
        this.byteBuffer.limit(this.byteBuffer.position());
        this.origin = this.byteBuffer.position();
        this.strategy = JeusNetProperties.useMinimunBufferStrategy ? new MinimizeBufferCopyStrategy(this) : new FreeBufferAsapStrategy(this);
    }

    public ByteBuffer getByteBuffer() {
        return this.byteBuffer;
    }

    public void setBuffer(ByteBuffer inBuffer) {
        this.byteBuffer = inBuffer;
    }

    public int capacity() {
        return this.byteBuffer.capacity() - this.origin;
    }

    public void setByteBuffer(ByteBuffer newInBuffer) {
        ByteBufferCreator.freeByteBuffer(this.byteBuffer);
        this.byteBuffer = newInBuffer;
        this.origin = 0;
    }

    public void flip() {
        this.byteBuffer.limit(this.byteBuffer.position());
        this.byteBuffer.position(this.origin);
    }

    public int position() {
        return this.byteBuffer.position() - this.origin;
    }

    public int getInt() {
        return this.byteBuffer.getInt();
    }

    public void close() {
        ByteBufferCreator.freeByteBuffer(this.byteBuffer);
    }

    public boolean hasRemaining() {
        return this.byteBuffer.hasRemaining();
    }

    public void clear() {
        this.byteBuffer.clear();
        this.origin = 0;
    }

    public boolean hasOccupancy(int size) {
        return size < this.byteBuffer.capacity() - this.byteBuffer.position();
    }

    public void compact() {
        this.byteBuffer.compact();
        this.origin = 0;
    }

    public void get(byte[] payload) {
        this.byteBuffer.get(payload);
    }

    public void ensureWhileReadingBuffer(int size) {
        ByteBuffer newBuffer = this.strategy.ensureBufferSize(size);
        if (newBuffer != null) {
            this.setByteBuffer(newBuffer);
        } else {
            this.setWriteDataStatus(size);
        }
    }

    void setWriteDataStatus(int size) {
        if (!this.byteBuffer.hasRemaining()) {
            this.clear();
        } else if (size < this.byteBuffer.capacity() - this.byteBuffer.position()) {
            this.setPutState();
        } else {
            this.compact();
        }
    }

    private void setPutState() {
        this.origin = this.byteBuffer.position();
        this.byteBuffer.position(this.byteBuffer.limit());
        this.byteBuffer.limit(this.byteBuffer.capacity());
    }

    public int remaining() {
        return this.byteBuffer.remaining();
    }

    public String toString() {
        return super.toString() + "[origin:" + this.origin + ",byteBuffer:" + this.byteBuffer + "]";
    }

    public void get(byte[] payload, int bufPosition) {
        this.byteBuffer.get(payload, bufPosition, payload.length - bufPosition);
    }
}

