/*
 * Decompiled with CFR 0.152.
 */
package jeus.io.impl.nio.util.aloc;

import java.nio.ByteBuffer;
import jeus.io.impl.nio.util.AdvancedByteBuffer;
import jeus.io.impl.nio.util.ByteBufferCreator;
import jeus.io.impl.nio.util.aloc.BufferAllocationStrategy;

public class MinimizeBufferCopyStrategy
implements BufferAllocationStrategy {
    private AdvancedByteBuffer buffer;

    public MinimizeBufferCopyStrategy(AdvancedByteBuffer buffer) {
        this.buffer = buffer;
    }

    public ByteBuffer ensureBufferSize(int bufferSize) {
        if (bufferSize > this.buffer.getByteBuffer().capacity()) {
            ByteBuffer newInBuffer = ByteBufferCreator.allocateByteBuffer(true, bufferSize);
            newInBuffer.put(this.buffer.getByteBuffer());
            return newInBuffer;
        }
        if (this.buffer.getByteBuffer().capacity() > ByteBufferCreator.DEFAULT_BUFFER_SIZE && !this.buffer.getByteBuffer().hasRemaining()) {
            return ByteBufferCreator.allocateByteBuffer(true, ByteBufferCreator.DEFAULT_BUFFER_SIZE);
        }
        return null;
    }
}

