/*
 * Decompiled with CFR 0.152.
 */
package jeus.net;

import java.io.IOException;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimerTask;
import java.util.Vector;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocketFactory;
import jeus.io.Selector;
import jeus.io.handler.StreamContentHandlerCreator;
import jeus.io.handler.StreamContentReceiver;
import jeus.io.helper.IOComponentCreator;
import jeus.io.impl.StreamHandlerImpl;
import jeus.io.impl.local.LocalStreamHandlerImpl;
import jeus.io.protocol.message.ContentHandlerCreator;
import jeus.net.AcceptorConnectionListener;
import jeus.net.ConnectionListener;
import jeus.net.ConnectionListenerFactory;
import jeus.net.ConnectorException;
import jeus.net.LocalBindingNoListenID;
import jeus.net.NetworkControlPacket;
import jeus.net.NoListenID;
import jeus.net.SocketID;
import jeus.net.SocketStream;
import jeus.net.SocketStreamResurrectListener;
import jeus.net.impl.Acceptor;
import jeus.net.impl.ConnectionManager;
import jeus.net.impl.Connector;
import jeus.net.impl.LocalStreamImpl;
import jeus.net.impl.LocalStreamImpl14;
import jeus.net.impl.OnePortAcceptor;
import jeus.net.impl.ServerSocketAcceptor;
import jeus.net.impl.SocketStreamWatchTask;
import jeus.util.JeusBootstrapPropertyValues;
import jeus.util.PingTimerTask;
import jeus.util.logging.JeusLogger;
import jeus.util.message.JeusMessage_Network;
import jeus.util.properties.JeusNetProperties;
import jeus.util.properties.JeusNetPropertyValues;
import jeus.util.scheduler.ScheduledExecutor;

public class Endpoint {
    protected Acceptor acceptor;
    protected Connector connector;
    protected ConnectionManager connectionManager;
    protected IOComponentCreator creator;
    protected StreamContentHandlerCreator contentHandlerCreator;
    private String name;
    protected ConnectionListenerFactory listenerFactory;
    protected SocketID mySocketID;
    private static Map activeEndpointList = new Hashtable();
    protected Object sslContext;
    private Selector selector;
    public static final List closerThreadList = new Vector();
    protected static final JeusLogger logger = (JeusLogger)JeusLogger.getLogger("jeus.net");
    private Map watchTaskMap = new Hashtable();
    private PingTimerTask pingTask;
    private boolean isExported;
    private static final ScheduledExecutor timer = ScheduledExecutor.getInstance();
    private boolean onlyByteTransfer;
    private SSLServerSocketFactory sslServerSocketFactory;
    static /* synthetic */ Class class$jeus$net$LocalBindingNoListenID;

    public Endpoint(String name, IOComponentCreator creator, ConnectionListenerFactory listenerFactory) {
        this(name, creator, new NoListenID(), new ContentHandlerCreator(), listenerFactory, null, null, false, JeusNetProperties.DEFAULT_BACKLOG);
    }

    public Endpoint(String name, IOComponentCreator creator, ConnectionListenerFactory listenerFactory, boolean onlyByteTransfer) {
        this(name, creator, new NoListenID(), new ContentHandlerCreator(), listenerFactory, null, null, onlyByteTransfer, JeusNetProperties.DEFAULT_BACKLOG);
    }

    public Endpoint(String name, IOComponentCreator creator, ConnectionListenerFactory listenerFactory, Object sslContext, boolean onlyByteTransfer) {
        this(name, creator, new NoListenID(), new ContentHandlerCreator(), listenerFactory, sslContext, null, onlyByteTransfer, JeusNetProperties.DEFAULT_BACKLOG);
    }

    public Endpoint(String name, IOComponentCreator creator, SocketID mySocketID, ConnectionListenerFactory listenerFactory) {
        this(name, creator, mySocketID, new ContentHandlerCreator(), listenerFactory, null, null, false, JeusNetProperties.DEFAULT_BACKLOG);
    }

    public Endpoint(String name, IOComponentCreator creator, SocketID mySocketID, ConnectionListenerFactory listenerFactory, boolean onlyByteTransfer) {
        this(name, creator, mySocketID, new ContentHandlerCreator(), listenerFactory, null, null, onlyByteTransfer, JeusNetProperties.DEFAULT_BACKLOG);
    }

    public Endpoint(String name, IOComponentCreator creator, SocketID mySocketID, ConnectionListenerFactory listenerFactory, Object sslContext) {
        this(name, creator, mySocketID, new ContentHandlerCreator(), listenerFactory, sslContext, null, false, JeusNetProperties.DEFAULT_BACKLOG);
    }

    public Endpoint(String name, IOComponentCreator creator, SocketID mySocketID, ConnectionListenerFactory listenerFactory, SSLSocketFactory sslContext, SSLServerSocketFactory sslServerFactory) {
        this(name, creator, mySocketID, new ContentHandlerCreator(), listenerFactory, sslContext, sslServerFactory, false, JeusNetProperties.DEFAULT_BACKLOG);
    }

    public Endpoint(String name, IOComponentCreator creator, SocketID mySocketID, ConnectionListenerFactory listenerFactory, Object sslContext, boolean onlyByteTransfer) {
        this(name, creator, mySocketID, new ContentHandlerCreator(), listenerFactory, sslContext, null, onlyByteTransfer, JeusNetProperties.DEFAULT_BACKLOG);
    }

    public Endpoint(String name, IOComponentCreator creator, SocketID mySocketID, ConnectionListenerFactory listenerFactory, SSLSocketFactory sslContext, SSLServerSocketFactory sslServerSocketFactory, boolean onlyByteTransfer) {
        this(name, creator, mySocketID, new ContentHandlerCreator(), listenerFactory, sslContext, sslServerSocketFactory, onlyByteTransfer, JeusNetProperties.DEFAULT_BACKLOG);
    }

    public Endpoint(String name, IOComponentCreator creator, SocketID mySocketID, StreamContentHandlerCreator contentHandlerCreator, ConnectionListenerFactory listenerFactory, Object sslContext) {
        this(name, creator, mySocketID, contentHandlerCreator, listenerFactory, sslContext, null, false, JeusNetProperties.DEFAULT_BACKLOG);
    }

    public Endpoint(String name, IOComponentCreator creator, SocketID mySocketID, StreamContentHandlerCreator contentHandlerCreator, ConnectionListenerFactory listenerFactory, SSLSocketFactory sslContext, SSLServerSocketFactory sslServerSocketFactory) {
        this(name, creator, mySocketID, contentHandlerCreator, listenerFactory, sslContext, sslServerSocketFactory, false, JeusNetProperties.DEFAULT_BACKLOG);
    }

    public Endpoint(String name, IOComponentCreator creator, SocketID mySocketID, StreamContentHandlerCreator contentHandlerCreator, ConnectionListenerFactory listenerFactory, Object sslContext, SSLServerSocketFactory sslServerSocketFactory, boolean onlyByteTransfer) {
        this(name, creator, mySocketID, contentHandlerCreator, listenerFactory, sslContext, sslServerSocketFactory, onlyByteTransfer, JeusNetProperties.DEFAULT_BACKLOG);
    }

    public Endpoint(String name, IOComponentCreator creator, SocketID mySocketID, StreamContentHandlerCreator contentHandlerCreator, ConnectionListenerFactory listenerFactory, Object sslContext, SSLServerSocketFactory sslServerSocketFactory, boolean onlyByteTransfer, int backlog) {
        this.name = name != null ? name : "EndpointThread-" + mySocketID.getVirtualID();
        this.onlyByteTransfer = onlyByteTransfer;
        this.creator = creator;
        this.contentHandlerCreator = contentHandlerCreator;
        this.listenerFactory = listenerFactory;
        this.sslContext = sslContext;
        this.sslServerSocketFactory = sslServerSocketFactory;
        this.selector = creator.createSelector(name + "-Selector", JeusNetProperties.NUM_SELECTOR, false);
        this.setPort(mySocketID, backlog);
        if (logger.isLoggable(JeusMessage_Network._405_LEVEL)) {
            logger.log(JeusMessage_Network._405_LEVEL, JeusMessage_Network._405, (Object)name);
        }
    }

    public void setPort(SocketID mySocketID) {
        this.setPort(mySocketID, JeusNetProperties.DEFAULT_BACKLOG);
    }

    public void setPort(SocketID mySocketID, int backlog) {
        this.mySocketID = mySocketID;
        this.createConnectionManager(mySocketID);
        if (!(mySocketID instanceof NoListenID)) {
            Object obj;
            Object object = obj = this.sslServerSocketFactory != null ? this.sslServerSocketFactory : this.sslContext;
            this.acceptor = mySocketID.getVirtualID() != null ? new OnePortAcceptor(this.selector, this.creator, this.connectionManager, this.contentHandlerCreator, this.listenerFactory, obj, this.onlyByteTransfer) : new ServerSocketAcceptor(this.selector, this.creator, this.connectionManager, this.contentHandlerCreator, this.listenerFactory, obj, this.onlyByteTransfer, backlog);
        } else {
            this.acceptor = null;
        }
        this.connector = new Connector(this.selector, this.connectionManager, this.creator, this.contentHandlerCreator, this.listenerFactory, this.sslContext, this.onlyByteTransfer);
    }

    protected void createConnectionManager(SocketID mySocketID) {
        this.connectionManager = new ConnectionManager(mySocketID);
        if (logger.isLoggable(JeusMessage_Network._406_LEVEL)) {
            logger.log(JeusMessage_Network._406_LEVEL, JeusMessage_Network._406, (Object)mySocketID);
        }
    }

    public void export() throws IOException, ConnectorException {
        if (logger.isLoggable(JeusMessage_Network._407_LEVEL)) {
            logger.log(JeusMessage_Network._407_LEVEL, JeusMessage_Network._407, (Object)this.mySocketID);
        }
        if (this.acceptor != null) {
            this.acceptor.init(this.name + "-Acceptor", this.mySocketID);
        }
        if (!(this.mySocketID instanceof NoListenID)) {
            activeEndpointList.put(Endpoint.getConnectionID(this.mySocketID), this);
        }
        this.isExported = true;
        if (JeusNetProperties.PING_PERIOD > 0L) {
            this.pingTask = new PingTimerTask(this);
            timer.scheduleWithFixedDelay(this.pingTask, JeusNetProperties.PING_PERIOD, JeusNetProperties.PING_PERIOD);
        }
    }

    public static String getConnectionID(SocketID mySocketID) throws UnknownHostException {
        String virtualID = mySocketID.getVirtualID();
        return JeusNetPropertyValues.getByName(mySocketID.getHost()).getHostAddress() + ":" + mySocketID.getBasePort() + "(" + (virtualID != null ? virtualID : "") + ")";
    }

    public void unexport() {
        if (logger.isLoggable(JeusMessage_Network._408_LEVEL)) {
            logger.log(JeusMessage_Network._408_LEVEL, JeusMessage_Network._408, (Object)this.mySocketID);
        }
        this.isExported = false;
        if (this.pingTask != null) {
            this.pingTask.cancel();
        }
        if (this.watchTaskMap != null) {
            Map t = this.watchTaskMap;
            this.watchTaskMap = null;
            Iterator i = t.values().iterator();
            while (i.hasNext()) {
                TimerTask timerTask = (TimerTask)i.next();
                timerTask.cancel();
            }
        }
        this.connector = null;
        if (activeEndpointList != null && !(this.mySocketID instanceof NoListenID)) {
            try {
                activeEndpointList.remove(Endpoint.getConnectionID(this.mySocketID));
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
            }
        }
        this.connectionManager.destroy();
        if (this.acceptor != null) {
            this.acceptor.destroy();
            this.acceptor = null;
        }
        this.selector.destroySelector();
    }

    public SocketStream getSocketStream(SocketID socketID, int _tryCount, Object piggybackedData, int connectTimeout, int readTimeout) throws ConnectorException {
        if (logger.isLoggable(JeusMessage_Network._409_LEVEL)) {
            logger.log(JeusMessage_Network._409_LEVEL, JeusMessage_Network._409, (Object)socketID);
        }
        return this.getSocketStream(socketID, _tryCount, piggybackedData, connectTimeout, readTimeout, 3000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SocketStream getSocketStream(SocketID socketID, int _tryCount, Object piggybackedData, int connectTimeout, int readTimeout, int sleepTime) throws ConnectorException {
        if (logger.isLoggable(JeusMessage_Network._409_LEVEL)) {
            logger.log(JeusMessage_Network._409_LEVEL, JeusMessage_Network._409, (Object)socketID);
        }
        String node = null;
        try {
            node = Endpoint.getConnectionID(socketID);
            Endpoint endpoint = (Endpoint)activeEndpointList.get(node);
            if (endpoint != null) {
                SocketStream connectSockStream;
                Endpoint lockSecond;
                Endpoint lockFirst;
                if (socketID.needConnect(this.mySocketID)) {
                    lockFirst = this;
                    lockSecond = endpoint;
                } else {
                    lockFirst = endpoint;
                    lockSecond = this;
                }
                Endpoint endpoint2 = lockFirst;
                synchronized (endpoint2) {
                    Endpoint endpoint3 = lockSecond;
                    synchronized (endpoint3) {
                        connectSockStream = this.connectionManager.getSocketStream(socketID);
                        if (connectSockStream == null) {
                            connectSockStream = this.connectLocalStream(socketID);
                            connectSockStream.setSocketID(socketID);
                            SocketStream acceptSockStream = endpoint.onLocalSocketStream(this.mySocketID);
                            ((LocalStreamHandlerImpl)connectSockStream.getEndpoint()).setLocalStreamHandler((LocalStreamHandlerImpl)acceptSockStream.getEndpoint());
                            ((LocalStreamHandlerImpl)acceptSockStream.getEndpoint()).setLocalStreamHandler((LocalStreamHandlerImpl)connectSockStream.getEndpoint());
                            SocketID mySocketID = this.connectionManager.getLocalListenSocketID();
                            NetworkControlPacket packet = new NetworkControlPacket(1, mySocketID.getConnectionType());
                            packet.setSocketID(mySocketID);
                            packet.setData(connectSockStream.getListener().getPiggybackData(1, connectSockStream, piggybackedData));
                            connectSockStream.write(packet);
                        }
                    }
                }
                return connectSockStream;
            }
            LocalBindingNoListenID localSocketID = (class$jeus$net$LocalBindingNoListenID == null ? (class$jeus$net$LocalBindingNoListenID = Endpoint.class$("jeus.net.LocalBindingNoListenID")) : class$jeus$net$LocalBindingNoListenID).isAssignableFrom(this.mySocketID.getClass()) ? (LocalBindingNoListenID)this.mySocketID : null;
            return this.connector.getSocketStream(socketID, localSocketID, _tryCount, piggybackedData, connectTimeout, readTimeout, sleepTime);
        }
        catch (Exception ex) {
            throw new ConnectorException("fail to connect to local endpoint " + node, ex);
        }
    }

    private SocketStream connectLocalStream(SocketID socketID) throws IOException {
        ConnectionListener listener = this.listenerFactory.createConnectionListener(null, socketID);
        SocketStream sockStream = !JeusBootstrapPropertyValues.isUpperJDK4() ? new LocalStreamImpl(this.connectionManager, listener, socketID) : new LocalStreamImpl14(this.connectionManager, listener, socketID);
        listener.connectionConnected(sockStream);
        StreamHandlerImpl streamHandler = this.creator.createStreamHandler(null, (StreamContentReceiver)sockStream, this.contentHandlerCreator, null, null);
        sockStream.setEndpoint(streamHandler);
        return sockStream;
    }

    public SocketStream onLocalSocketStream(SocketID oppositeSocketID) {
        ConnectionListener listener = this.listenerFactory.createConnectionListener(null, null);
        SocketStream sockStream = !JeusBootstrapPropertyValues.isUpperJDK4() ? new LocalStreamImpl(this.connectionManager, listener, oppositeSocketID) : new LocalStreamImpl14(this.connectionManager, listener, oppositeSocketID);
        ((AcceptorConnectionListener)listener).connectionEstablished(sockStream);
        StreamHandlerImpl endpoint = null;
        try {
            endpoint = this.creator.createStreamHandler(null, (StreamContentReceiver)sockStream, this.contentHandlerCreator, null, null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        sockStream.setEndpoint(endpoint);
        return sockStream;
    }

    public SocketStream getSocketStream(SocketID socketID) throws ConnectorException {
        return this.getSocketStream(socketID, 1, null, 0, 0);
    }

    public ConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void destroyAllActiveEndpoints() {
        Thread[] closers;
        Object endpoint1;
        Endpoint[] endpoint;
        if (logger.isLoggable(JeusMessage_Network._410_LEVEL)) {
            logger.log(JeusMessage_Network._410_LEVEL, JeusMessage_Network._410);
        }
        Map map = activeEndpointList;
        synchronized (map) {
            endpoint = activeEndpointList.values().toArray(new Endpoint[0]);
            activeEndpointList.clear();
        }
        for (int i = 0; i < endpoint.length; ++i) {
            endpoint1 = endpoint[i];
            ((Endpoint)endpoint1).unexport();
        }
        endpoint1 = closerThreadList;
        synchronized (endpoint1) {
            closers = closerThreadList.toArray(new Thread[closerThreadList.size()]);
        }
        for (int i = 0; i < closers.length; ++i) {
            Thread closer = closers[i];
            try {
                closer.join();
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (logger.isLoggable(JeusMessage_Network._411_LEVEL)) {
            logger.log(JeusMessage_Network._411_LEVEL, JeusMessage_Network._411);
        }
    }

    public SocketStream[] getSocketStreams() {
        return this.connectionManager.getSocketStreams();
    }

    public boolean broadcast(int connectionType, SocketStream sockStream, Object message) {
        boolean flag = false;
        SocketStream[] servers = this.getConnectionManager().getSocketStreams(connectionType);
        for (int i = 0; i < servers.length; ++i) {
            SocketStream server = servers[i];
            if (sockStream != null && sockStream.getSocketID().equals(server.getSocketID())) continue;
            try {
                server.write(message);
                flag = true;
                continue;
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return flag;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connector.setConnectTimeout(connectTimeout);
    }

    public void registerWatchSocketStream(SocketID socketID, SocketStreamResurrectListener listener) {
        this.registerWatchSocketStream(socketID, listener, JeusNetProperties.DEFAULT_WATCH_PERIOD, null, 0, 0);
    }

    public synchronized void registerWatchSocketStream(SocketID socketID, SocketStreamResurrectListener listener, long period, Object piggybackedData, int connectTimeout, int readTimeout) {
        if (this.watchTaskMap != null) {
            if (!this.watchTaskMap.containsKey(socketID)) {
                SocketStreamWatchTask task = new SocketStreamWatchTask(socketID, listener, this, piggybackedData, connectTimeout, readTimeout);
                ScheduledExecutor.getInstance().scheduleWithFixedDelay(task, period, period);
                this.watchTaskMap.put(socketID, task);
            }
        } else {
            throw new IllegalStateException("This endpoin is unexported");
        }
    }

    public synchronized void cancelWatchSocketStream(SocketID socketID) {
        SocketStreamWatchTask task;
        if (this.watchTaskMap != null && (task = (SocketStreamWatchTask)this.watchTaskMap.remove(socketID)) != null) {
            task.cancelTimer();
        }
    }

    public int getServerSocketPort() {
        return this.acceptor.getServerSocketPort();
    }

    public SocketID getMySocketID() {
        return this.mySocketID;
    }

    public boolean isExported() {
        return this.isExported;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

