/*
 * Decompiled with CFR 0.152.
 */
package jeus.net;

import java.io.IOException;
import jeus.net.SocketStream;
import jeus.util.properties.JeusNetPropertyValues;

public class LocalStreamDelegate {
    private SocketStream sockStream;

    public LocalStreamDelegate(SocketStream sockStream) {
        this.sockStream = sockStream;
    }

    public String getHostName() {
        return JeusNetPropertyValues.LOCAL_HOSTNAME;
    }

    public String getLocalIP() {
        return JeusNetPropertyValues.LOCAL_HOSTADDRESS;
    }

    public int getLocalPort() {
        return 0;
    }

    public String getLocalHostName() {
        return JeusNetPropertyValues.LOCAL_HOSTNAME;
    }

    public String getIP() {
        return JeusNetPropertyValues.LOCAL_HOSTADDRESS;
    }

    public int getPort() {
        return 0;
    }

    protected void setSocketLog() {
    }

    public void finishCloseState(Exception ex) {
        try {
            int closeState = this.sockStream.getCloseState();
            switch (closeState) {
                case 1: 
                case 4: 
                case 5: {
                    this.sockStream.sendShutdownPacket(ex);
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                default: {
                    throw new RuntimeException("not allowed : " + closeState);
                }
            }
            this.sockStream.close(ex);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void callDelegateTask(SocketStream.MessageProcessor processor, boolean replyPacket, Object obj) {
        processor.run();
    }
}

