/*
 * Decompiled with CFR 0.152.
 */
package jeus.net;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import jeus.io.handler.StreamHandler;
import jeus.net.NoListenID;
import jeus.net.SocketID;
import jeus.net.impl.NodeInfo;

public class NetworkControlPacket
implements Serializable {
    static final long serialVersionUID = 7321901157457600697L;
    public static final int OP_CONNECT = 1;
    public static final int OP_ACCEPTED = 2;
    public static final int OP_CLOSE = 4;
    public static final int OP_CLOSE_CROSS_CONNECTION = 8;
    public static final int OP_PING = 5;
    public static final int OP_PING_ACK = 6;
    private int code;
    private Object data;
    private SocketID socketID;
    public static final NetworkControlPacket CLOSE_PACKET = new NetworkControlPacket(4);
    public static final NetworkControlPacket CLOSE_CROSS_CONNECTION_PACKET = new NetworkControlPacket(8);
    private int connectionType;

    public NetworkControlPacket(int opCode) {
        this(opCode, -1, null);
    }

    public NetworkControlPacket(int opCode, int connectionType) {
        this(opCode, connectionType, null);
    }

    public NetworkControlPacket(int opCode, int connectionType, Object piggybackedData) {
        this.code = opCode;
        this.connectionType = connectionType;
        this.data = piggybackedData;
    }

    public int getCode() {
        return this.code;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public Object getData() {
        return this.data;
    }

    public void setSocketID(SocketID socketID) {
        this.socketID = socketID;
    }

    public SocketID getSocketID() {
        return this.socketID;
    }

    public int getConnectionType() {
        return this.connectionType;
    }

    public String toString() {
        switch (this.code) {
            case 1: {
                return "OP_CONNECT";
            }
            case 2: {
                return "OP_ACCEPTED";
            }
            case 4: {
                return "OP_CLOSE";
            }
            case 8: {
                return "OP_CLOSE_CROSS_CONNECTION";
            }
            case 5: {
                return "OP_PING";
            }
            case 6: {
                return "OP_PING_ACK";
            }
        }
        return "UNDEFINED NetworkControlPacket";
    }

    public static byte[] convertByte(NetworkControlPacket networkControlPacket, StreamHandler handler) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        try {
            dos.writeInt(networkControlPacket.code);
            dos.writeInt(networkControlPacket.connectionType);
            SocketID socketID1 = networkControlPacket.socketID;
            if (socketID1 instanceof NodeInfo) {
                dos.writeBoolean(true);
                dos.writeUTF(socketID1.getHost());
                dos.writeInt(socketID1.getBasePort());
                String virtualID = socketID1.getVirtualID();
                if (virtualID == null) {
                    dos.writeBoolean(false);
                } else {
                    dos.writeBoolean(true);
                    dos.writeUTF(virtualID);
                }
                dos.writeInt(socketID1.getConnectionType());
            } else if (socketID1 instanceof NoListenID || socketID1 == null) {
                dos.writeBoolean(false);
            } else {
                throw new RuntimeException("The SocketID should be NodeInfo or NoListenID for byte transfer : " + socketID1);
            }
            Object piggybackData = networkControlPacket.getData();
            if (piggybackData != null) {
                if (!handler.canWritePiggybackDataAsByte(piggybackData)) {
                    throw new RuntimeException("Unable to convert piggyback data " + piggybackData.getClass().getName() + " to byte array.");
                }
                dos.writeBoolean(true);
                byte[] buffer = handler.getPiggybackDataBuffer(piggybackData);
                dos.writeInt(buffer.length);
                dos.write(buffer);
            } else {
                dos.writeBoolean(false);
            }
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static NetworkControlPacket convertByte(byte[] data, StreamHandler handler) {
        ByteArrayInputStream baos = new ByteArrayInputStream(data);
        DataInputStream dos = new DataInputStream(baos);
        try {
            SocketID nodeInfo;
            int code = dos.readInt();
            int connectionType = dos.readInt();
            boolean isNodeInfo = dos.readBoolean();
            if (isNodeInfo) {
                String host = dos.readUTF();
                int baseport = dos.readInt();
                boolean useVirtualID = dos.readBoolean();
                String virtualID = useVirtualID ? dos.readUTF() : null;
                int socketIDConnectionType = dos.readInt();
                nodeInfo = new NodeInfo(host, baseport, virtualID, socketIDConnectionType);
            } else {
                nodeInfo = new NoListenID();
            }
            Object piggybackData = null;
            boolean hasPiggybackData = dos.readBoolean();
            if (hasPiggybackData) {
                int length = dos.readInt();
                byte[] buffer = new byte[length];
                dos.readFully(buffer);
                piggybackData = handler.getPiggybackData(buffer);
            }
            NetworkControlPacket packet = new NetworkControlPacket(code, connectionType);
            packet.setSocketID(nodeInfo);
            if (piggybackData != null) {
                packet.setData(piggybackData);
            }
            return packet;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

