/*
 * Decompiled with CFR 0.152.
 */
package jeus.server;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.HashMap;
import jeus.deploy.archivist.FileArchive;
import jeus.util.EnvironmentCall;
import jeus.util.JeusRuntimeException;
import jeus.util.StringUtil;
import jeus.util.UnicodeInputStream;
import jeus.util.concurrent.FIFOReadWriteLock;
import jeus.util.concurrent.ReadWriteLock;

public class ConfigFile
implements Serializable {
    private String content;
    private String path;
    private long lastModified;
    private static final HashMap configFileLockMap = new HashMap();
    private boolean modified;
    private String encoding = "ISO-8859-1";
    private static FileArchive configArchive = EnvironmentCall.getConfigArchive();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ReadWriteLock getConfigLock(String configPath) {
        ReadWriteLock lock = (ReadWriteLock)configFileLockMap.get(configPath);
        if (lock == null) {
            HashMap hashMap = configFileLockMap;
            synchronized (hashMap) {
                lock = (ReadWriteLock)configFileLockMap.get(configPath);
                if (lock == null) {
                    lock = new FIFOReadWriteLock();
                    configFileLockMap.put(configPath, lock);
                }
            }
        }
        return lock;
    }

    public ConfigFile() {
    }

    public ConfigFile(String content, String path, long lastModified) {
        this.content = content;
        this.path = path;
        this.lastModified = lastModified;
    }

    public String getContent() {
        return this.content;
    }

    public long lastModified() {
        return this.lastModified;
    }

    public String getPath() {
        return this.path;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    public void setPath(String path) {
        this.path = path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean readConfigFile() throws IOException {
        ReadWriteLock lock = ConfigFile.getConfigLock(this.path);
        try {
            lock.readLock().acquire();
        }
        catch (InterruptedException e) {
            throw new JeusRuntimeException(e);
        }
        try {
            String fileName = this.path.substring("config://".length());
            File configFile = this.getFileInstance(fileName);
            long modifiedTime = configFile.lastModified();
            if (this.lastModified != modifiedTime) {
                this.modified = true;
                this.lastModified = modifiedTime;
                this.readContent(configFile);
                boolean bl = true;
                return bl;
            }
            this.modified = false;
            boolean bl = false;
            return bl;
        }
        finally {
            lock.readLock().release();
        }
    }

    private File getFileInstance(String fileName) throws FileNotFoundException {
        File configFile = new File(fileName);
        if (configFile.isAbsolute()) {
            configFile = new File(fileName);
            if (!configFile.exists()) {
                throw new FileNotFoundException(fileName);
            }
        } else {
            if (configArchive != null) {
                configFile = configArchive.getFile(fileName);
            } else if (!configFile.exists()) {
                throw new FileNotFoundException(fileName);
            }
            if (configFile == null) {
                throw new FileNotFoundException(configArchive.getArchiveUri() + File.separator + fileName);
            }
        }
        return configFile;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readContent(File configFile) throws IOException {
        InputStreamReader is;
        char[] readCharArray = new char[4096];
        StringBuffer buffer = new StringBuffer();
        BufferedReader br = new BufferedReader(new FileReader(configFile));
        String pi = br.readLine();
        byte[] bomByteArray = new byte[pi.length()];
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(configFile);
            fis.read(bomByteArray);
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
        Object[] encodingDesc = StringUtil.getEncodingAndXmlDecl(bomByteArray);
        String encoding = (String)encodingDesc[0];
        UnicodeInputStream uis = new UnicodeInputStream(new FileInputStream(configFile), encoding);
        encoding = uis.getEncoding();
        if (encoding != null) {
            this.setEncoding(encoding);
            is = new InputStreamReader((InputStream)uis, encoding);
        } else {
            this.setEncoding(System.getProperty("file.encoding"));
            is = new InputStreamReader(uis);
        }
        try {
            int length = is.read(readCharArray);
            while (length >= 0) {
                buffer.append(readCharArray, 0, length);
                length = is.read(readCharArray);
            }
        }
        finally {
            is.close();
        }
        this.content = buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeConfigFile() throws IOException {
        ReadWriteLock lock = ConfigFile.getConfigLock(this.path);
        try {
            lock.writeLock().acquire();
        }
        catch (InterruptedException e) {
            throw new JeusRuntimeException(e);
        }
        try {
            this.modified = false;
            String fileName = this.path.substring("config://".length());
            File configFile = null;
            try {
                configFile = this.getFileInstance(fileName);
            }
            catch (FileNotFoundException fe) {
                // empty catch block
            }
            OutputStream os = configFile == null ? configArchive.addEntry(fileName) : new FileOutputStream(configFile);
            try {
                byte[] bytes = this.encoding != null ? this.content.getBytes(this.encoding) : this.content.getBytes();
                os.write(bytes);
            }
            finally {
                os.close();
            }
            configFile = this.getFileInstance(fileName);
            this.lastModified = configFile.lastModified();
        }
        finally {
            lock.writeLock().release();
        }
    }

    public void setModified(boolean b) {
        this.modified = b;
    }

    public boolean isModified() {
        return this.modified;
    }

    public String getEncoding() {
        return this.encoding;
    }
}

