/*
 * Decompiled with CFR 0.152.
 */
package jeus.util;

import jeus.util.concurrent50.concurrent.ThreadFactory;
import jeus.util.concurrent50.concurrent.atomic.AtomicInteger;

public class DaemonThreadFactory
implements ThreadFactory {
    protected String threadNamePrefix;
    private AtomicInteger sequence = new AtomicInteger(0);
    private boolean isDaemon;

    public DaemonThreadFactory(String threadNamePrefix) {
        this.threadNamePrefix = threadNamePrefix + "-";
    }

    public DaemonThreadFactory(String creatorName, boolean useDaemonForBlocking) {
        this(creatorName);
        this.setDaemon(useDaemonForBlocking);
    }

    public Thread newThread(Runnable command) {
        int value = this.sequence.getAndIncrement();
        Thread t = this.makeThread(command, value);
        t.setDaemon(this.isDaemon);
        return t;
    }

    protected Thread makeThread(Runnable command, int value) {
        return new Thread(command, this.threadNamePrefix + value);
    }

    public void setDaemon(boolean daemon) {
        this.isDaemon = daemon;
    }
}

