/*
 * Decompiled with CFR 0.152.
 */
package jeus.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import jeus.util.JeusRuntimeException;
import jeus.util.ObjectInputStreamWithLoader;
import jeus.util.SerializerTable;

public class Serializer {
    ByteArrayOutputStream serOut = new ByteArrayOutputStream(4096);
    public static final SerializerTable serializers = new SerializerTable();

    public static byte[] serializeStatic(Object obj) throws Exception {
        return ((Serializer)serializers.get()).serialize(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] serialize(Object obj) throws RuntimeException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = this.serOut;
            synchronized (byteArrayOutputStream) {
                ObjectOutputStream serIn = new ObjectOutputStream(this.serOut);
                serIn.writeObject(obj);
                byte[] bytes = this.serOut.toByteArray();
                this.serOut.reset();
                return bytes;
            }
        }
        catch (Throwable ex) {
            throw new RuntimeException("problem in serialize()", ex);
        }
    }

    public static Object deserializeStatic(byte[] b) throws RuntimeException {
        return ((Serializer)serializers.get()).deserialize(b);
    }

    public Object deserialize(byte[] b) throws RuntimeException {
        try {
            ByteArrayInputStream deserIn = new ByteArrayInputStream(b);
            ObjectInputStreamWithLoader deserOut = new ObjectInputStreamWithLoader(deserIn, Thread.currentThread().getContextClassLoader());
            return deserOut.readObject();
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            throw new RuntimeException("problem in deserialize()", ex);
        }
    }

    public static Object deserializeStatic(byte[] b, ClassLoader loader) throws Exception {
        return ((Serializer)serializers.get()).deserialize(b, loader);
    }

    public Object deserialize(byte[] b, ClassLoader loader) throws Exception {
        try {
            ByteArrayInputStream deserIn = new ByteArrayInputStream(b);
            ObjectInputStreamWithLoader deserOut = new ObjectInputStreamWithLoader(deserIn, loader);
            return deserOut.readObject();
        }
        catch (Throwable ex) {
            throw new Exception("problem in deserialize()", ex);
        }
    }

    public static Object cloneObjectStatic(Object s) {
        try {
            return ((Serializer)serializers.get()).cloneObject(s);
        }
        catch (Throwable t) {
            throw new JeusRuntimeException(t);
        }
    }

    public static Object cloneObjectStatic(Object s, ClassLoader loader) {
        try {
            return ((Serializer)serializers.get()).cloneObject(s, loader);
        }
        catch (Throwable t) {
            throw new JeusRuntimeException(t);
        }
    }

    public Object cloneObject(Object s) throws Exception {
        byte[] b = this.serialize(s);
        return this.deserialize(b);
    }

    public Object cloneObject(Object s, ClassLoader loader) throws Exception {
        byte[] b = this.serialize(s);
        return this.deserialize(b, loader);
    }
}

