/*
 * Decompiled with CFR 0.152.
 */
package jeus.util;

import java.util.Date;
import java.util.TimeZone;
import jeus.util.CalendarDate;

public class SimpleLogDateFormat {
    static int tz = TimeZone.getDefault().getRawOffset() + SimpleLogDateFormat.getDSTSavings(TimeZone.getDefault());
    String form = "yyy.MM.dd HH:mm:ss";

    public static int getDSTSavings(TimeZone timeZone) {
        if (timeZone.useDaylightTime()) {
            return 3600000;
        }
        return 0;
    }

    public SimpleLogDateFormat() {
    }

    public SimpleLogDateFormat(String form) {
        this.form = form;
    }

    public String format(Date d) {
        long t = d.getTime() + (long)tz;
        CalendarDate cd = SimpleLogDateFormat.getCalendarDate(t);
        return cd.getLogTime(this.form);
    }

    public static CalendarDate getCalendarDate(long l) {
        long l1 = l / 86400000L;
        int i = (int)(l % 86400000L);
        if (i < 0) {
            i += 86400000;
            --l1;
        }
        CalendarDate calendardate = SimpleLogDateFormat.getCalendarDateFromFixedDate(l1 += 719163L);
        calendardate.setTimeOfDay(i);
        return calendardate;
    }

    public static final long getFixedDate(int i, int j, int k) {
        int l = i - 1;
        long l1 = l >= 0 ? 365L * (long)l + (long)(l / 4) - (long)(l / 100) + (long)(l / 400) + (long)((367 * j - 362) / 12) + (long)k : 365L * (long)l + (long)SimpleLogDateFormat.floorDivide(l, 4) - (long)SimpleLogDateFormat.floorDivide(l, 100) + (long)SimpleLogDateFormat.floorDivide(l, 400) + (long)SimpleLogDateFormat.floorDivide(367 * ++j - 362, 12) + (long)k;
        if (j > 2) {
            l1 -= SimpleLogDateFormat.isLeapYear(i) ? 1L : 2L;
        }
        return l1;
    }

    public static CalendarDate getCalendarDateFromFixedDate(long l) {
        int i = SimpleLogDateFormat.getYear(l);
        int j = (int)(l - SimpleLogDateFormat.getFixedDate(i, 0, 1));
        int byte0 = 2;
        long l1 = SimpleLogDateFormat.getFixedDate(i, 2, 1);
        if (l < l1) {
            byte0 = 0;
        } else if (l >= l1 && SimpleLogDateFormat.isLeapYear(i)) {
            byte0 = 1;
        }
        int k = SimpleLogDateFormat.floorDivide(12 * (j + byte0) + 373, 367) - 1;
        int i1 = (int)(l - SimpleLogDateFormat.getFixedDate(i, k, 1) + 1L);
        CalendarDate calendardate = new CalendarDate(i, k + 1, i1);
        return calendardate;
    }

    private static final int getYear(long l) {
        int k3;
        int j3;
        int i3;
        int k2;
        if (l >= 0L) {
            long l1 = l - 1L;
            k2 = (int)(l1 / 146097L);
            int i = (int)(l1 % 146097L);
            i3 = i / 36524;
            int k = i % 36524;
            j3 = k / 1461;
            int j1 = k % 1461;
            k3 = j1 / 365;
            int i2 = j1 % 365 + 1;
        } else {
            long l2 = l - 1L;
            k2 = (int)SimpleLogDateFormat.floorDivide(l2, 146097L);
            int j = (int)SimpleLogDateFormat.mod(l2, 146097L);
            i3 = SimpleLogDateFormat.floorDivide(j, 36524);
            int i1 = SimpleLogDateFormat.mod(j, 36524);
            j3 = SimpleLogDateFormat.floorDivide(i1, 1461);
            int k1 = SimpleLogDateFormat.mod(i1, 1461);
            k3 = SimpleLogDateFormat.floorDivide(k1, 365);
            int j2 = SimpleLogDateFormat.mod(k1, 365) + 1;
        }
        int l3 = 400 * k2 + 100 * i3 + 4 * j3 + k3;
        if (i3 != 4 && k3 != 4) {
            ++l3;
        }
        return l3;
    }

    public static final boolean isLeapYear(int i) {
        if (i >= 0) {
            return i % 4 == 0 && (i % 100 != 0 || i % 400 == 0);
        }
        return SimpleLogDateFormat.mod(i, 4) == 0 && (SimpleLogDateFormat.mod(i, 100) != 0 || SimpleLogDateFormat.mod(i, 400) == 0);
    }

    private static final long floorDivide(long l, long l1) {
        return l < 0L ? (l + 1L) / l1 - 1L : l / l1;
    }

    private static final int floorDivide(int i, int j) {
        return i < 0 ? (i + 1) / j - 1 : i / j;
    }

    private static final long mod(long l, long l1) {
        return l - l1 * SimpleLogDateFormat.floorDivide(l, l1);
    }

    private static final int mod(int i, int j) {
        return i - j * SimpleLogDateFormat.floorDivide(i, j);
    }
}

