/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.concurrent;

import java.util.Date;
import jeus.util.concurrent.DefaultChannelCapacity;
import jeus.util.concurrent.Heap;
import jeus.util.concurrent.ThreadFactoryUser;

public class ClockDaemon
extends ThreadFactoryUser {
    protected final Heap heap_ = new Heap(DefaultChannelCapacity.get());
    protected Thread thread_;
    protected final RunLoop runLoop_ = new RunLoop();

    public Object executeAt(Date date, Runnable command) {
        TaskNode task = new TaskNode(date.getTime(), command);
        this.heap_.insert(task);
        this.restart();
        return task;
    }

    public Object executeAfterDelay(long millisecondsToDelay, Runnable command) {
        long runtime = System.currentTimeMillis() + millisecondsToDelay;
        TaskNode task = new TaskNode(runtime, command);
        this.heap_.insert(task);
        this.restart();
        return task;
    }

    public Object executePeriodically(long period, Runnable command, boolean startNow) {
        if (period <= 0L) {
            throw new IllegalArgumentException();
        }
        long firstTime = System.currentTimeMillis();
        if (!startNow) {
            firstTime += period;
        }
        TaskNode task = new TaskNode(firstTime, command, period);
        this.heap_.insert(task);
        this.restart();
        return task;
    }

    public static void cancel(Object taskID) {
        ((TaskNode)taskID).setCancelled();
    }

    public synchronized Thread getThread() {
        return this.thread_;
    }

    protected synchronized void clearThread() {
        this.thread_ = null;
    }

    public synchronized void restart() {
        if (this.thread_ == null) {
            this.thread_ = this.threadFactory_.newThread(this.runLoop_);
            this.thread_.start();
        } else {
            this.notify();
        }
    }

    public synchronized void shutDown() {
        this.heap_.clear();
        if (this.thread_ != null) {
            this.thread_.interrupt();
        }
        this.thread_ = null;
    }

    protected synchronized TaskNode nextTask() {
        try {
            while (!Thread.interrupted()) {
                TaskNode task = (TaskNode)this.heap_.peek();
                if (task == null) {
                    this.wait();
                    continue;
                }
                long now = System.currentTimeMillis();
                long when = task.getTimeToRun();
                if (when > now) {
                    this.wait(when - now);
                    continue;
                }
                task = (TaskNode)this.heap_.extract();
                if (task.getCancelled()) continue;
                if (task.period > 0L) {
                    task.setTimeToRun(now + task.period);
                    this.heap_.insert(task);
                }
                return task;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return null;
    }

    protected class RunLoop
    implements Runnable {
        protected RunLoop() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                TaskNode task;
                while ((task = ClockDaemon.this.nextTask()) != null) {
                    task.command.run();
                }
            }
            finally {
                ClockDaemon.this.clearThread();
            }
        }
    }

    protected static class TaskNode
    implements Comparable {
        final Runnable command;
        final long period;
        private long timeToRun_;
        private boolean cancelled_ = false;

        synchronized void setCancelled() {
            this.cancelled_ = true;
        }

        synchronized boolean getCancelled() {
            return this.cancelled_;
        }

        synchronized void setTimeToRun(long w) {
            this.timeToRun_ = w;
        }

        synchronized long getTimeToRun() {
            return this.timeToRun_;
        }

        public int compareTo(Object other) {
            long b;
            long a = this.getTimeToRun();
            return a < (b = ((TaskNode)other).getTimeToRun()) ? -1 : (a == b ? 0 : 1);
        }

        TaskNode(long w, Runnable c, long p) {
            this.timeToRun_ = w;
            this.command = c;
            this.period = p;
        }

        TaskNode(long w, Runnable c) {
            this(w, c, -1L);
        }
    }
}

