/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.concurrent;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;

public class CopyOnWriteHashtable
implements Map,
Serializable {
    private Hashtable hashtable;
    private boolean isShared;

    public CopyOnWriteHashtable(Hashtable _hashtable) {
        this.hashtable = _hashtable;
    }

    public CopyOnWriteHashtable(int initialCapacity, float loadFactor) {
        this.hashtable = new Hashtable(initialCapacity, loadFactor);
    }

    public CopyOnWriteHashtable(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public CopyOnWriteHashtable() {
        this(11, 0.75f);
    }

    public CopyOnWriteHashtable(Map t) {
        this(Math.max(2 * t.size(), 11), 0.75f);
        this.putAll(t);
    }

    private synchronized Hashtable getHashtable() {
        return this.hashtable;
    }

    public int size() {
        Hashtable _hashtable = this.getHashtable();
        return _hashtable.size();
    }

    public boolean isEmpty() {
        Hashtable _hashtable = this.getHashtable();
        return _hashtable.isEmpty();
    }

    public Enumeration keys() {
        this.isShared = true;
        Hashtable _hashtable = this.getHashtable();
        return _hashtable.keys();
    }

    public Enumeration elements() {
        this.isShared = true;
        Hashtable _hashtable = this.getHashtable();
        return _hashtable.elements();
    }

    public boolean contains(Object value) {
        Hashtable _hashtable = this.getHashtable();
        return _hashtable.contains(value);
    }

    public boolean containsValue(Object value) {
        return this.contains(value);
    }

    public boolean containsKey(Object key) {
        Hashtable _hashtable = this.getHashtable();
        return _hashtable.containsKey(key);
    }

    public Object get(Object key) {
        Hashtable _hashtable = this.getHashtable();
        return _hashtable.get(key);
    }

    public synchronized Object put(Object key, Object value) {
        if (this.isShared) {
            this.hashtable = (Hashtable)this.hashtable.clone();
            this.isShared = false;
        }
        return this.hashtable.put(key, value);
    }

    public synchronized Object remove(Object key) {
        if (this.isShared) {
            this.hashtable = (Hashtable)this.hashtable.clone();
            this.isShared = false;
        }
        return this.hashtable.remove(key);
    }

    public synchronized void putAll(Map t) {
        if (this.isShared) {
            this.hashtable = (Hashtable)this.hashtable.clone();
            this.isShared = false;
        }
        this.hashtable.putAll(t);
    }

    public Object clone() {
        this.isShared = true;
        CopyOnWriteHashtable cloneObject = new CopyOnWriteHashtable(this.hashtable);
        cloneObject.isShared = true;
        return cloneObject;
    }

    public synchronized String toString() {
        Hashtable _hashtable = this.getHashtable();
        return _hashtable.toString();
    }

    public void clear() {
        this.hashtable.clear();
    }

    public Set keySet() {
        Hashtable _hashtable = this.getHashtable();
        return _hashtable.keySet();
    }

    public Set entrySet() {
        Hashtable _hashtable = this.getHashtable();
        return _hashtable.entrySet();
    }

    public Collection values() {
        Hashtable _hashtable = this.getHashtable();
        return _hashtable.values();
    }

    public boolean equals(Object o) {
        Hashtable _hashtable = this.getHashtable();
        return _hashtable.equals(o);
    }

    public int hashCode() {
        Hashtable _hashtable = this.getHashtable();
        return _hashtable.hashCode();
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        Hashtable _hashtable = this.getHashtable();
        s.writeObject(_hashtable);
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        this.hashtable = (Hashtable)s.readObject();
    }
}

