/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.concurrent;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import jeus.util.concurrent.ReadWriteLock;
import jeus.util.concurrent.Sync;
import jeus.util.concurrent.SyncCollection;

public class SyncList
extends SyncCollection
implements List {
    public SyncList(List list, Sync sync) {
        super((Collection)list, sync);
    }

    public SyncList(List list, ReadWriteLock rwl) {
        super(list, rwl.readLock(), rwl.writeLock());
    }

    public SyncList(List list, Sync readLock, Sync writeLock) {
        super(list, readLock, writeLock);
    }

    protected List baseList() {
        return (List)this.c_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        boolean wasInterrupted = this.beforeRead();
        try {
            int n = ((Object)this.c_).hashCode();
            return n;
        }
        finally {
            this.afterRead(wasInterrupted);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object o) {
        boolean wasInterrupted = this.beforeRead();
        try {
            boolean bl = ((Object)this.c_).equals(o);
            return bl;
        }
        finally {
            this.afterRead(wasInterrupted);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(int index) {
        boolean wasInterrupted = this.beforeRead();
        try {
            Object e = this.baseList().get(index);
            return e;
        }
        finally {
            this.afterRead(wasInterrupted);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int indexOf(Object o) {
        boolean wasInterrupted = this.beforeRead();
        try {
            int n = this.baseList().indexOf(o);
            return n;
        }
        finally {
            this.afterRead(wasInterrupted);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int lastIndexOf(Object o) {
        boolean wasInterrupted = this.beforeRead();
        try {
            int n = this.baseList().lastIndexOf(o);
            return n;
        }
        finally {
            this.afterRead(wasInterrupted);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List subList(int fromIndex, int toIndex) {
        boolean wasInterrupted = this.beforeRead();
        try {
            SyncList syncList = new SyncList(this.baseList().subList(fromIndex, toIndex), this.rd_, this.wr_);
            return syncList;
        }
        finally {
            this.afterRead(wasInterrupted);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object set(int index, Object o) {
        this.wr_.acquire();
        try {
            Object object = this.baseList().set(index, o);
            this.wr_.release();
            return object;
        }
        catch (Throwable throwable) {
            try {
                this.wr_.release();
                throw throwable;
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                throw new UnsupportedOperationException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(int index) {
        this.wr_.acquire();
        try {
            Object e = this.baseList().remove(index);
            this.wr_.release();
            return e;
        }
        catch (Throwable throwable) {
            try {
                this.wr_.release();
                throw throwable;
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                throw new UnsupportedOperationException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(int index, Object o) {
        try {
            this.wr_.acquire();
            try {
                this.baseList().add(index, o);
            }
            finally {
                this.wr_.release();
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new UnsupportedOperationException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAll(int index, Collection coll) {
        this.wr_.acquire();
        try {
            boolean bl = this.baseList().addAll(index, coll);
            this.wr_.release();
            return bl;
        }
        catch (Throwable throwable) {
            try {
                this.wr_.release();
                throw throwable;
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                throw new UnsupportedOperationException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListIterator unprotectedListIterator() {
        boolean wasInterrupted = this.beforeRead();
        try {
            ListIterator listIterator = this.baseList().listIterator();
            return listIterator;
        }
        finally {
            this.afterRead(wasInterrupted);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListIterator listIterator() {
        boolean wasInterrupted = this.beforeRead();
        try {
            SyncCollectionListIterator syncCollectionListIterator = new SyncCollectionListIterator(this.baseList().listIterator());
            return syncCollectionListIterator;
        }
        finally {
            this.afterRead(wasInterrupted);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListIterator unprotectedListIterator(int index) {
        boolean wasInterrupted = this.beforeRead();
        try {
            ListIterator listIterator = this.baseList().listIterator(index);
            return listIterator;
        }
        finally {
            this.afterRead(wasInterrupted);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListIterator listIterator(int index) {
        boolean wasInterrupted = this.beforeRead();
        try {
            SyncCollectionListIterator syncCollectionListIterator = new SyncCollectionListIterator(this.baseList().listIterator(index));
            return syncCollectionListIterator;
        }
        finally {
            this.afterRead(wasInterrupted);
        }
    }

    public class SyncCollectionListIterator
    extends SyncCollection.SyncCollectionIterator
    implements ListIterator {
        SyncCollectionListIterator(Iterator baseIterator) {
            super(baseIterator);
        }

        protected ListIterator baseListIterator() {
            return (ListIterator)this.baseIterator_;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean hasPrevious() {
            boolean wasInterrupted = SyncList.this.beforeRead();
            try {
                boolean bl = this.baseListIterator().hasPrevious();
                return bl;
            }
            finally {
                SyncList.this.afterRead(wasInterrupted);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object previous() {
            boolean wasInterrupted = SyncList.this.beforeRead();
            try {
                Object e = this.baseListIterator().previous();
                return e;
            }
            finally {
                SyncList.this.afterRead(wasInterrupted);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int nextIndex() {
            boolean wasInterrupted = SyncList.this.beforeRead();
            try {
                int n = this.baseListIterator().nextIndex();
                return n;
            }
            finally {
                SyncList.this.afterRead(wasInterrupted);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int previousIndex() {
            boolean wasInterrupted = SyncList.this.beforeRead();
            try {
                int n = this.baseListIterator().previousIndex();
                return n;
            }
            finally {
                SyncList.this.afterRead(wasInterrupted);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void set(Object o) {
            try {
                SyncList.this.wr_.acquire();
                try {
                    this.baseListIterator().set(o);
                }
                finally {
                    SyncList.this.wr_.release();
                }
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                throw new UnsupportedOperationException();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(Object o) {
            try {
                SyncList.this.wr_.acquire();
                try {
                    this.baseListIterator().add(o);
                }
                finally {
                    SyncList.this.wr_.release();
                }
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                throw new UnsupportedOperationException();
            }
        }
    }
}

