/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.concurrent50;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedSet;
import jeus.util.concurrent50.NavigableMap;
import jeus.util.concurrent50.NavigableSet;
import jeus.util.concurrent50.TreeMap;

public class TreeSet
extends AbstractSet
implements NavigableSet,
Cloneable,
Serializable {
    private transient NavigableMap m;
    private static final Object PRESENT = new Object();
    private static final long serialVersionUID = -2479143000061671589L;

    private TreeSet(NavigableMap m) {
        this.m = m;
    }

    public TreeSet() {
        this(new TreeMap());
    }

    public TreeSet(Comparator comparator) {
        this(new TreeMap(comparator));
    }

    public TreeSet(Collection c) {
        this();
        this.addAll(c);
    }

    public TreeSet(SortedSet s) {
        this(s.comparator());
        this.addAll((Collection)s);
    }

    public Iterator iterator() {
        return this.m.keySet().iterator();
    }

    public Iterator descendingIterator() {
        return this.m.descendingKeySet().iterator();
    }

    public int size() {
        return this.m.size();
    }

    public boolean isEmpty() {
        return this.m.isEmpty();
    }

    public boolean contains(Object o) {
        return this.m.containsKey(o);
    }

    public boolean add(Object e) {
        return this.m.put(e, PRESENT) == null;
    }

    public boolean remove(Object o) {
        return this.m.remove(o) == PRESENT;
    }

    public void clear() {
        this.m.clear();
    }

    public boolean addAll(Collection c) {
        if (this.m.size() == 0 && c.size() > 0 && c instanceof SortedSet && this.m instanceof TreeMap) {
            Comparator mc;
            SortedSet set = (SortedSet)c;
            TreeMap map = (TreeMap)this.m;
            Comparator cc = set.comparator();
            if (cc == (mc = map.comparator()) || cc != null && ((Object)cc).equals(mc)) {
                map.addAllForTreeSet(set, PRESENT);
                return true;
            }
        }
        return super.addAll(c);
    }

    public NavigableSet navigableSubSet(Object fromElement, Object toElement) {
        return new TreeSet(this.m.navigableSubMap(fromElement, toElement));
    }

    public NavigableSet navigableHeadSet(Object toElement) {
        return new TreeSet(this.m.navigableHeadMap(toElement));
    }

    public NavigableSet navigableTailSet(Object fromElement) {
        return new TreeSet(this.m.navigableTailMap(fromElement));
    }

    public SortedSet subSet(Object fromElement, Object toElement) {
        return new TreeSet(this.m.navigableSubMap(fromElement, toElement));
    }

    public SortedSet headSet(Object toElement) {
        return new TreeSet(this.m.navigableHeadMap(toElement));
    }

    public SortedSet tailSet(Object fromElement) {
        return new TreeSet(this.m.navigableTailMap(fromElement));
    }

    public Comparator comparator() {
        return this.m.comparator();
    }

    public Object first() {
        return this.m.firstKey();
    }

    public Object last() {
        return this.m.lastKey();
    }

    public Object lower(Object e) {
        return this.m.lowerKey(e);
    }

    public Object floor(Object e) {
        return this.m.floorKey(e);
    }

    public Object ceiling(Object e) {
        return this.m.ceilingKey(e);
    }

    public Object higher(Object e) {
        return this.m.higherKey(e);
    }

    public Object pollFirst() {
        Map.Entry e = this.m.pollFirstEntry();
        return e == null ? null : e.getKey();
    }

    public Object pollLast() {
        Map.Entry e = this.m.pollLastEntry();
        return e == null ? null : e.getKey();
    }

    public Object clone() {
        TreeSet clone = null;
        try {
            clone = (TreeSet)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
        clone.m = new TreeMap(this.m);
        return clone;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeObject(this.m.comparator());
        s.writeInt(this.m.size());
        Iterator i = this.m.keySet().iterator();
        while (i.hasNext()) {
            s.writeObject(i.next());
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        Comparator c = (Comparator)s.readObject();
        TreeMap tm = c == null ? new TreeMap() : new TreeMap(c);
        this.m = tm;
        int size = s.readInt();
        tm.readTreeSet(size, s, PRESENT);
    }
}

