/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.concurrent50.concurrent;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import jeus.util.concurrent50.concurrent.Callable;
import jeus.util.concurrent50.concurrent.CancellationException;
import jeus.util.concurrent50.concurrent.ExecutionException;
import jeus.util.concurrent50.concurrent.ExecutorCompletionService;
import jeus.util.concurrent50.concurrent.ExecutorService;
import jeus.util.concurrent50.concurrent.Future;
import jeus.util.concurrent50.concurrent.FutureTask;
import jeus.util.concurrent50.concurrent.RunnableFuture;
import jeus.util.concurrent50.concurrent.TimeUnit;
import jeus.util.concurrent50.concurrent.TimeoutException;
import jeus.util.concurrent50.concurrent.helpers.Utils;

public abstract class AbstractExecutorService
implements ExecutorService {
    protected RunnableFuture newTaskFor(Runnable runnable, Object value) {
        return new FutureTask(runnable, value);
    }

    protected RunnableFuture newTaskFor(Callable callable) {
        return new FutureTask(callable);
    }

    public Future submit(Runnable task) {
        if (task == null) {
            throw new NullPointerException();
        }
        RunnableFuture ftask = this.newTaskFor(task, null);
        this.execute(ftask);
        return ftask;
    }

    public Future submit(Runnable task, Object result) {
        if (task == null) {
            throw new NullPointerException();
        }
        RunnableFuture ftask = this.newTaskFor(task, result);
        this.execute(ftask);
        return ftask;
    }

    public Future submit(Callable task) {
        if (task == null) {
            throw new NullPointerException();
        }
        RunnableFuture ftask = this.newTaskFor(task);
        this.execute(ftask);
        return ftask;
    }

    /*
     * Unable to fully structure code
     */
    private Object doInvokeAny(Collection tasks, boolean timed, long nanos) throws InterruptedException, ExecutionException, TimeoutException {
        block18: {
            if (tasks == null) {
                throw new NullPointerException();
            }
            ntasks = tasks.size();
            if (ntasks == 0) {
                throw new IllegalArgumentException();
            }
            futures = new ArrayList<Future>(ntasks);
            ecs = new ExecutorCompletionService(this);
            ee = null;
            lastTime = timed != false ? Utils.nanoTime() : 0L;
            it = tasks.iterator();
            futures.add(ecs.submit((Callable)it.next()));
            --ntasks;
            active = 1;
            while (true) lbl-1000:
            // 4 sources

            {
                if ((f = ecs.poll()) == null) {
                    if (ntasks > 0) {
                        --ntasks;
                        futures.add(ecs.submit((Callable)it.next()));
                        ++active;
                    } else {
                        if (active == 0) ** break;
                        if (timed) {
                            f = ecs.poll(nanos, TimeUnit.NANOSECONDS);
                            if (f == null) {
                                throw new TimeoutException();
                            }
                            now = Utils.nanoTime();
                            nanos -= now - lastTime;
                            lastTime = now;
                        } else {
                            f = ecs.take();
                        }
                    }
                }
                if (f == null) continue;
                --active;
                try {
                    now = f.get();
                    return now;
                }
                catch (InterruptedException ie) {
                    throw ie;
                }
                catch (ExecutionException eex) {
                    ee = eex;
                }
                catch (RuntimeException rex) {
                    ee = new ExecutionException(rex);
                    continue;
                }
                break;
            }
            ** GOTO lbl-1000
            if (ee != null) break block18;
            ee = new ExecutionException();
        }
        throw ee;
        finally {
            f = futures.iterator();
            while (f.hasNext()) {
                ((Future)f.next()).cancel(true);
            }
        }
    }

    public Object invokeAny(Collection tasks) throws InterruptedException, ExecutionException {
        try {
            return this.doInvokeAny(tasks, false, 0L);
        }
        catch (TimeoutException cannotHappen) {
            return null;
        }
    }

    public Object invokeAny(Collection tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.doInvokeAny(tasks, true, unit.toNanos(timeout));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List invokeAll(Collection tasks) throws InterruptedException {
        if (tasks == null) {
            throw new NullPointerException();
        }
        ArrayList<RunnableFuture> futures = new ArrayList<RunnableFuture>(tasks.size());
        boolean done = false;
        try {
            Future f;
            Iterator t = tasks.iterator();
            while (t.hasNext()) {
                f = this.newTaskFor((Callable)t.next());
                futures.add((RunnableFuture)f);
                this.execute((Runnable)((Object)f));
            }
            Iterator i = futures.iterator();
            while (i.hasNext()) {
                f = (Future)i.next();
                if (f.isDone()) continue;
                try {
                    f.get();
                }
                catch (CancellationException ignore) {
                }
                catch (ExecutionException ignore) {}
            }
            done = true;
            ArrayList<RunnableFuture> arrayList = futures;
            return arrayList;
        }
        finally {
            if (!done) {
                Iterator i = futures.iterator();
                while (i.hasNext()) {
                    Future f = (Future)i.next();
                    f.cancel(true);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List invokeAll(Collection tasks, long timeout, TimeUnit unit) throws InterruptedException {
        if (tasks == null || unit == null) {
            throw new NullPointerException();
        }
        long nanos = unit.toNanos(timeout);
        ArrayList<RunnableFuture> futures = new ArrayList<RunnableFuture>(tasks.size());
        boolean done = false;
        try {
            Iterator t = tasks.iterator();
            while (t.hasNext()) {
                futures.add(this.newTaskFor((Callable)t.next()));
            }
            long lastTime = Utils.nanoTime();
            Iterator it = futures.iterator();
            while (it.hasNext()) {
                this.execute((Runnable)it.next());
                long now = Utils.nanoTime();
                lastTime = now;
                if ((nanos -= now - lastTime) > 0L) continue;
                ArrayList<RunnableFuture> arrayList = futures;
                return arrayList;
            }
            Iterator i = futures.iterator();
            while (i.hasNext()) {
                Future f = (Future)i.next();
                if (f.isDone()) continue;
                if (nanos <= 0L) {
                    ArrayList<RunnableFuture> arrayList = futures;
                    return arrayList;
                }
                try {
                    f.get(nanos, TimeUnit.NANOSECONDS);
                }
                catch (CancellationException ignore) {
                }
                catch (ExecutionException ignore) {
                }
                catch (TimeoutException toe) {
                    ArrayList<RunnableFuture> arrayList = futures;
                    if (!done) {
                        Iterator i2 = futures.iterator();
                        while (i2.hasNext()) {
                            Future f2 = (Future)i2.next();
                            f2.cancel(true);
                        }
                    }
                    return arrayList;
                }
                long now = Utils.nanoTime();
                nanos -= now - lastTime;
                lastTime = now;
            }
            done = true;
            ArrayList<RunnableFuture> arrayList = futures;
            return arrayList;
        }
        finally {
            if (!done) {
                Iterator i = futures.iterator();
                while (i.hasNext()) {
                    Future f = (Future)i.next();
                    f.cancel(true);
                }
            }
        }
    }
}

