/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.concurrent50.concurrent;

import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import jeus.util.concurrent50.NavigableSet;
import jeus.util.concurrent50.concurrent.ConcurrentSkipListMap;

public class ConcurrentSkipListSet
extends AbstractSet
implements NavigableSet,
Cloneable,
Serializable {
    private static final long serialVersionUID = -2479143111061671589L;
    private final ConcurrentSkipListMap m;

    public ConcurrentSkipListSet() {
        this.m = new ConcurrentSkipListMap();
    }

    public ConcurrentSkipListSet(Comparator comparator) {
        this.m = new ConcurrentSkipListMap(comparator);
    }

    public ConcurrentSkipListSet(Collection c) {
        this.m = new ConcurrentSkipListMap();
        this.addAll(c);
    }

    public ConcurrentSkipListSet(SortedSet s) {
        this.m = new ConcurrentSkipListMap(s.comparator());
        this.addAll(s);
    }

    public Object clone() {
        ConcurrentSkipListSet clone = null;
        try {
            clone = (ConcurrentSkipListSet)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
        clone.m.initialize();
        clone.addAll(this);
        return clone;
    }

    public int size() {
        return this.m.size();
    }

    public boolean isEmpty() {
        return this.m.isEmpty();
    }

    public boolean contains(Object o) {
        return this.m.containsKey(o);
    }

    public boolean add(Object e) {
        return this.m.putIfAbsent(e, Boolean.TRUE) == null;
    }

    public boolean remove(Object o) {
        return this.m.removep(o);
    }

    public void clear() {
        this.m.clear();
    }

    public Iterator iterator() {
        return this.m.keyIterator();
    }

    public Iterator descendingIterator() {
        return this.m.descendingKeyIterator();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Set)) {
            return false;
        }
        Collection c = (Collection)o;
        try {
            return this.containsAll(c) && c.containsAll(this);
        }
        catch (ClassCastException unused) {
            return false;
        }
        catch (NullPointerException unused) {
            return false;
        }
    }

    public boolean removeAll(Collection c) {
        boolean modified = false;
        Iterator i = c.iterator();
        while (i.hasNext()) {
            if (!this.remove(i.next())) continue;
            modified = true;
        }
        return modified;
    }

    public Object lower(Object e) {
        return this.m.lowerKey(e);
    }

    public Object floor(Object e) {
        return this.m.floorKey(e);
    }

    public Object ceiling(Object e) {
        return this.m.ceilingKey(e);
    }

    public Object higher(Object e) {
        return this.m.higherKey(e);
    }

    public Object pollFirst() {
        return this.m.pollFirstKey();
    }

    public Object pollLast() {
        return this.m.pollLastKey();
    }

    public Comparator comparator() {
        return this.m.comparator();
    }

    public Object first() {
        return this.m.firstKey();
    }

    public Object last() {
        return this.m.lastKey();
    }

    public NavigableSet navigableSubSet(Object fromElement, Object toElement) {
        return new ConcurrentSkipListSubSet(this.m, fromElement, toElement);
    }

    public NavigableSet navigableHeadSet(Object toElement) {
        return new ConcurrentSkipListSubSet(this.m, null, toElement);
    }

    public NavigableSet navigableTailSet(Object fromElement) {
        return new ConcurrentSkipListSubSet(this.m, fromElement, null);
    }

    public SortedSet subSet(Object fromElement, Object toElement) {
        return this.navigableSubSet(fromElement, toElement);
    }

    public SortedSet headSet(Object toElement) {
        return this.navigableHeadSet(toElement);
    }

    public SortedSet tailSet(Object fromElement) {
        return this.navigableTailSet(fromElement);
    }

    static class ConcurrentSkipListSubSet
    extends AbstractSet
    implements NavigableSet,
    Serializable {
        private static final long serialVersionUID = -7647078645896651609L;
        private final ConcurrentSkipListMap.ConcurrentSkipListSubMap s;

        ConcurrentSkipListSubSet(ConcurrentSkipListMap map, Object fromElement, Object toElement) {
            this.s = new ConcurrentSkipListMap.ConcurrentSkipListSubMap(map, fromElement, toElement);
        }

        public NavigableSet navigableSubSet(Object fromElement, Object toElement) {
            if (!this.s.inOpenRange(fromElement) || !this.s.inOpenRange(toElement)) {
                throw new IllegalArgumentException("element out of range");
            }
            return new ConcurrentSkipListSubSet(this.s.getMap(), fromElement, toElement);
        }

        public NavigableSet navigableHeadSet(Object toElement) {
            Object least = this.s.getLeast();
            if (!this.s.inOpenRange(toElement)) {
                throw new IllegalArgumentException("element out of range");
            }
            return new ConcurrentSkipListSubSet(this.s.getMap(), least, toElement);
        }

        public NavigableSet navigableTailSet(Object fromElement) {
            Object fence = this.s.getFence();
            if (!this.s.inOpenRange(fromElement)) {
                throw new IllegalArgumentException("element out of range");
            }
            return new ConcurrentSkipListSubSet(this.s.getMap(), fromElement, fence);
        }

        public SortedSet subSet(Object fromElement, Object toElement) {
            return this.navigableSubSet(fromElement, toElement);
        }

        public SortedSet headSet(Object toElement) {
            return this.navigableHeadSet(toElement);
        }

        public SortedSet tailSet(Object fromElement) {
            return this.navigableTailSet(fromElement);
        }

        public int size() {
            return this.s.size();
        }

        public boolean isEmpty() {
            return this.s.isEmpty();
        }

        public boolean contains(Object o) {
            return this.s.containsKey(o);
        }

        public void clear() {
            this.s.clear();
        }

        public Object first() {
            return this.s.firstKey();
        }

        public Object last() {
            return this.s.lastKey();
        }

        public Object ceiling(Object e) {
            return this.s.ceilingKey(e);
        }

        public Object lower(Object e) {
            return this.s.lowerKey(e);
        }

        public Object floor(Object e) {
            return this.s.floorKey(e);
        }

        public Object higher(Object e) {
            return this.s.higherKey(e);
        }

        public boolean remove(Object o) {
            return this.s.remove(o) == Boolean.TRUE;
        }

        public boolean add(Object e) {
            return this.s.put(e, Boolean.TRUE) == null;
        }

        public Comparator comparator() {
            return this.s.comparator();
        }

        public Iterator iterator() {
            return this.s.keySet().iterator();
        }

        public Iterator descendingIterator() {
            return this.s.descendingKeySet().iterator();
        }

        public Object pollFirst() {
            Map.Entry e = this.s.pollFirstEntry();
            return e == null ? null : e.getKey();
        }

        public Object pollLast() {
            Map.Entry e = this.s.pollLastEntry();
            return e == null ? null : e.getKey();
        }
    }
}

