/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.concurrent50.concurrent;

import java.security.AccessController;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import jeus.util.concurrent50.concurrent.AbstractExecutorService;
import jeus.util.concurrent50.concurrent.BlockingQueue;
import jeus.util.concurrent50.concurrent.Executors;
import jeus.util.concurrent50.concurrent.Future;
import jeus.util.concurrent50.concurrent.RejectedExecutionException;
import jeus.util.concurrent50.concurrent.RejectedExecutionHandler;
import jeus.util.concurrent50.concurrent.ThreadFactory;
import jeus.util.concurrent50.concurrent.TimeUnit;
import jeus.util.concurrent50.concurrent.helpers.Utils;
import jeus.util.concurrent50.concurrent.locks.ReentrantLock;

public class ThreadPoolExecutor
extends AbstractExecutorService {
    private static final Runnable[] EMPTY_RUNNABLE_ARRAY = new Runnable[0];
    private static final RuntimePermission shutdownPerm = new RuntimePermission("modifyThread");
    protected final BlockingQueue workQueue;
    protected final Object mainLock = new Object();
    protected final HashSet workers = new HashSet();
    private volatile long keepAliveTime;
    private boolean allowCoreThreadTimeOut;
    protected volatile int corePoolSize;
    private volatile int maximumPoolSize;
    protected volatile int poolSize;
    protected volatile int runState;
    protected static final int RUNNING = 0;
    static final int SHUTDOWN = 1;
    static final int STOP = 2;
    static final int TERMINATED = 3;
    private volatile RejectedExecutionHandler handler;
    private volatile ThreadFactory threadFactory;
    private int largestPoolSize;
    private long completedTaskCount;
    private static final RejectedExecutionHandler defaultHandler = new AbortPolicy();

    protected void reject(Runnable command) {
        this.handler.rejectedExecution(command, this);
    }

    private Thread addThread(Runnable firstTask) {
        Worker w = new Worker(firstTask);
        Thread t = this.threadFactory.newThread(w);
        if (t != null) {
            w.thread = t;
            this.workers.add(w);
            int nt = ++this.poolSize;
            if (nt > this.largestPoolSize) {
                this.largestPoolSize = nt;
            }
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean addIfUnderCorePoolSize(Runnable firstTask) {
        Thread t = null;
        Object object = this.mainLock;
        synchronized (object) {
            if (this.poolSize < this.corePoolSize) {
                t = this.addThread(firstTask);
            }
        }
        if (t == null) {
            return false;
        }
        t.start();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Runnable addIfUnderMaximumPoolSize(Runnable firstTask) {
        Thread t = null;
        Runnable next = null;
        Object object = this.mainLock;
        synchronized (object) {
            if (this.poolSize < this.maximumPoolSize) {
                next = (Runnable)this.workQueue.poll();
                if (next == null) {
                    next = firstTask;
                }
                t = this.addThread(next);
            }
        }
        if (t == null) {
            return null;
        }
        t.start();
        return next;
    }

    Runnable getTask() {
        while (true) {
            try {
                block8: while (true) {
                    switch (this.runState) {
                        case 0: {
                            if (this.poolSize <= this.corePoolSize && !this.allowCoreThreadTimeOut) {
                                return (Runnable)this.workQueue.take();
                            }
                            long timeout = this.keepAliveTime;
                            if (timeout <= 0L) {
                                return null;
                            }
                            Runnable r = (Runnable)this.workQueue.poll(timeout, TimeUnit.NANOSECONDS);
                            if (r != null) {
                                return r;
                            }
                            if (this.poolSize <= this.corePoolSize && !this.allowCoreThreadTimeOut) continue block8;
                            return null;
                        }
                        case 1: {
                            Runnable r = (Runnable)this.workQueue.poll();
                            if (r != null) {
                                return r;
                            }
                            if (this.workQueue.isEmpty()) {
                                this.interruptIdleWorkers();
                                return null;
                            }
                            return (Runnable)this.workQueue.take();
                        }
                        case 2: {
                            return null;
                        }
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void interruptIdleWorkers() {
        Object object = this.mainLock;
        synchronized (object) {
            Iterator itr = this.workers.iterator();
            while (itr.hasNext()) {
                Worker w = (Worker)itr.next();
                w.interruptIfIdle();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void workerDone(Worker w) {
        Object object = this.mainLock;
        synchronized (object) {
            this.completedTaskCount += w.completedTasks;
            this.workers.remove(w);
            if (--this.poolSize > 0) {
                return;
            }
            int state = this.runState;
            if (state != 2) {
                if (!this.workQueue.isEmpty()) {
                    Thread t = this.addThread(null);
                    if (t != null) {
                        t.start();
                    }
                    return;
                }
                if (state == 0) {
                    return;
                }
            }
            this.mainLock.notifyAll();
            this.runState = 3;
        }
        this.terminated();
    }

    public ThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue workQueue) {
        this(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, Executors.defaultThreadFactory(), defaultHandler);
    }

    public ThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue workQueue, ThreadFactory threadFactory) {
        this(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, defaultHandler);
    }

    public ThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue workQueue, RejectedExecutionHandler handler) {
        this(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, Executors.defaultThreadFactory(), handler);
    }

    public ThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue workQueue, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        if (corePoolSize < 0 || maximumPoolSize <= 0 || maximumPoolSize < corePoolSize || keepAliveTime < 0L) {
            throw new IllegalArgumentException();
        }
        if (workQueue == null || threadFactory == null || handler == null) {
            throw new NullPointerException();
        }
        this.corePoolSize = corePoolSize;
        this.maximumPoolSize = maximumPoolSize;
        this.workQueue = workQueue;
        this.keepAliveTime = unit.toNanos(keepAliveTime);
        this.threadFactory = threadFactory;
        this.handler = handler;
    }

    public void execute(Runnable command) {
        Runnable r;
        if (command == null) {
            throw new NullPointerException();
        }
        do {
            if (this.runState != 0) {
                this.reject(command);
                return;
            }
            if (this.poolSize < this.corePoolSize && this.addIfUnderCorePoolSize(command)) {
                return;
            }
            if (this.workQueue.offer(command)) {
                return;
            }
            r = this.addIfUnderMaximumPoolSize(command);
            if (r != command) continue;
            return;
        } while (r != null);
        this.reject(command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            AccessController.checkPermission(shutdownPerm);
        }
        boolean fullyTerminated = false;
        Object object = this.mainLock;
        synchronized (object) {
            if (this.workers.size() > 0) {
                int state;
                if (security != null) {
                    Iterator itr = this.workers.iterator();
                    while (itr.hasNext()) {
                        Worker w = (Worker)itr.next();
                        security.checkAccess(w.thread);
                    }
                }
                if ((state = this.runState) == 0) {
                    this.runState = 1;
                }
                try {
                    Iterator itr = this.workers.iterator();
                    while (itr.hasNext()) {
                        Worker w = (Worker)itr.next();
                        w.interruptIfIdle();
                    }
                }
                catch (SecurityException se) {
                    this.runState = state;
                    throw se;
                }
            } else {
                fullyTerminated = true;
                this.runState = 3;
                this.mainLock.notifyAll();
            }
        }
        if (fullyTerminated) {
            this.terminated();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List shutdownNow() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            AccessController.checkPermission(shutdownPerm);
        }
        boolean fullyTerminated = false;
        Object object = this.mainLock;
        synchronized (object) {
            if (this.workers.size() > 0) {
                int state;
                if (security != null) {
                    Iterator itr = this.workers.iterator();
                    while (itr.hasNext()) {
                        Worker w = (Worker)itr.next();
                        security.checkAccess(w.thread);
                    }
                }
                if ((state = this.runState) != 3) {
                    this.runState = 2;
                }
                try {
                    Iterator itr = this.workers.iterator();
                    while (itr.hasNext()) {
                        Worker w = (Worker)itr.next();
                        w.interruptNow();
                    }
                }
                catch (SecurityException se) {
                    this.runState = state;
                    throw se;
                }
            } else {
                fullyTerminated = true;
                this.runState = 3;
                this.mainLock.notifyAll();
            }
        }
        if (fullyTerminated) {
            this.terminated();
        }
        return Arrays.asList(this.workQueue.toArray(EMPTY_RUNNABLE_ARRAY));
    }

    public boolean isShutdown() {
        return this.runState != 0;
    }

    public boolean isTerminating() {
        return this.runState == 2;
    }

    public boolean isTerminated() {
        return this.runState == 3;
    }

    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        long nanos = unit.toNanos(timeout);
        Object object = this.mainLock;
        synchronized (object) {
            long deadline = Utils.nanoTime() + nanos;
            while (true) {
                if (this.runState == 3) {
                    return true;
                }
                if (nanos <= 0L) {
                    return false;
                }
                TimeUnit.NANOSECONDS.timedWait(this.mainLock, nanos);
                nanos = deadline - Utils.nanoTime();
            }
        }
    }

    protected void finalize() {
        this.shutdown();
    }

    public void setThreadFactory(ThreadFactory threadFactory) {
        if (threadFactory == null) {
            throw new NullPointerException();
        }
        this.threadFactory = threadFactory;
    }

    public ThreadFactory getThreadFactory() {
        return this.threadFactory;
    }

    public void setRejectedExecutionHandler(RejectedExecutionHandler handler) {
        if (handler == null) {
            throw new NullPointerException();
        }
        this.handler = handler;
    }

    public RejectedExecutionHandler getRejectedExecutionHandler() {
        return this.handler;
    }

    public BlockingQueue getQueue() {
        return this.workQueue;
    }

    public boolean remove(Runnable task) {
        return this.getQueue().remove(task);
    }

    public void purge() {
        try {
            Iterator it = this.getQueue().iterator();
            while (it.hasNext()) {
                Future c;
                Runnable r = (Runnable)it.next();
                if (!(r instanceof Future) || !(c = (Future)((Object)r)).isCancelled()) continue;
                it.remove();
            }
        }
        catch (ConcurrentModificationException ex) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCorePoolSize(int corePoolSize) {
        if (corePoolSize < 0) {
            throw new IllegalArgumentException();
        }
        Object object = this.mainLock;
        synchronized (object) {
            int extra = this.corePoolSize - corePoolSize;
            this.corePoolSize = corePoolSize;
            if (extra < 0) {
                Thread t;
                int n = this.workQueue.size();
                while (extra++ < 0 && n-- > 0 && this.poolSize < corePoolSize && (t = this.addThread(null)) != null) {
                    t.start();
                }
            } else if (extra > 0 && this.poolSize > corePoolSize) {
                Iterator it = this.workers.iterator();
                while (it.hasNext() && extra-- > 0 && this.poolSize > corePoolSize && this.workQueue.remainingCapacity() == 0) {
                    ((Worker)it.next()).interruptIfIdle();
                }
            }
        }
    }

    public int getCorePoolSize() {
        return this.corePoolSize;
    }

    public boolean prestartCoreThread() {
        return this.addIfUnderCorePoolSize(null);
    }

    public int prestartAllCoreThreads() {
        int n = 0;
        while (this.addIfUnderCorePoolSize(null)) {
            ++n;
        }
        return n;
    }

    public boolean allowsCoreThreadTimeOut() {
        return this.allowCoreThreadTimeOut;
    }

    public void allowCoreThreadTimeOut(boolean value) {
        if (value && this.keepAliveTime <= 0L) {
            throw new IllegalArgumentException("Core threads must have nonzero keep alive times");
        }
        this.allowCoreThreadTimeOut = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaximumPoolSize(int maximumPoolSize) {
        if (maximumPoolSize <= 0 || maximumPoolSize < this.corePoolSize) {
            throw new IllegalArgumentException();
        }
        Object object = this.mainLock;
        synchronized (object) {
            int extra;
            this.maximumPoolSize = maximumPoolSize;
            if (extra > 0 && this.poolSize > maximumPoolSize) {
                Iterator it = this.workers.iterator();
                for (extra = this.maximumPoolSize - maximumPoolSize; it.hasNext() && extra > 0 && this.poolSize > maximumPoolSize; --extra) {
                    ((Worker)it.next()).interruptIfIdle();
                }
            }
        }
    }

    public int getMaximumPoolSize() {
        return this.maximumPoolSize;
    }

    public void setKeepAliveTime(long time, TimeUnit unit) {
        if (time < 0L) {
            throw new IllegalArgumentException();
        }
        if (time == 0L && this.allowsCoreThreadTimeOut()) {
            throw new IllegalArgumentException("Core threads must have nonzero keep alive times");
        }
        this.keepAliveTime = unit.toNanos(time);
    }

    public long getKeepAliveTime(TimeUnit unit) {
        return unit.convert(this.keepAliveTime, TimeUnit.NANOSECONDS);
    }

    public int getPoolSize() {
        return this.poolSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getActiveCount() {
        Object object = this.mainLock;
        synchronized (object) {
            int n = 0;
            Iterator itr = this.workers.iterator();
            while (itr.hasNext()) {
                Worker w = (Worker)itr.next();
                if (!w.isActive()) continue;
                ++n;
            }
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLargestPoolSize() {
        Object object = this.mainLock;
        synchronized (object) {
            return this.largestPoolSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTaskCount() {
        Object object = this.mainLock;
        synchronized (object) {
            long n = this.completedTaskCount;
            Iterator itr = this.workers.iterator();
            while (itr.hasNext()) {
                Worker w = (Worker)itr.next();
                n += w.completedTasks;
                if (!w.isActive()) continue;
                ++n;
            }
            return n + (long)this.workQueue.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getCompletedTaskCount() {
        Object object = this.mainLock;
        synchronized (object) {
            long n = this.completedTaskCount;
            Iterator itr = this.workers.iterator();
            while (itr.hasNext()) {
                Worker w = (Worker)itr.next();
                n += w.completedTasks;
            }
            return n;
        }
    }

    protected void beforeExecute(Thread t, Runnable r) {
    }

    protected void afterExecute(Runnable r, Throwable t) {
    }

    protected void terminated() {
    }

    public static class DiscardOldestPolicy
    implements RejectedExecutionHandler {
        public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
            if (!e.isShutdown()) {
                e.getQueue().poll();
                e.execute(r);
            }
        }
    }

    public static class DiscardPolicy
    implements RejectedExecutionHandler {
        public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
        }
    }

    public static class AbortPolicy
    implements RejectedExecutionHandler {
        public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
            throw new RejectedExecutionException();
        }
    }

    public static class CallerRunsPolicy
    implements RejectedExecutionHandler {
        public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
            if (!e.isShutdown()) {
                r.run();
            }
        }
    }

    public class Worker
    implements Runnable {
        private final ReentrantLock runLock = new ReentrantLock();
        private Runnable firstTask;
        volatile long completedTasks;
        public Thread thread;

        Worker(Runnable firstTask) {
            this.firstTask = firstTask;
        }

        public boolean isActive() {
            return this.runLock.isLocked();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void interruptIfIdle() {
            ReentrantLock runLock = this.runLock;
            if (runLock.tryLock()) {
                try {
                    this.thread.interrupt();
                }
                finally {
                    runLock.unlock();
                }
            }
        }

        void interruptNow() {
            this.thread.interrupt();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void runTask(Runnable task) {
            ReentrantLock runLock = this.runLock;
            runLock.lock();
            try {
                Thread.interrupted();
                if (ThreadPoolExecutor.this.runState == 2) {
                    return;
                }
                boolean ran = false;
                ThreadPoolExecutor.this.beforeExecute(this.thread, task);
                try {
                    task.run();
                    ran = true;
                    ThreadPoolExecutor.this.afterExecute(task, null);
                    ++this.completedTasks;
                }
                catch (RuntimeException ex) {
                    if (!ran) {
                        ThreadPoolExecutor.this.afterExecute(task, ex);
                    }
                    throw ex;
                }
            }
            finally {
                runLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                Runnable task = this.firstTask;
                this.firstTask = null;
                while (task != null || (task = ThreadPoolExecutor.this.getTask()) != null) {
                    this.runTask(task);
                    task = null;
                }
            }
            finally {
                ThreadPoolExecutor.this.workerDone(this);
            }
        }
    }
}

