/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.concurrent50.concurrent.locks;

import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import jeus.util.concurrent50.concurrent.TimeUnit;
import jeus.util.concurrent50.concurrent.helpers.FIFOWaitQueue;
import jeus.util.concurrent50.concurrent.helpers.WaitQueue;
import jeus.util.concurrent50.concurrent.locks.CondVar;
import jeus.util.concurrent50.concurrent.locks.Condition;

class FIFOCondVar
extends CondVar
implements Condition,
Serializable {
    private static final WaitQueue.QueuedSync sync = new WaitQueue.QueuedSync(){

        public boolean recheck(WaitQueue.WaitNode node) {
            return false;
        }

        public void takeOver(WaitQueue.WaitNode node) {
        }
    };
    private final WaitQueue wq = new FIFOWaitQueue();

    FIFOCondVar(CondVar.ExclusiveLock lock) {
        super(lock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void awaitUninterruptibly() {
        if (!this.lock.isHeldByCurrentThread()) {
            throw new IllegalMonitorStateException();
        }
        WaitQueue.WaitNode n = new WaitQueue.WaitNode();
        this.wq.insert(n);
        this.lock.unlock();
        try {
            n.doWaitUninterruptibly(sync);
        }
        finally {
            this.lock.lock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void await() throws InterruptedException {
        if (!this.lock.isHeldByCurrentThread()) {
            throw new IllegalMonitorStateException();
        }
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        WaitQueue.WaitNode n = new WaitQueue.WaitNode();
        this.wq.insert(n);
        this.lock.unlock();
        try {
            n.doWait(sync);
        }
        finally {
            this.lock.lock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
        if (!this.lock.isHeldByCurrentThread()) {
            throw new IllegalMonitorStateException();
        }
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        long nanos = unit.toNanos(timeout);
        WaitQueue.WaitNode n = new WaitQueue.WaitNode();
        this.wq.insert(n);
        boolean success = false;
        this.lock.unlock();
        try {
            success = n.doTimedWait(sync, nanos);
        }
        finally {
            this.lock.lock();
        }
        return success;
    }

    public boolean awaitUntil(Date deadline) throws InterruptedException {
        if (deadline == null) {
            throw new NullPointerException();
        }
        long abstime = deadline.getTime();
        long start = System.currentTimeMillis();
        long msecs = abstime - start;
        return this.await(msecs, TimeUnit.MILLISECONDS);
    }

    public void signal() {
        WaitQueue.WaitNode w;
        if (!this.lock.isHeldByCurrentThread()) {
            throw new IllegalMonitorStateException();
        }
        do {
            if ((w = this.wq.extract()) != null) continue;
            return;
        } while (!w.signal(sync));
    }

    public void signalAll() {
        if (!this.lock.isHeldByCurrentThread()) {
            throw new IllegalMonitorStateException();
        }
        WaitQueue.WaitNode w;
        while ((w = this.wq.extract()) != null) {
            w.signal(sync);
        }
        return;
    }

    protected boolean hasWaiters() {
        if (!this.lock.isHeldByCurrentThread()) {
            throw new IllegalMonitorStateException();
        }
        return this.wq.hasNodes();
    }

    protected int getWaitQueueLength() {
        if (!this.lock.isHeldByCurrentThread()) {
            throw new IllegalMonitorStateException();
        }
        return this.wq.getLength();
    }

    protected Collection getWaitingThreads() {
        if (!this.lock.isHeldByCurrentThread()) {
            throw new IllegalMonitorStateException();
        }
        return this.wq.getWaitingThreads();
    }
}

