/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.logging;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class JeusLogRecord
extends LogRecord {
    protected static final ArrayList keys = new ArrayList();
    private static final ThreadLocal threadIds = new ThreadLocal();
    public static String JVM_ID = "client";

    public JeusLogRecord(Level level, String msg) {
        super(level, msg);
        this.setThreadName();
    }

    public void setThreadName() {
        if (threadIds.get() == null) {
            int threadID = this.getThreadID();
            threadIds.set(new Integer(threadID));
            Thread t = Thread.currentThread();
            String name = t.getName() + " [" + JVM_ID + "-" + threadID + "]";
            t.setName(name);
        }
    }

    public Map getLogInfo() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("level", this.getLevel());
        map.put("message", this.getMessage());
        map.put("millis", new Long(this.getMillis()));
        map.put("loggerName", this.getLoggerName());
        map.put("threadID", new Integer(this.getThreadID()));
        return map;
    }

    static {
        keys.add("level");
        keys.add("message");
        keys.add("millis");
        keys.add("loggerName");
        keys.add("threadID");
    }
}

