/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.logging;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import jeus.util.EnvironmentCall;
import jeus.util.JeusBootstrapPropertyValues;
import jeus.util.JeusLocalizedException;
import jeus.util.JeusRuntimeException;
import jeus.util.logging.CommanderFormatter;
import jeus.util.logging.ConsoleHandler;
import jeus.util.logging.ErrorLogRecord;
import jeus.util.logging.JeusFormatter;
import jeus.util.logging.JeusHandler;
import jeus.util.logging.JeusLevel;
import jeus.util.logging.Journal;
import jeus.util.logging.SimpleFormatter;
import jeus.util.logging.SmtpHandler;
import jeus.util.properties.JeusLoggerProperties;

public class JeusLogger
extends Logger
implements Journal {
    private static final Properties loggerProperties = new Properties();
    protected static final HashMap loggerMap = new HashMap();
    private static final HashSet configurableLoggers = new HashSet();
    private static final HashMap presets = new HashMap();
    private static boolean adjustGlobalHandlerLevel;
    private SmtpHandler smtpHandler;
    private boolean isPredefinedLevel;
    protected boolean printEnvRoot;
    private boolean setLevel;
    public static final String ACCESS_LOGGER_NAME = "jeus.webaccess";
    static /* synthetic */ Class class$jeus$util$logging$SimpleFormatter;
    static /* synthetic */ Class class$java$util$logging$Logger;

    private static void setupPresets(Properties props) {
        String value = props.getProperty("logging.preset.names");
        if (value == null) {
            return;
        }
        String[] names = value.split("\\s");
        for (int i = 0; i < names.length; ++i) {
            String hanlderName = props.getProperty(names[i] + ".handler");
            if (hanlderName == null) continue;
            String formatterName = props.getProperty(names[i] + ".formatter");
            String properties = props.getProperty(names[i] + ".properties");
            Map property = JeusLogger.setupHandler(hanlderName, formatterName, properties);
            presets.put(names[i], property);
        }
    }

    private static Map setupHandler(String handlerName, String formatterName, String pros) {
        HashMap<String, String> propertyMap = new HashMap<String, String>();
        propertyMap.put("handler", handlerName);
        propertyMap.put("formatter", formatterName == null ? (class$jeus$util$logging$SimpleFormatter == null ? (class$jeus$util$logging$SimpleFormatter = JeusLogger.class$("jeus.util.logging.SimpleFormatter")) : class$jeus$util$logging$SimpleFormatter).getName() : formatterName);
        String[] properties = pros == null ? new String[]{} : pros.split(",");
        for (int i = 0; i < properties.length; ++i) {
            String value = properties[i].trim();
            int index = value.indexOf("=");
            if (index <= 0 || index >= value.length()) continue;
            propertyMap.put(value.substring(0, index), value.substring(index + 1));
        }
        return propertyMap;
    }

    protected JeusLogger(String name) {
        super(name, null);
        this.setOwnLevel(Level.INFO);
    }

    public void setLevel(Level newLevel) {
        this.setLevel = true;
        super.setLevel(newLevel);
        String loggerName = this.getName();
        if (this.isConfigurableLogger(loggerName)) {
            Enumeration<String> e = LogManager.getLogManager().getLoggerNames();
            while (e.hasMoreElements()) {
                Logger childLogger;
                String childLoggerName = e.nextElement();
                if (!childLoggerName.startsWith(loggerName) || childLoggerName.equals(loggerName) || this.isConfigurableLogger(childLoggerName) || !((childLogger = Logger.getLogger(childLoggerName)) instanceof JeusLogger)) continue;
                JeusLogger childJeusLogger = (JeusLogger)childLogger;
                if (childJeusLogger.setLevel) continue;
                JeusLogger.setLevelWithParentLogger(childJeusLogger);
            }
        }
    }

    private boolean isConfigurableLogger(String loggerName) {
        Iterator i = configurableLoggers.iterator();
        while (i.hasNext()) {
            String configurableLoggerName = (String)i.next();
            if (!loggerName.equals(configurableLoggerName) && !loggerName.equals("jeus")) continue;
            return true;
        }
        return false;
    }

    public String getLoggerName() {
        return this.getName();
    }

    public boolean isLoggable(int level) {
        Level curLevel = this.getLevel();
        return level != Integer.MAX_VALUE && curLevel != null && level >= curLevel.intValue();
    }

    public void info(String message, Throwable t) {
        if (!this.isLoggable(Level.INFO)) {
            return;
        }
        this.log(Level.INFO, message, t);
    }

    public void warning(String message, Throwable t) {
        if (!this.isLoggable(Level.WARNING)) {
            return;
        }
        this.log(Level.WARNING, message, t);
    }

    public void severe(String message, Throwable t) {
        if (!this.isLoggable(Level.SEVERE)) {
            return;
        }
        this.log(Level.SEVERE, message, t);
    }

    public void log(String message) {
        this.directLog(message);
    }

    public void log(String msg, Throwable t) {
        this.directLog(msg, t);
    }

    public void log(Level level, int msgNum) {
        if (!this.isLoggable(level)) {
            return;
        }
        ErrorLogRecord lr = new ErrorLogRecord(level, msgNum);
        lr.setLoggerName(this.getName());
        this.log(lr);
    }

    public void log(Level level, int msgNum, Object param1) {
        if (!this.isLoggable(level)) {
            return;
        }
        ErrorLogRecord lr = new ErrorLogRecord(level, msgNum);
        Object[] params = new Object[]{param1};
        lr.setParameters(params);
        lr.setLoggerName(this.getName());
        this.log(lr);
    }

    public void log(Level level, int msgNum, Object[] params) {
        if (!this.isLoggable(level)) {
            return;
        }
        ErrorLogRecord lr = new ErrorLogRecord(level, msgNum);
        lr.setParameters(params);
        lr.setLoggerName(this.getName());
        this.log(lr);
    }

    public void log(Level level, int msgNum, Throwable thrown) {
        JeusLocalizedException ex;
        int exNum;
        if (!this.isLoggable(level)) {
            return;
        }
        Object[] params = null;
        if (thrown instanceof JeusLocalizedException && (exNum = (ex = (JeusLocalizedException)((Object)thrown)).getMessageNumber()) > 0) {
            msgNum = exNum;
            params = ex.getParameters();
        }
        ErrorLogRecord lr = new ErrorLogRecord(level, msgNum);
        lr.setThrown(thrown);
        lr.setParameters(params);
        lr.setLoggerName(this.getName());
        this.log(lr);
    }

    public void log(Level level, int msgNum, Object param1, Throwable thrown) {
        Object[] params;
        if (!this.isLoggable(level)) {
            return;
        }
        if (thrown instanceof JeusLocalizedException) {
            JeusLocalizedException ex = (JeusLocalizedException)((Object)thrown);
            int exNum = ex.getMessageNumber();
            if (exNum > 0) {
                msgNum = exNum;
                params = ex.getParameters();
            } else {
                params = new Object[]{param1};
            }
        } else {
            params = new Object[]{param1};
        }
        ErrorLogRecord lr = new ErrorLogRecord(level, msgNum);
        lr.setParameters(params);
        lr.setThrown(thrown);
        lr.setLoggerName(this.getName());
        this.log(lr);
    }

    public void log(Level level, int msgNum, Object[] params, Throwable thrown) {
        JeusLocalizedException ex;
        int exNum;
        if (!this.isLoggable(level)) {
            return;
        }
        if (thrown instanceof JeusLocalizedException && (exNum = (ex = (JeusLocalizedException)((Object)thrown)).getMessageNumber()) > 0) {
            msgNum = exNum;
            params = ex.getParameters();
        }
        ErrorLogRecord lr = new ErrorLogRecord(level, msgNum);
        lr.setParameters(params);
        lr.setThrown(thrown);
        lr.setLoggerName(this.getName());
        this.log(lr);
    }

    public void logp(Level level, String sourceClass, String sourceMethod, int msgNum, Object param, Throwable thrown) {
        this.logp(level, sourceClass, sourceMethod, msgNum, new Object[]{param}, thrown);
    }

    public void logp(Level level, String sourceClass, String sourceMethod, int msgNum, Object[] params, Throwable thrown) {
        JeusLocalizedException ex;
        int exNum;
        if (!this.isLoggable(level)) {
            return;
        }
        if (thrown instanceof JeusLocalizedException && (exNum = (ex = (JeusLocalizedException)((Object)thrown)).getMessageNumber()) > 0) {
            msgNum = exNum;
            params = ex.getParameters();
        }
        ErrorLogRecord lr = new ErrorLogRecord(level, msgNum);
        lr.setParameters(params);
        lr.setThrown(thrown);
        lr.setSourceClassName(sourceClass);
        lr.setSourceMethodName(sourceMethod);
        lr.setLoggerName(this.getName());
        this.log(lr);
    }

    public void logp(Level level, String sourceClass, String sourceMethod, int msgNum) {
        if (!this.isLoggable(level)) {
            return;
        }
        ErrorLogRecord lr = new ErrorLogRecord(level, msgNum);
        lr.setSourceClassName(sourceClass);
        lr.setSourceMethodName(sourceMethod);
        lr.setLoggerName(this.getName());
        this.log(lr);
    }

    public void logp(Level level, String sourceClass, String sourceMethod, int msgNum, Object param1) {
        if (!this.isLoggable(level)) {
            return;
        }
        ErrorLogRecord lr = new ErrorLogRecord(level, msgNum);
        Object[] params = new Object[]{param1};
        lr.setParameters(params);
        lr.setSourceClassName(sourceClass);
        lr.setSourceMethodName(sourceMethod);
        lr.setLoggerName(this.getName());
        this.log(lr);
    }

    public void logp(Level level, String sourceClass, String sourceMethod, int msgNum, Object[] params) {
        if (!this.isLoggable(level)) {
            return;
        }
        ErrorLogRecord lr = new ErrorLogRecord(level, msgNum);
        lr.setParameters(params);
        lr.setSourceClassName(sourceClass);
        lr.setSourceMethodName(sourceMethod);
        lr.setLoggerName(this.getName());
        this.log(lr);
    }

    public void logp(Level level, String sourceClass, String sourceMethod, int msgNum, Throwable thrown) {
        JeusLocalizedException ex;
        int exNum;
        if (!this.isLoggable(level)) {
            return;
        }
        Object[] params = null;
        if (thrown instanceof JeusLocalizedException && (exNum = (ex = (JeusLocalizedException)((Object)thrown)).getMessageNumber()) > 0) {
            msgNum = exNum;
            params = ex.getParameters();
        }
        ErrorLogRecord lr = new ErrorLogRecord(level, msgNum);
        lr.setThrown(thrown);
        lr.setSourceClassName(sourceClass);
        lr.setParameters(params);
        lr.setSourceMethodName(sourceMethod);
        lr.setLoggerName(this.getName());
        this.log(lr);
    }

    private void log(ErrorLogRecord record) {
        Filter filter = this.getFilter();
        if (filter != null && !filter.isLoggable(record)) {
            return;
        }
        if (this.printEnvRoot) {
            record.setAppName(EnvironmentCall.getEnvName());
        }
        for (Logger logger = this; logger != null; logger = logger.getParent()) {
            Handler[] targets = logger.getHandlers();
            if (targets != null) {
                for (int i = 0; i < targets.length; ++i) {
                    targets[i].publish(record);
                }
            }
            if (!logger.getUseParentHandlers()) break;
        }
    }

    public void directLog(String msg) {
        this.log(Level.SEVERE, msg);
    }

    public void directLog(String msg, Throwable t) {
        this.directLog(msg);
        this.directLog(t);
    }

    public void directLog(Throwable t) {
        this.directLog(t.toString());
        StackTraceElement[] trace = t.getStackTrace();
        for (int i = 0; i < trace.length; ++i) {
            this.directLog("\tat " + trace[i]);
        }
    }

    public void debug(String msg) {
        this.log(JeusLevel.DEBUG, msg);
    }

    public void dev(String msg) {
        this.log(JeusLevel.DEV, msg);
    }

    public int getLogLevel() {
        return this.getLevel().intValue();
    }

    public void setLogLevel(int level) {
        this.setLevel(JeusLevel.getTempLevel(level));
    }

    public void debug(String msg, Throwable e) {
        this.log(JeusLevel.DEBUG, "msg", e);
    }

    public void debugp(String msg) {
        this.log(JeusLevel.DEV, "[" + Thread.currentThread() + "]" + msg);
    }

    public static JeusLogger createDefaultJeusLogger(String name) {
        JeusLogger logger = (JeusLogger)JeusLogger.getLogger(name);
        logger.setUseParentHandlers(false);
        Handler handler = JeusLogger.getDefaultHandler();
        logger.addHandler(handler);
        return logger;
    }

    private static Handler getDefaultHandler() {
        ConsoleHandler handler = new ConsoleHandler();
        handler.setProperty(Collections.EMPTY_MAP);
        handler.setLevel(Level.ALL);
        SimpleFormatter formatter = new SimpleFormatter();
        formatter.setProperty(Collections.EMPTY_MAP);
        handler.setFormatter(formatter);
        return handler;
    }

    public static JeusLogger createDefaultConsoleJeusLogger(String name) {
        JeusLogger logger = (JeusLogger)JeusLogger.getLogger(name);
        Handler[] handlers = logger.getHandlers();
        for (int i = 0; i < handlers.length; ++i) {
            Handler handler = handlers[i];
            logger.removeHandler(handler);
        }
        logger.setUseParentHandlers(false);
        ConsoleHandler h = new ConsoleHandler();
        h.setLevel(Level.ALL);
        CommanderFormatter formatter = new CommanderFormatter();
        formatter.setProperty(Collections.EMPTY_MAP);
        h.setFormatter(formatter);
        logger.addHandler(h);
        return logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Logger getLogger(String name) {
        Class clazz = class$java$util$logging$Logger == null ? (class$java$util$logging$Logger = JeusLogger.class$("java.util.logging.Logger")) : class$java$util$logging$Logger;
        synchronized (clazz) {
            JeusLogger logger = (JeusLogger)loggerMap.get(name);
            if (logger != null) {
                return logger;
            }
            return JeusLogger.initializeLogger(name, new JeusLogger(name));
        }
    }

    public static Logger initializeLogger(String name, JeusLogger logger) {
        int ix2;
        if (name.startsWith("jeus.servlet")) {
            logger.printEnvRoot = true;
        }
        String predefinedLevelString = null;
        int ix = 1;
        while ((ix2 = name.indexOf(".", ix)) >= 0) {
            String pname = name.substring(0, ix2);
            String loggerLevel = JeusLogger.getLogLevel(pname);
            if (loggerLevel != null) {
                predefinedLevelString = loggerLevel;
                JeusLogger.getLogger(pname);
            }
            ix = ix2 + 1;
        }
        String loggerLevel = JeusLogger.getLogLevel(name);
        if (loggerLevel != null) {
            predefinedLevelString = loggerLevel;
        }
        LogManager.getLogManager().addLogger(logger);
        loggerMap.put(name, logger);
        if (predefinedLevelString != null) {
            predefinedLevelString = predefinedLevelString.trim();
            Level predefinedLevel = JeusLevel.parse(predefinedLevelString);
            logger.setPredefinedLevel(predefinedLevel);
            JeusLogger.setAllHandlerLevel(predefinedLevel, Logger.getLogger(""));
        } else {
            JeusLogger.setLevelWithParentLogger(logger);
        }
        JeusLogger.addHandler(name, logger);
        return logger;
    }

    protected void setPredefinedLevel(Level predefinedLevel) {
        this.setLevel(predefinedLevel);
        this.isPredefinedLevel = true;
    }

    public static String getLogLevel(String pname) {
        String loggerLevel = System.getProperty(pname + ".log.level");
        if (loggerLevel != null) {
            return loggerLevel;
        }
        loggerLevel = loggerProperties.getProperty(pname + ".level");
        if (loggerLevel != null) {
            return loggerLevel;
        }
        return LogManager.getLogManager().getProperty(pname + ".level");
    }

    protected static void addHandler(String name, JeusLogger logger) {
        Formatter formatter;
        String f;
        String preset = loggerProperties.getProperty(name + ".preset");
        if (presets.containsKey(preset)) {
            JeusLogger.setupLogger(logger, preset);
        }
        if ((f = loggerProperties.getProperty(name + ".formatter")) != null) {
            try {
                formatter = (Formatter)Class.forName(f).newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
                formatter = new SimpleFormatter();
            }
        } else {
            return;
        }
        String handlers = loggerProperties.getProperty(name + ".handlers");
        if (handlers != null) {
            StringTokenizer tokenizer = new StringTokenizer(handlers, ",");
            while (tokenizer.hasMoreTokens()) {
                String handlerName = tokenizer.nextToken();
                try {
                    Handler handler = (Handler)Class.forName(handlerName).newInstance();
                    handler.setLevel(logger.getLevel());
                    handler.setFormatter(formatter);
                    logger.addHandler(handler);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static void setupLogger(JeusLogger logger, String preset) {
        Map property = (Map)presets.get(preset);
        String handlerName = (String)property.get("handler");
        String formatterName = (String)property.get("formatter");
        try {
            JeusFormatter formatter = (JeusFormatter)Class.forName(formatterName).newInstance();
            JeusHandler handler = (JeusHandler)Class.forName(handlerName).newInstance();
            formatter.setProperty(Collections.EMPTY_MAP);
            handler.setProperty(property);
            handler.setFormatter(formatter);
            if (!property.containsKey("level")) {
                handler.setLevel(logger.getLevel());
            }
            logger.addHandler(handler);
        }
        catch (Exception e) {
            e.printStackTrace();
            presets.remove(preset);
        }
    }

    protected static void setAllHandlerLevel(Level preDefinedLevel, Logger logger) {
        if (adjustGlobalHandlerLevel) {
            Handler[] handlers = logger.getHandlers();
            for (int i = 0; i < handlers.length; ++i) {
                Handler handler = handlers[i];
                Level handlerLevel = handler.getLevel();
                if (preDefinedLevel.intValue() >= handlerLevel.intValue()) continue;
                handler.setLevel(preDefinedLevel);
            }
        }
    }

    protected static void setLevelWithParentLogger(Logger logger) {
        for (Logger parentLogger = logger.getParent(); parentLogger != null; parentLogger = parentLogger.getParent()) {
            if (!(parentLogger instanceof JeusLogger)) {
                JeusLogger.setAllHandlerLevel(logger.getLevel(), parentLogger);
                break;
            }
            String parentLoggerName = parentLogger.getName();
            if (!parentLoggerName.equals("jeus") && !configurableLoggers.contains(parentLoggerName)) continue;
            ((JeusLogger)logger).setOwnLevel(parentLogger.getLevel());
            break;
        }
    }

    private void setOwnLevel(Level level) {
        if (!this.setLevel) {
            super.setLevel(level);
        }
    }

    public void close() {
        Handler[] handlers = this.getHandlers();
        for (int i = 0; i < handlers.length; ++i) {
            Handler handler = handlers[i];
            handler.close();
            this.removeHandler(handler);
        }
    }

    public void flush() {
        Handler[] handlers = this.getHandlers();
        for (int i = 0; i < handlers.length; ++i) {
            Handler handler = handlers[i];
            handler.flush();
        }
    }

    public void directLog2(String msg, boolean flush) {
        System.out.print(msg);
        if (flush) {
            System.out.flush();
        }
    }

    public static String[] getLoggerNames() {
        Set keySet = loggerMap.keySet();
        return keySet.toArray(new String[keySet.size()]);
    }

    public void setSmtpHandler(Handler handler) {
        this.smtpHandler = (SmtpHandler)handler;
    }

    public SmtpHandler getSmtpHandler() {
        return this.smtpHandler;
    }

    private SmtpHandler getValidSmtpHandler() {
        if (this.smtpHandler != null) {
            return this.smtpHandler;
        }
        SmtpHandler currentHandler = null;
        for (Logger currentLogger = this.getParent(); currentLogger != null; currentLogger = currentLogger.getParent()) {
            if (currentLogger instanceof JeusLogger) {
                currentHandler = ((JeusLogger)currentLogger).getSmtpHandler();
            }
            if (currentHandler == null) continue;
            return currentHandler;
        }
        return null;
    }

    public void sendEmailNotification(Level severe, String msg) {
        this.sendEmailNotification(severe, null, msg, null);
    }

    public void sendEmailNotification(Level severe, String msg, Throwable e) {
        this.sendEmailNotification(severe, null, msg, e);
    }

    public void sendEmailNotification(Level severe, String subject, String msg) {
        this.sendEmailNotification(severe, subject, msg, null);
    }

    public void sendEmailNotification(Level severe, String subject, String msg, Throwable e) {
        SmtpHandler validSmtpHandler = this.getValidSmtpHandler();
        if (validSmtpHandler != null) {
            ErrorLogRecord record = new ErrorLogRecord(severe, subject, msg);
            record.setThrown(e);
            record.setLoggerName(this.getName());
            validSmtpHandler.publish(record);
        }
    }

    public void resetLevelSetting() {
        this.setLevel = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JeusLogger[] getChilden(String loggerName) {
        ArrayList list = new ArrayList();
        Class clazz = class$java$util$logging$Logger == null ? (class$java$util$logging$Logger = JeusLogger.class$("java.util.logging.Logger")) : class$java$util$logging$Logger;
        synchronized (clazz) {
            Iterator i = loggerMap.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                String name = (String)entry.getKey();
                if (!name.startsWith(loggerName) || name.equals(loggerName)) continue;
                list.add(entry.getValue());
            }
        }
        return list.toArray(new JeusLogger[list.size()]);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(64);
        buf.append('[').append(this.getName()).append(':').append(this.getLevel()).append(']');
        Handler[] handlers = this.getHandlers();
        for (int i = 0; i < handlers.length; ++i) {
            buf.append(handlers[i]);
            if (i == handlers.length - 1) continue;
            buf.append(',');
        }
        return buf.toString();
    }

    public static void removeConfigurableLoggerList(String loggerName) {
        configurableLoggers.remove(loggerName);
    }

    public static void addConfigurableLoggerList(String loggerName) {
        configurableLoggers.add(loggerName);
    }

    public boolean doesUsePredefinedLevel() {
        return this.isPredefinedLevel;
    }

    public static HashSet getConfigurableLoggers() {
        return configurableLoggers;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        configurableLoggers.add("jeus.systemuser");
        configurableLoggers.add("jeus.ejb");
        configurableLoggers.add("jeus.servlet");
        configurableLoggers.add("jeus.jms");
        String configurableLoggerNames = JeusBootstrapPropertyValues.getSystemProperty((String)"jeus.logger.configurable");
        if (configurableLoggerNames != null) {
            StringTokenizer tokenizer = new StringTokenizer(configurableLoggerNames, ",");
            configurableLoggers.addAll(Collections.list(tokenizer));
        }
        String adjustGlobalHandlerLevel = JeusBootstrapPropertyValues.getSystemProperty((String)"logger.adjustGlobalLevel", (String)"true");
        JeusLogger.adjustGlobalHandlerLevel = adjustGlobalHandlerLevel.equalsIgnoreCase("true");
        try {
            File propertyFile;
            File presetFile = new File(JeusLoggerProperties.LOGGING_PRESETS);
            if (presetFile.exists()) {
                BufferedInputStream is = new BufferedInputStream(new FileInputStream(presetFile));
                Properties presets = new Properties();
                presets.load(is);
                JeusLogger.setupPresets(presets);
            }
            if ((propertyFile = new File(JeusLoggerProperties.LOGGING_PROPERTIES)).exists()) {
                BufferedInputStream is = new BufferedInputStream(new FileInputStream(propertyFile));
                loggerProperties.load(is);
            }
            JeusLogger.createDefaultJeusLogger("jeus");
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new JeusRuntimeException(e);
        }
    }
}

