/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.net;

import java.io.IOException;
import java.net.AbstractJeusTransSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketImpl;
import jeus.util.net.JeusNetUtil;
import jeus.util.net.TransSocketConstants;

public class JeusTransSocket
extends AbstractJeusTransSocket
implements TransSocketConstants {
    private static int JDK_VERSION;
    private boolean isCloseMethodCalled;

    JeusTransSocket() throws SocketException {
    }

    JeusTransSocket(int localPort) throws SocketException {
        super(localPort);
    }

    JeusTransSocket(Socket sock) {
        super(sock);
    }

    protected SocketImpl getSocketImpl(Socket sock) {
        return this.getSocketImpl0(sock);
    }

    public void sendfd(int to, int pid) throws IOException {
        int ret = this.sendfd0(to, pid);
        if (ret < 0) {
            switch (ret) {
                case -1: {
                    throw new IOException("dup error");
                }
                case -2: {
                    throw new IOException("send error");
                }
            }
            throw new IOException("unknown error");
        }
    }

    public void recvfd(int from) throws IOException {
        int ret = this.recvfd0(from);
        if (ret < 0) {
            switch (ret) {
                case -1: {
                    throw new IOException("socket closed");
                }
                case -2: {
                    throw new IOException("recv socket error");
                }
                case -3: {
                    throw new IOException("invalid msg type");
                }
                case -4: {
                    throw new IOException("recv socket error2");
                }
                case -10: {
                    throw new IOException("resource temporarily unavailable");
                }
            }
            throw new IOException("unknown recv socket error");
        }
    }

    public static void initProto() {
        JeusTransSocket.initProto0(JDK_VERSION);
    }

    public static native int getfd(Socket var0) throws SocketException;

    private native int sendfd0(int var1, int var2) throws IOException;

    private native int recvfd0(int var1) throws IOException;

    public static native void initProto0(int var0);

    private native SocketImpl getSocketImpl0(Socket var1);

    public synchronized void close() throws IOException {
        if (!this.isCloseMethodCalled) {
            this.isCloseMethodCalled = true;
            super.close();
        }
    }

    static {
        try {
            Class.forName("java.net.SocketAddress");
            JDK_VERSION = 14;
        }
        catch (Exception e) {
            JDK_VERSION = 13;
        }
        boolean aa = JeusNetUtil.pipeSupported;
        JeusTransSocket.initProto();
    }
}

